/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extension_service.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.repository.CLIServerCommandLogRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.telephony.pbx.repository.VipMasterRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.extension_service.model.ServiceCodeAttribute;
import com.coraltele.service.pbx.extension_service.model.ServiceCodeModel;
import com.coraltele.service.uc.service.CustomerAccountService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class ExtensionsServicesService {
    private static final Logger logger = LogManager.getLogger(ExtensionsServicesService.class);
    @Autowired
    private ExtensionsServicesRepository extensionsServicesRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;
    @Autowired
    VipMasterRepository vipMasterRepository;
    @Autowired
    CLIServerCommandLogRepository cLIServerCommandLogRepository;
    @Autowired
    CustomerAccountService customerAccountService;

    public boolean checkExtensionsServicesFromGivenRange(ServiceCodeAttribute range) {
        for (int i = Integer.parseInt(range.getFrom()); i <= Integer.parseInt(range.getTo()); ++i) {
            List extensionsServices = this.extensionsServicesRepository.findByExtension(String.valueOf(i));
            if (!extensionsServices.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean checkExtensionsServicesFromGivenRange1(ServiceCodeAttribute range) {
        for (int i = Integer.parseInt(range.getFrom()); i <= Integer.parseInt(range.getTo()); ++i) {
            List extensionsServices = this.extensionsServicesRepository.findByExtension(String.valueOf(i));
            if (extensionsServices.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionEmpty(String extension) {
        return this.extensionsServicesRepository.findAllByExtension(extension).isEmpty();
    }

    public void createCheckedExtensionService(ServiceCodeAttribute extensionRange, int i) {
        ExtensionsServices extensionsServices;
        if (extensionRange.getCfa() != null && !extensionRange.getCfa().isEmpty()) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setData(extensionRange.getCfa());
            extensionsServices.setServiceCode("fwd-all");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getEcfa() != null && !extensionRange.getEcfa().isEmpty()) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("ext-fwd-all");
            extensionsServices.setData(extensionRange.getEcfa());
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getCfb() != null && !extensionRange.getCfb().isEmpty()) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setData(extensionRange.getCfb());
            extensionsServices.setServiceCode("fwd-busy");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getEcfb() != null && !extensionRange.getEcfb().isEmpty()) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("ext-fwd-busy");
            extensionsServices.setData(extensionRange.getEcfb());
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getEcfna() != null) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("ext-fwd-no-ans");
            extensionsServices.setData(extensionRange.getEcfna());
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getIsd() != null && extensionRange.getIsd().equals("true")) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("dialing-isd");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getStd() != null && extensionRange.getStd().equals("true")) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("dialing-std");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getLocal() != null && extensionRange.getLocal().equals("true")) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("dialing-local");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getFm() != null && !extensionRange.getFm().isEmpty()) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setData(extensionRange.getFm());
            extensionsServices.setServiceCode("follow-me");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getDnd() != null && extensionRange.getDnd().equals("true")) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("dnd");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getDid() != null) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("did");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getDod() != null) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("dod");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getVideoCall() != null) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("videoCall");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getCfna() != null && !extensionRange.getCfna().isEmpty()) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setData(extensionRange.getCfna());
            extensionsServices.setServiceCode("fwd-no-ans");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (extensionRange.getIntercom() != null && extensionRange.getIntercom().equals("true")) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(String.valueOf(i));
            extensionsServices.setServiceCode("dialing-intercom");
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
    }

    public void createCheckedExtensionService2(ServiceCodeAttribute extensionRange, int i) {
        if (CustomerAccountService.getClickToCall()) {
            CLIServerCommandLog cliServerCommandLog;
            if (extensionRange.getIntercom() != null && extensionRange.getIntercom().equals("true")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dial intercom on", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dial intercom on", (Object)i);
            } else if (extensionRange.getIntercom() == null || extensionRange.getIntercom().equals("false")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dial intercom off", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dial intercom off", (Object)i);
            }
            if (extensionRange.getDnd() != null && extensionRange.getDnd().equals("true")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dnd on", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dnd on", (Object)i);
            } else if (extensionRange.getDnd() == null || extensionRange.getDnd().equals("false")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dnd off", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dnd off", (Object)i);
            }
            if (extensionRange.getLocal() != null && extensionRange.getLocal().equals("true")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dial local on", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dial local on", (Object)i);
            } else if (extensionRange.getLocal() == null || extensionRange.getLocal().equals("false")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dial local off", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dial local off", (Object)i);
            }
            if (extensionRange.getStd() != null && extensionRange.getStd().equals("true")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dial std on", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dial std on", (Object)i);
            } else if (extensionRange.getStd() == null || extensionRange.getStd().equals("false")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dial std off", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dial std off", (Object)i);
            }
            if (extensionRange.getIsd() != null && extensionRange.getIsd().equals("true")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dial isd on", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dial isd on", (Object)i);
            } else if (extensionRange.getIsd() == null || extensionRange.getIsd().equals("false")) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d dial isd off", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} dial isd off", (Object)i);
            }
            if (extensionRange.getCfa() != null && !extensionRange.getCfa().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d cfa %s", i, extensionRange.getCfa()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} cfa {}", (Object)i, (Object)extensionRange.getCfa());
            } else if (extensionRange.getCfa() == null || extensionRange.getCfa().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d cfa reset", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} cfa reset", (Object)i);
            }
            if (extensionRange.getEcfa() != null && !extensionRange.getEcfa().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d ecfa %s", i, extensionRange.getEcfa()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} ecfa {}", (Object)i, (Object)extensionRange.getEcfa());
            } else if (extensionRange.getEcfa() == null || extensionRange.getEcfa().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d ecfa reset", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} ecfa reset", (Object)i);
            }
            if (extensionRange.getCfb() != null && !extensionRange.getCfb().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d cfb %s", i, extensionRange.getCfb()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} cfb {}", (Object)i, (Object)extensionRange.getCfb());
            } else if (extensionRange.getCfb() == null || extensionRange.getCfb().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d cfb reset", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} cfb reset", (Object)i);
            }
            if (extensionRange.getEcfb() != null && !extensionRange.getEcfb().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d ecfb %s", i, extensionRange.getEcfb()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} ecfb {}", (Object)i, (Object)extensionRange.getEcfb());
            } else if (extensionRange.getEcfb() == null || extensionRange.getEcfb().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d ecfb reset", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} ecfb reset", (Object)i);
            }
            if (extensionRange.getEcfna() != null && !extensionRange.getEcfna().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d ecfna %s", i, extensionRange.getEcfna()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} ecfna {}", (Object)i, (Object)extensionRange.getEcfna());
            } else if (extensionRange.getEcfna() == null || extensionRange.getEcfna().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d ecfna reset", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} ecfna reset", (Object)i);
            }
            if (extensionRange.getFm() != null && !extensionRange.getFm().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d fm %s", i, extensionRange.getFm()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} fm {}", (Object)i, (Object)extensionRange.getFm());
            } else if (extensionRange.getFm() == null || extensionRange.getFm().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d fm reset", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} fm reset", (Object)i);
            }
            if (extensionRange.getCfna() != null && !extensionRange.getCfna().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d cfna %s", i, extensionRange.getCfna()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} cfna {}", (Object)i, (Object)extensionRange.getCfna());
            } else if (extensionRange.getCfna() == null || extensionRange.getCfna().isEmpty()) {
                cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("extension update %d cfna reset", i));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info("extension update {} cfna reset", (Object)i);
            }
        } else {
            this.deleteAllExtension(String.valueOf(i));
            this.createCheckedExtensionService(extensionRange, i);
        }
    }

    public void createSingleExtensionService2(ServiceCodeAttribute extensionRange, int i) {
        logger.debug("Create extension {}", (Object)extensionRange);
        this.createCheckedExtensionService2(extensionRange, i);
    }

    public void createSingleExtensionService(ServiceCodeAttribute extensionRange, int i) {
        logger.debug("Create extension {}", (Object)extensionRange);
        this.createCheckedExtensionService(extensionRange, i);
    }

    public void createMultipleExtensionServices(ServiceCodeAttribute extensionRange) {
        logger.debug("Create extension {}", (Object)extensionRange);
        for (int i = Integer.parseInt(extensionRange.getFrom()); i <= Integer.parseInt(extensionRange.getTo()); ++i) {
            this.createCheckedExtensionService(extensionRange, i);
        }
    }

    public RequestResponse deleteByExtension(String extension) {
        logger.debug("Delete extension {}", (Object)extension);
        RequestResponse returnValue = new RequestResponse();
        List list = this.extensionsServicesRepository.findAllByExtension(extension);
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to delete");
            returnValue.setMessageDetail(String.format("Data not found in extensionServices : %s ", extension));
            logger.info(returnValue.getMessage());
        } else {
            for (ExtensionsServices id : list) {
                this.extensionsServicesRepository.deleteById((Object)id.getId());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Deleted");
            returnValue.setMessageDetail("Data deleted successfully");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public void deleteAllExtension(String extension) {
        List list = this.extensionsServicesRepository.findAllByExtension(extension);
        if (!list.isEmpty()) {
            for (ExtensionsServices id : list) {
                this.extensionsServicesRepository.deleteById((Object)id.getId());
            }
        }
    }

    public List<ServiceCodeModel> getCheckedServiceCode(String extension) {
        ArrayList<ServiceCodeModel> returnData = new ArrayList<ServiceCodeModel>();
        List list = this.extensionsServicesRepository.findAllByExtension(extension);
        if (!list.isEmpty()) {
            for (ExtensionsServices row : list) {
                ServiceCodeModel data = new ServiceCodeModel();
                if (row.getServiceCode().equalsIgnoreCase("fwd-all")) {
                    data.setServiceCode("CFA");
                    data.setValue((Object)row.getServiceCode());
                    data.setData(row.getData());
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("ext-fwd-all")) {
                    data.setServiceCode("ECFA");
                    data.setValue((Object)row.getServiceCode());
                    data.setData(row.getData());
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("fwd-busy")) {
                    data.setServiceCode("CFB");
                    data.setValue((Object)row.getServiceCode());
                    data.setData(row.getData());
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("ext-fwd-busy")) {
                    data.setServiceCode("ECFB");
                    data.setValue((Object)row.getServiceCode());
                    data.setData(row.getData());
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("fwd-no-ans")) {
                    data.setServiceCode("CFNA");
                    data.setValue((Object)row.getServiceCode());
                    data.setData(row.getData());
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("ext-fwd-no-ans")) {
                    data.setServiceCode("ECFNA");
                    data.setValue((Object)row.getServiceCode());
                    data.setData(row.getData());
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("dialing-isd")) {
                    data.setServiceCode("ISD");
                    data.setValue((Object)true);
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("dialing-std")) {
                    data.setServiceCode("STD");
                    data.setValue((Object)true);
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("dialing-local")) {
                    data.setServiceCode("LOCAL");
                    data.setValue((Object)true);
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("VM")) {
                    data.setServiceCode("VM");
                    data.setValue((Object)row.getServiceCode());
                    data.setData(row.getData());
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("follow-me")) {
                    data.setServiceCode("FM");
                    data.setValue((Object)row.getServiceCode());
                    data.setData(row.getData());
                    returnData.add(data);
                    continue;
                }
                if (row.getServiceCode().equalsIgnoreCase("dnd")) {
                    data.setServiceCode("DND");
                    data.setValue((Object)true);
                    returnData.add(data);
                    continue;
                }
                if (!row.getServiceCode().equalsIgnoreCase("dialing-intercom")) continue;
                data.setServiceCode("Intercom");
                data.setValue((Object)true);
                returnData.add(data);
            }
        }
        return returnData;
    }

    public void saveData(HttpServletRequest request, ExtensionsServices data, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        try {
            if (data.getId() != null && this.extensionsServicesRepository.findById((Object)data.getId()).isPresent()) {
                Optional oldData = this.extensionsServicesRepository.findById((Object)data.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry compare : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(compare.getKey())) continue;
                        inputValue.setOldValue(compare.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("extensions_services");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public RequestResponse updateServiceCode(String extension, ServiceCodeAttribute data) {
        RequestResponse returnValue = new RequestResponse();
        List list = this.extensionsServicesRepository.findAllByExtension(extension);
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage(" Unable To Update");
            returnValue.setMessageDetail("ServiceCode Data Not Found From ExtensionServices");
        } else {
            for (ExtensionsServices row : list) {
                if (row.getServiceCode().equals("fwd-all") && data.getCfa() != null && !data.getCfa().isEmpty()) {
                    row.setServiceCode("fwd-all");
                    row.setData(extension);
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("ext-fwd-all") && data.getEcfa() != null && !data.getEcfa().isEmpty()) {
                    row.setServiceCode("ext-fwd-all");
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("fwd-busy") && data.getCfb() != null && !data.getCfb().isEmpty()) {
                    row.setServiceCode("fwd-busy");
                    row.setData(extension);
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("ext-fwd-busy") && data.getEcfb() != null && !data.getEcfb().isEmpty()) {
                    row.setServiceCode("ext-fwd-busy");
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("fwd-no-ans") && data.getCfna() != null && !data.getCfna().isEmpty()) {
                    row.setServiceCode("fwd-no-ans");
                    row.setData(extension);
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("ext-fwd-no-ans") && data.getEcfna() != null && !data.getEcfna().isEmpty()) {
                    row.setServiceCode("ext-fwd-no-ans");
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("dialing-isd") && data.getIsd() != null && !data.getIsd().isEmpty()) {
                    row.setServiceCode("dialing-isd");
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("dialing-local") && data.getLocal() != null && !data.getLocal().isEmpty()) {
                    row.setServiceCode("dialing-local");
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("VM") && data.getVm() != null && !data.getVm().isEmpty()) {
                    row.setServiceCode("VM");
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("follow-me") && data.getFm() != null && !data.getFm().isEmpty()) {
                    row.setServiceCode("follow-me");
                    row.setData(extension);
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (row.getServiceCode().equals("dnd") && data.getDnd() != null && !data.getDnd().isEmpty()) {
                    row.setServiceCode("dnd");
                    this.extensionsServicesRepository.save((Object)row);
                }
                if (!row.getServiceCode().equals("dialing-intercom") || data.getIntercom() == null || data.getIntercom().isEmpty()) continue;
                row.setServiceCode("dialing-intercom");
                this.extensionsServicesRepository.save((Object)row);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage(" Successful ");
            returnValue.setMessageDetail("Data Updated For ServiceCode");
        }
        return returnValue;
    }

    public void deleteVipMaster(boolean confUser, String extension) {
        try {
            if (confUser) {
                List vipMaster = this.vipMasterRepository.findByOfficeExtension(extension);
                if (!vipMaster.isEmpty()) {
                    this.vipMasterRepository.deleteAll((Iterable)vipMaster);
                }
            } else {
                List vipMaster = this.vipMasterRepository.findByOfficeExtension(extension);
                if (!vipMaster.isEmpty()) {
                    this.vipMasterRepository.deleteAll((Iterable)vipMaster);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error on delete vipMaster:{}", (Object)e.getMessage());
        }
    }

    public void deleteVm(String extension) {
        List list = this.extensionsServicesRepository.findAllByExtension(extension);
        if (!list.isEmpty()) {
            for (ExtensionsServices id : list) {
                if (!id.getServiceCode().equalsIgnoreCase("vm")) continue;
                this.extensionsServicesRepository.deleteById((Object)id.getId());
            }
        }
    }

    public void deleteDnd(String extension) {
        List list = this.extensionsServicesRepository.findAllByExtension(extension);
        if (!list.isEmpty()) {
            for (ExtensionsServices id : list) {
                if (!id.getServiceCode().equalsIgnoreCase("dnd")) continue;
                this.extensionsServicesRepository.deleteById((Object)id.getId());
            }
        }
    }

    public void deleteAllExtensionExceptVmAndDnd(String extension) {
        List list = this.extensionsServicesRepository.findAllByExtension(extension);
        if (!list.isEmpty()) {
            for (ExtensionsServices id : list) {
                if (id.getServiceCode().equalsIgnoreCase("VM") || id.getServiceCode().equalsIgnoreCase("dnd")) continue;
                this.extensionsServicesRepository.deleteById((Object)id.getId());
            }
        }
    }
}

