/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.service;

import com.coraltele.db.billing.main.entity.view.ViewChannels;
import com.coraltele.db.billing.main.repository.ViewChannelsRepository;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.entity.view.HotelServiceView;
import com.coraltele.db.telephony.pbx.repository.AlarmDetailRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionRegisteredViewRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.telephony.pbx.repository.FeatureCodeHistoryRepository;
import com.coraltele.db.telephony.pbx.repository.HotelServiceViewRepository;
import com.coraltele.db.telephony.pbx.specification.HotelSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.hotel.model.AlarmDetailCreateModel;
import com.coraltele.service.hotel.model.DirtyCleanModel;
import com.coraltele.service.hotel.model.FloorWiseHotelService;
import com.coraltele.service.hotel.model.HotelDropDownModel;
import com.coraltele.service.hotel.model.HotelModel;
import com.coraltele.service.hotel.model.RoomShiftModel;
import com.coraltele.service.hotel.model.UpdateServiceModel;
import com.coraltele.service.hotel.model.ViewChannelsModel;
import com.coraltele.service.hotel.service.AlarmDetailService;
import com.coraltele.service.hotel.service.HmsConfigService;
import com.coraltele.service.pbx.cos.service.InboundCosService;
import com.coraltele.service.pbx.cos.service.OutboundCosService;
import com.coraltele.service.pbx.extension_service.model.ServiceCodeAttribute;
import com.coraltele.service.pbx.extension_service.service.ExtensionsServicesService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class HotelService {
    private final ExtensionRegisteredViewRepository extensionRegisteredViewRepository;
    private static final Logger logger = LogManager.getLogger(HotelService.class);
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    private ExtensionsServicesService extensionsServicesService;
    @Autowired
    private ExtensionsServicesRepository extensionsServicesRepository;
    @Autowired
    HotelServiceViewRepository hotelServiceViewRepository;
    @Autowired
    ViewChannelsRepository viewChannelsRepository;
    @Autowired
    AlarmDetailService alarmDetailService;
    @Autowired
    HmsConfigService hmsConfigService;
    @Autowired
    private OutboundCosService outboundCosService;
    @Autowired
    private InboundCosService inboundCosService;
    @Autowired
    private AlarmDetailRepository alarmDetailRepository;
    @Autowired
    private FeatureCodeHistoryRepository featureCodeHistoryRepository;

    HotelService(ExtensionRegisteredViewRepository extensionRegisteredViewRepository) {
        this.extensionRegisteredViewRepository = extensionRegisteredViewRepository;
    }

    public RequestResponse checkedIn(HotelModel data) {
        RequestResponse returnValue = new RequestResponse();
        String callLevel = this.hmsConfigService.getDefaultLevel();
        logger.info("Call_Level from configuration is:{}", (Object)callLevel);
        if (data.getExtension() == null) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("parameter is required.");
            returnValue.setMessageDetail("Please provide a valid parameter of extension.");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        if (callLevel != null) {
            data.setLevel(Integer.valueOf(Integer.parseInt(callLevel)));
        } else if (data.getLevel() != 0 && data.getLevel() != 3 && data.getLevel() != 4 && data.getLevel() != 5) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid level value!");
            returnValue.setMessageDetail("Please provide a valid level value (0, 3, 4, or 5).");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        Optional extensions = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getExtension(), "phone", "room");
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not register with type phone and subType room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() == 1) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Room Unavailable!");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() == 2) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Already Occupied!");
            returnValue.setMessageDetail("user currently tempCheckOut");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getIsFeedBack().equals(true)) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Room not clean!");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.extensionsServicesService.deleteAllExtension(((Extension)extensions.get()).getExtension());
        if (data.getLevel() == 5) {
            ExtensionsServices extensionsServices = new ExtensionsServices();
            extensionsServices.setServiceCode("dialing-intercom");
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices);
            ExtensionsServices extensionsServices1 = new ExtensionsServices();
            extensionsServices1.setServiceCode("dialing-local");
            extensionsServices1.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices1.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices1);
            ExtensionsServices extensionsServices2 = new ExtensionsServices();
            extensionsServices2.setCreatedOn(LocalDateTime.now());
            extensionsServices2.setServiceCode("dialing-std");
            extensionsServices2.setExtension(((Extension)extensions.get()).getExtension());
            this.extensionsServicesRepository.save((Object)extensionsServices2);
            ExtensionsServices extensionsServices3 = new ExtensionsServices();
            extensionsServices3.setCreatedOn(LocalDateTime.now());
            extensionsServices3.setServiceCode("dialing-isd");
            extensionsServices3.setExtension(((Extension)extensions.get()).getExtension());
            this.extensionsServicesRepository.save((Object)extensionsServices3);
        } else if (data.getLevel() == 4) {
            ExtensionsServices extensionsServices = new ExtensionsServices();
            extensionsServices.setServiceCode("dialing-intercom");
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices);
            ExtensionsServices extensionsServices1 = new ExtensionsServices();
            extensionsServices1.setServiceCode("dialing-local");
            extensionsServices1.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices1.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices1);
            ExtensionsServices extensionsServices2 = new ExtensionsServices();
            extensionsServices2.setCreatedOn(LocalDateTime.now());
            extensionsServices2.setServiceCode("dialing-std");
            extensionsServices2.setExtension(((Extension)extensions.get()).getExtension());
            this.extensionsServicesRepository.save((Object)extensionsServices2);
        } else if (data.getLevel() == 3) {
            ExtensionsServices extensionsServices = new ExtensionsServices();
            extensionsServices.setServiceCode("dialing-intercom");
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices);
            ExtensionsServices extensionsServices1 = new ExtensionsServices();
            extensionsServices1.setServiceCode("dialing-local");
            extensionsServices1.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices1.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices1);
        } else if (data.getLevel() == 0) {
            ExtensionsServices extensionsServices = new ExtensionsServices();
            extensionsServices.setServiceCode("dialing-intercom");
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (data.getExtensionSubType() != null) {
            ((Extension)extensions.get()).setExtensionSubtype(data.getExtensionSubType());
        }
        if (data.getName() != null) {
            ((Extension)extensions.get()).setName(data.getName());
        }
        if (data.getGroupType() != null) {
            ((Extension)extensions.get()).setGroupType(data.getGroupType());
        }
        if (data.getBudget() != null) {
            ((Extension)extensions.get()).setTimeOutInSecond(data.getBudget());
        }
        if (data.getPremiumCustomer() != null) {
            ((Extension)extensions.get()).setPremiumCustomer(data.getPremiumCustomer());
        }
        ((Extension)extensions.get()).setLevel(data.getLevel());
        if (data.getGuestUniqueId() != null && !data.getGuestUniqueId().equals("")) {
            ((Extension)extensions.get()).setUuid(data.getGuestUniqueId());
        } else {
            ((Extension)extensions.get()).setUuid(UUID.randomUUID().toString());
        }
        ((Extension)extensions.get()).setCheckIn(Integer.valueOf(1));
        ((Extension)extensions.get()).setCheckInEpoch(Long.valueOf(System.currentTimeMillis()));
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("User Check in");
        returnValue.setMessageDetail("Data check-in successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse tempCheckedOut(HotelModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getExtension(), "phone", "room");
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not register with type phone and subtype room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() == 2 || ((Extension)extensions.get()).getCheckIn() == 3) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Already check-out!");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() != 1) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Please check-In first");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.extensionsServicesService.deleteAllExtension(((Extension)extensions.get()).getExtension());
        if (data.getExtensionSubType() != null) {
            ((Extension)extensions.get()).setExtensionSubtype(data.getExtensionSubType());
        }
        if (data.getName() != null) {
            ((Extension)extensions.get()).setName(data.getName());
        }
        if (data.getGroupType() != null) {
            ((Extension)extensions.get()).setGroupType(data.getGroupType());
        }
        if (data.getBudget() != null) {
            ((Extension)extensions.get()).setTimeOutInSecond(data.getBudget());
        }
        if (data.getPremiumCustomer() != null) {
            ((Extension)extensions.get()).setPremiumCustomer(data.getPremiumCustomer());
        }
        ((Extension)extensions.get()).setCheckIn(Integer.valueOf(2));
        ((Extension)extensions.get()).setCheckInEpoch(Long.valueOf(System.currentTimeMillis()));
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Temporary check out ");
        returnValue.setMessageDetail("Data check-out successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse tempCheckedIn(HotelModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getExtension(), "phone", "room");
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not register with type phone and subType room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() == 2) {
            this.extensionsServicesService.deleteAllExtension(((Extension)extensions.get()).getExtension());
            if (((Extension)extensions.get()).getLevel() == 5) {
                ExtensionsServices extensionsServices = new ExtensionsServices();
                extensionsServices.setServiceCode("dialing-intercom");
                extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
                extensionsServices.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)extensionsServices);
                ExtensionsServices extensionsServices1 = new ExtensionsServices();
                extensionsServices1.setServiceCode("dialing-local");
                extensionsServices1.setExtension(((Extension)extensions.get()).getExtension());
                extensionsServices1.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)extensionsServices1);
                ExtensionsServices extensionsServices2 = new ExtensionsServices();
                extensionsServices2.setCreatedOn(LocalDateTime.now());
                extensionsServices2.setServiceCode("dialing-std");
                extensionsServices2.setExtension(((Extension)extensions.get()).getExtension());
                this.extensionsServicesRepository.save((Object)extensionsServices2);
                ExtensionsServices extensionsServices3 = new ExtensionsServices();
                extensionsServices3.setCreatedOn(LocalDateTime.now());
                extensionsServices3.setServiceCode("dialing-isd");
                extensionsServices3.setExtension(((Extension)extensions.get()).getExtension());
                this.extensionsServicesRepository.save((Object)extensionsServices3);
            } else if (((Extension)extensions.get()).getLevel() == 4) {
                ExtensionsServices extensionsServices = new ExtensionsServices();
                extensionsServices.setServiceCode("dialing-intercom");
                extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
                extensionsServices.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)extensionsServices);
                ExtensionsServices extensionsServices1 = new ExtensionsServices();
                extensionsServices1.setServiceCode("dialing-local");
                extensionsServices1.setExtension(((Extension)extensions.get()).getExtension());
                extensionsServices1.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)extensionsServices1);
                ExtensionsServices extensionsServices2 = new ExtensionsServices();
                extensionsServices2.setCreatedOn(LocalDateTime.now());
                extensionsServices2.setServiceCode("dialing-std");
                extensionsServices2.setExtension(((Extension)extensions.get()).getExtension());
                this.extensionsServicesRepository.save((Object)extensionsServices2);
            } else if (((Extension)extensions.get()).getLevel() == 3) {
                ExtensionsServices extensionsServices = new ExtensionsServices();
                extensionsServices.setServiceCode("dialing-intercom");
                extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
                extensionsServices.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)extensionsServices);
                ExtensionsServices extensionsServices1 = new ExtensionsServices();
                extensionsServices1.setServiceCode("dialing-local");
                extensionsServices1.setExtension(((Extension)extensions.get()).getExtension());
                extensionsServices1.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)extensionsServices1);
            } else if (((Extension)extensions.get()).getLevel() == 0) {
                ExtensionsServices extensionsServices = new ExtensionsServices();
                extensionsServices.setServiceCode("dialing-intercom");
                extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
                extensionsServices.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)extensionsServices);
            }
            if (data.getExtensionSubType() != null) {
                ((Extension)extensions.get()).setExtensionSubtype(data.getExtensionSubType());
            }
            if (data.getName() != null) {
                ((Extension)extensions.get()).setName(data.getName());
            }
            if (data.getGroupType() != null) {
                ((Extension)extensions.get()).setGroupType(data.getGroupType());
            }
            if (data.getPremiumCustomer() != null) {
                ((Extension)extensions.get()).setPremiumCustomer(data.getPremiumCustomer());
            }
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Not able to temp-Check-in");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        ((Extension)extensions.get()).setCheckIn(Integer.valueOf(1));
        ((Extension)extensions.get()).setCheckInEpoch(Long.valueOf(System.currentTimeMillis()));
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("User Check in");
        returnValue.setMessageDetail("Data check-in successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse checkedOut(HotelModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getExtension(), "phone", "room");
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not register with type phone and subType room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() == 2) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("user TempCheckOut currently!");
            returnValue.setMessageDetail("first tempCheckIn ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() == 0) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("user already check-out!");
            returnValue.setMessageDetail("Room available for check-in");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.alarmDetailService.removeAlarm(data.getExtension());
        this.extensionsServicesService.deleteAllExtension(((Extension)extensions.get()).getExtension());
        ((Extension)extensions.get()).setLevel(Integer.valueOf(0));
        ((Extension)extensions.get()).setName("");
        ((Extension)extensions.get()).setTimeOutInSecond(Integer.valueOf(0));
        ((Extension)extensions.get()).setGroupType("");
        ((Extension)extensions.get()).setPremiumCustomer(Boolean.valueOf(false));
        ((Extension)extensions.get()).setCheckIn(Integer.valueOf(0));
        ((Extension)extensions.get()).setCheckInEpoch(Long.valueOf(0L));
        ((Extension)extensions.get()).setIsFeedBack(Boolean.valueOf(true));
        ((Extension)extensions.get()).setUuid("");
        this.extensionsRepository.save(extensions.get());
        ExtensionsServices extensionsServices = new ExtensionsServices();
        extensionsServices.setServiceCode("dialing-intercom");
        extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
        extensionsServices.setCreatedOn(LocalDateTime.now());
        this.extensionsServicesRepository.save((Object)extensionsServices);
        List lHistories = this.featureCodeHistoryRepository.findByExtension(((Extension)extensions.get()).getExtension());
        if (!lHistories.isEmpty()) {
            this.featureCodeHistoryRepository.deleteAll((Iterable)lHistories);
            logger.info("Deleted {} feature code history records for extension: {}", (Object)lHistories.size(), (Object)((Extension)extensions.get()).getExtension());
        } else {
            logger.info("No feature code history found for extension: {}", (Object)((Extension)extensions.get()).getExtension());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("User Check-out");
        returnValue.setMessageDetail("User check-out successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(UpdateServiceModel data) {
        ExtensionsServices extensionsServices;
        RequestResponse returnValue = new RequestResponse();
        Optional extensionId = this.extensionsRepository.findById((Object)data.getId());
        if (!extensionId.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not exist");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Optional extensions = this.extensionsRepository.findByIdAndExtensionTypeAndExtensionSubtype(((Extension)extensionId.get()).getId(), "phone", "room");
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not registered with type phone and subType room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() != 1) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("user must be checked in!");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        List extServices = this.extensionsServicesRepository.findByExtension(((Extension)extensions.get()).getExtension());
        if (!extServices.isEmpty()) {
            this.extensionsServicesRepository.deleteAll((Iterable)extServices);
        }
        if (data.getBudget() != null) {
            ((Extension)extensions.get()).setTimeOutInSecond(data.getBudget());
        }
        if (data.getIntercom() != null && data.getIntercom().equals(true)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setCreatedOn(LocalDateTime.now());
            extensionsServices.setServiceCode("dialing-intercom");
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (data.getDnd() != null && data.getDnd().equals(true)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices.setServiceCode("dnd");
            extensionsServices.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        if (data.getIsd() != null && data.getIsd().equals(true)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setServiceCode("dialing-isd");
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices);
            ExtensionsServices extensionsServices1 = new ExtensionsServices();
            extensionsServices1.setServiceCode("dialing-std");
            extensionsServices1.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices1.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices1);
            ExtensionsServices extensionsServices2 = new ExtensionsServices();
            extensionsServices2.setCreatedOn(LocalDateTime.now());
            extensionsServices2.setServiceCode("dialing-local");
            extensionsServices2.setExtension(((Extension)extensions.get()).getExtension());
            this.extensionsServicesRepository.save((Object)extensionsServices2);
        } else if (data.getStd() != null && data.getStd().equals(true)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setServiceCode("dialing-std");
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices);
            ExtensionsServices extensionsServices1 = new ExtensionsServices();
            extensionsServices1.setCreatedOn(LocalDateTime.now());
            extensionsServices1.setServiceCode("dialing-local");
            extensionsServices1.setExtension(((Extension)extensions.get()).getExtension());
            this.extensionsServicesRepository.save((Object)extensionsServices1);
        } else if (data.getLocal() != null && data.getLocal().equals(true)) {
            extensionsServices = new ExtensionsServices();
            extensionsServices.setServiceCode("dialing-local");
            extensionsServices.setExtension(((Extension)extensions.get()).getExtension());
            extensionsServices.setCreatedOn(LocalDateTime.now());
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("service updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateByExtension(UpdateServiceModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional extension = this.extensionsRepository.findByExtension(data.getExtension());
        if (!extension.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not exist");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        UpdateServiceModel updateData = new UpdateServiceModel();
        updateData.setId(((Extension)extension.get()).getId());
        updateData.setBudget(data.getBudget());
        updateData.setIntercom(data.getIntercom());
        updateData.setDnd(data.getDnd());
        updateData.setIsd(data.getIsd());
        updateData.setStd(data.getStd());
        updateData.setLocal(data.getLocal());
        return this.updateById(updateData);
    }

    public RequestResponse getAllRoomExtension(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = HotelSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.hotelServiceViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.hotelServiceViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse roomShift(RoomShiftModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional newVal = this.extensionsRepository.findByExtensionAndExtensionSubtype(data.getNewExtension(), "room");
        Optional oldVal = this.extensionsRepository.findByExtensionAndExtensionSubtype(data.getExtension(), "room");
        List list = this.extensionsServicesRepository.findByExtension(data.getExtension());
        if (!oldVal.isPresent() || !newVal.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not exist with type phone and subType room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)oldVal.get()).getCheckIn() != 1) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("first, checked in for room shift");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)newVal.get()).getCheckIn() != 0 && ((Extension)newVal.get()).getCheckIn() != null) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("room unavailable for shifting");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (!((Extension)newVal.get()).getIsFeedBack().equals(false)) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("room not clean for shifting");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (!list.isEmpty()) {
            for (ExtensionsServices row : list) {
                row.setExtension(data.getNewExtension());
                this.extensionsServicesRepository.save((Object)row);
            }
        }
        Extension oldExtension = (Extension)oldVal.get();
        Extension newExtension = (Extension)newVal.get();
        this.extensionsServicesService.deleteAllExtension(data.getExtension());
        this.alarmDetailService.updatePhoneNumberByExtension(data.getExtension(), data.getNewExtension());
        this.alarmDetailService.removeAlarm(data.getExtension());
        newExtension.setExtensionSubtype(((Extension)oldVal.get()).getExtensionSubtype());
        newExtension.setName(((Extension)oldVal.get()).getName());
        newExtension.setGroupType(((Extension)oldVal.get()).getGroupType());
        newExtension.setTimeOutInSecond(((Extension)oldVal.get()).getTimeOutInSecond());
        newExtension.setPremiumCustomer(((Extension)oldVal.get()).getPremiumCustomer());
        newExtension.setUuid(((Extension)oldVal.get()).getUuid());
        newExtension.setCheckIn(((Extension)oldVal.get()).getCheckIn());
        newExtension.setCheckInEpoch(((Extension)oldVal.get()).getCheckInEpoch());
        oldExtension.setName(null);
        oldExtension.setTimeOutInSecond(Integer.valueOf(0));
        oldExtension.setGroupType(null);
        oldExtension.setPremiumCustomer(Boolean.valueOf(false));
        oldExtension.setCheckIn(Integer.valueOf(0));
        oldExtension.setCheckInEpoch(Long.valueOf(0L));
        oldExtension.setUuid(null);
        this.extensionsRepository.save((Object)oldExtension);
        this.extensionsRepository.save((Object)newExtension);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("room shifted");
        returnValue.setMessageDetail("Service updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getByBillingUuid(ViewChannelsModel billingUuid) {
        RequestResponse returnValue = new RequestResponse();
        if (billingUuid == null || billingUuid.getBillingUuid() == null || billingUuid.getBillingUuid().equals("")) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("parameter is required.");
            returnValue.setMessageDetail("Please provide a valid UUID.");
            return returnValue;
        }
        if (billingUuid.getStartStamp() == null || billingUuid.getStartStamp().equals("")) {
            List list = this.viewChannelsRepository.findByBillingUuidOrderByStartStampDesc(billingUuid.getBillingUuid());
            ArrayList<ViewChannelsModel> dataList = new ArrayList<ViewChannelsModel>();
            try {
                if (list.isEmpty()) {
                    returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                    returnValue.setMessage("No channels found for the given billing UUID.");
                    returnValue.setMessageDetail("No records found.");
                } else {
                    for (ViewChannels viewChannels : list) {
                        ViewChannelsModel data = new ViewChannelsModel();
                        data.setId(viewChannels.getId());
                        data.setAnswerStamp(viewChannels.getAnswerStamp());
                        data.setBillSec(viewChannels.getBillSec());
                        data.setBillingUuid(viewChannels.getBillingUuid());
                        data.setCallCost(viewChannels.getCallCost());
                        data.setCallType(viewChannels.getCallType());
                        data.setCallerIdName(viewChannels.getCallerIdName());
                        data.setCallerIdNumber(viewChannels.getCallerIdNumber());
                        data.setDestinationNumber(viewChannels.getDestinationNumber());
                        data.setDidNumber(viewChannels.getDidNumber());
                        data.setDirection(viewChannels.getDirection());
                        data.setDodNumber(viewChannels.getDodNumber());
                        data.setDuration(viewChannels.getDuration());
                        data.setEndStamp(viewChannels.getEndStamp());
                        data.setPulse(viewChannels.getPulse());
                        data.setUuid(viewChannels.getUuid());
                        dataList.add(data);
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Channels found.");
                    returnValue.setData(dataList);
                }
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
                returnValue.setMessage("Unable to return data.");
                returnValue.setMessageDetail("Contact with administrator.");
            }
            return returnValue;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime startStamp = LocalDateTime.parse(billingUuid.getStartStamp(), formatter);
            List list = this.viewChannelsRepository.findByBillingUuidAndStartStamp(billingUuid.getBillingUuid(), startStamp);
            ArrayList<ViewChannelsModel> dataList = new ArrayList<ViewChannelsModel>();
            if (list.size() == 0 || list.isEmpty()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("0 record present of given date & billing UUID.");
                returnValue.setMessageDetail("No records found.");
            } else {
                for (ViewChannels viewChannels : list) {
                    ViewChannelsModel data = new ViewChannelsModel();
                    data.setId(viewChannels.getId());
                    data.setAnswerStamp(viewChannels.getAnswerStamp());
                    data.setBillSec(viewChannels.getBillSec());
                    data.setBillingUuid(viewChannels.getBillingUuid());
                    data.setCallCost(viewChannels.getCallCost());
                    data.setCallType(viewChannels.getCallType());
                    data.setCallerIdName(viewChannels.getCallerIdName());
                    data.setCallerIdNumber(viewChannels.getCallerIdNumber());
                    data.setDestinationNumber(viewChannels.getDestinationNumber());
                    data.setDidNumber(viewChannels.getDidNumber());
                    data.setDirection(viewChannels.getDirection());
                    data.setDodNumber(viewChannels.getDodNumber());
                    data.setDuration(viewChannels.getDuration());
                    data.setEndStamp(viewChannels.getEndStamp());
                    data.setPulse(viewChannels.getPulse());
                    data.setStartStamp(viewChannels.getStartStamp().toString());
                    data.setUuid(viewChannels.getUuid());
                    dataList.add(data);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Channels found.");
                returnValue.setData(dataList);
            }
        }
        catch (DateTimeParseException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid startStamp format.");
            returnValue.setMessageDetail("Please provide a valid startStamp in the format 'yyyy-MM-dd HH:mm:ss'.");
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return data.");
            returnValue.setMessageDetail("Contact with the administrator.");
        }
        return returnValue;
    }

    public RequestResponse dirtyCleanServices(DirtyCleanModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getExtension(), "phone", "room");
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not register with type phone and subType room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getIsFeedBack() != null) {
            ((Extension)extensions.get()).setIsFeedBack(data.getIsFeedBack());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("service updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse listAll() {
        logger.info("==== listAll API START ====");
        RequestResponse response = new RequestResponse();
        try {
            List floors = this.hotelServiceViewRepository.findDistinctFloors();
            logger.info("Floors fetched from DB : {}", (Object)floors);
            if (floors == null || floors.isEmpty()) {
                logger.info("No floors found in database");
                response.setStatus(Constants.Error.OK);
                response.setMessage("No floors found.");
                response.setData(Collections.emptyList());
                logger.info("==== listAll API END (NO DATA) ====");
                return response;
            }
            ArrayList<FloorWiseHotelService> result = new ArrayList<FloorWiseHotelService>();
            logger.info("Total floors to process : {}", (Object)floors.size());
            for (Integer floor : floors) {
                try {
                    logger.info("---- Processing Floor : {} ----", (Object)floor);
                    List views = this.hotelServiceViewRepository.findAllByFloorOrderByExtensionAsc(floor);
                    logger.info("Total records fetched for floor {} : {}", (Object)floor, (Object)(views != null ? views.size() : 0));
                    if (views == null || views.isEmpty()) {
                        logger.warn("No views found for floor {}", (Object)floor);
                        continue;
                    }
                    List filteredView = views.stream().filter(v -> v.getExtension() != null && !v.getExtension().trim().isEmpty() && "phone".equalsIgnoreCase(v.getExtensionType())).collect(Collectors.toMap(HotelServiceView::getExtension, v -> v, (a, b) -> a)).values().stream().collect(Collectors.toList());
                    logger.info("Filtered unique extensions for floor {} : {}", (Object)floor, (Object)filteredView.size());
                    ArrayList<HotelDropDownModel> models = new ArrayList<HotelDropDownModel>();
                    for (HotelServiceView code : filteredView) {
                        try {
                            logger.debug("Processing Extension : {} (Floor {})", (Object)code.getExtension(), (Object)floor);
                            HotelDropDownModel model = new HotelDropDownModel();
                            model.setId(code.getId());
                            model.setExtension(code.getExtension());
                            model.setAction(code.getAction());
                            List listOfAlarm = this.alarmDetailRepository.findAllByPhoneNumber(code.getExtension());
                            logger.debug("Alarms found for extension {} : {}", (Object)code.getExtension(), (Object)(listOfAlarm != null ? listOfAlarm.size() : 0));
                            List<Object> alarmModels = new ArrayList();
                            if (listOfAlarm != null && !listOfAlarm.isEmpty()) {
                                alarmModels = listOfAlarm.stream().map(entity -> {
                                    try {
                                        AlarmDetailCreateModel alarmModel = new AlarmDetailCreateModel();
                                        alarmModel.setId(entity.getId());
                                        alarmModel.setAlarmSource(entity.getAlarmSource());
                                        alarmModel.setAlarmTypeId(entity.getAlarmTypeId());
                                        alarmModel.setAlarmTypeCode(entity.getAlarmTypeCode());
                                        alarmModel.setPhoneNumber(entity.getPhoneNumber());
                                        alarmModel.setScheduledDate(DateFormatUtility.localDateToString((LocalDate)entity.getScheduledDate()));
                                        alarmModel.setScheduledTime(DateFormatUtility.localTimeToString1((LocalTime)entity.getScheduledTime()));
                                        alarmModel.setLanguageCode(entity.getLanguageCode());
                                        alarmModel.setFilePath(entity.getFilePath());
                                        alarmModel.setIsActive(entity.getIsActive());
                                        alarmModel.setIsProcessed(entity.getIsProcessed());
                                        alarmModel.setScheduledDateTimeEpoch(entity.getScheduledDateTimeEpoch());
                                        alarmModel.setNoOfTry(entity.getNoOfTry());
                                        alarmModel.setRetryCount(entity.getRetryCount());
                                        alarmModel.setRetryDelay(entity.getRetryDelay());
                                        return alarmModel;
                                    }
                                    catch (Exception e) {
                                        logger.error("Error mapping alarm entity for phoneNumber: {}", (Object)entity.getPhoneNumber(), (Object)e);
                                        return null;
                                    }
                                }).filter(alarmModel -> alarmModel != null).collect(Collectors.toList());
                            }
                            model.setAlarm(alarmModels);
                            model.setPhoneStatus(code.getPhoneStatus());
                            model.setRoomStatus(code.getRoomStatus());
                            model.setAlarmTime(code.getAlarmTime());
                            model.setName(code.getName());
                            model.setExtensionType(code.getExtensionType());
                            model.setGroupType(code.getGroupType());
                            model.setFwdNoAns(code.getFwdNoAns());
                            model.setFwdBusy(code.getFwdBusy());
                            model.setFwdAll(code.getFwdAll());
                            model.setExtFwdBusy(code.getExtFwdBusy());
                            model.setExtFwdNoAns(code.getExtFwdNoAns());
                            model.setBudget(code.getBudget());
                            model.setPremiumCustomer(code.getPremiumCustomer());
                            model.setCheckInEpoch(code.getCheckInEpoch());
                            model.setCheckIn(code.getCheckIn());
                            model.setIsFeedback(code.getIsFeedback());
                            model.setUuid(code.getUuid());
                            model.setIsd(code.getIsd());
                            model.setStd(code.getStd());
                            model.setLocal(code.getLocal());
                            model.setIntercom(code.getIntercom());
                            model.setDnd(code.getDnd());
                            model.setVm(code.getVm());
                            model.setCos(code.getCos());
                            model.setDayInboundCos(code.getDayInboundCos());
                            model.setNightInboundCos(code.getNightInboundCos());
                            model.setDayOutboundCos(code.getDayOutboundCos());
                            model.setNightOutboundCos(code.getNightOutboundCos());
                            model.setRegistered(code.getRegistered());
                            model.setFloor(code.getFloor());
                            models.add(model);
                        }
                        catch (Exception e) {
                            logger.error("Error processing extension: {} on floor: {}. Exception: ", (Object)code.getExtension(), (Object)floor, (Object)e);
                        }
                    }
                    logger.info("Final model count for floor {} : {}", (Object)floor, (Object)models.size());
                    result.add(new FloorWiseHotelService(floor, models));
                }
                catch (Exception e) {
                    logger.error("Error processing floor: {}. Exception: ", (Object)floor, (Object)e);
                }
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Floor-wise Hotel Service Data");
            response.setData(result);
            logger.info("Total floors in response : {}", (Object)result.size());
            logger.info("==== listAll API END SUCCESS ====");
        }
        catch (Exception e) {
            logger.error("CRITICAL ERROR in listAll API. Exception: ", (Throwable)e);
            response.setStatus(Constants.Error.UNKNOWN_ERROR);
            response.setMessage("Error retrieving hotel service data");
            response.setMessageDetail("An unexpected error occurred: " + e.getMessage());
            response.setData(Collections.emptyList());
            logger.error("==== listAll API END WITH ERROR ====");
        }
        return response;
    }

    public void updateRoomClean(String extension) {
        Optional extensions = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(extension, "phone", "room");
        if (!extensions.isPresent()) {
            logger.info("Extension not register with type phone and subType room");
        } else {
            ((Extension)extensions.get()).setIsFeedBack(Boolean.valueOf(false));
            this.extensionsRepository.save(extensions.get());
        }
    }

    public RequestResponse createExtensionByGivenRangeForHotel(HttpServletRequest request, ServiceCodeAttribute extensionRange) {
        logger.debug("create new extension : {} ==> {}", (Object)extensionRange.getFrom(), (Object)extensionRange.getTo());
        RequestResponse returnValue = new RequestResponse();
        boolean checkOutbound = this.outboundCosService.checkOutboundCosWithZerosCos();
        boolean checkInbound = this.inboundCosService.checkInboundCosWithZerosCos();
        boolean checkExtensionRange = this.extensionsServicesService.checkExtensionsServicesFromGivenRange1(extensionRange);
        try {
            if (!checkExtensionRange) {
                if (!checkOutbound) {
                    this.outboundCosService.createOutboundCoswithZerosCos();
                }
                if (!checkInbound) {
                    this.inboundCosService.createInboundCosWithZerosCos();
                }
                for (int i = Integer.parseInt(extensionRange.getFrom()); i <= Integer.parseInt(extensionRange.getTo()); ++i) {
                    String extensionNumber = String.valueOf(i);
                    Extension extensions = new Extension();
                    extensions.setExtension(String.valueOf(i));
                    extensions.setExtensionType("phone");
                    extensions.setDayOutboundCos("0");
                    extensions.setDayInboundCos("0");
                    extensions.setNightOutboundCos("0");
                    extensions.setNightInboundCos("0");
                    extensions.setExtensionSubtype("room");
                    extensions.setFloor(extensionRange.getFloor());
                    extensions.setCheckIn(Integer.valueOf(0));
                    extensions.setIsFeedBack(Boolean.valueOf(false));
                    this.extensionsRepository.save((Object)extensions);
                    this.extensionsServicesService.deleteAllExtension(extensionNumber);
                    this.createServicesByLevel(extensionNumber, Integer.valueOf(0));
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Extensions created");
                returnValue.setMessageDetail("All extensions have created successfully");
                logger.info("Extension saved : {}", (Object)returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
                returnValue.setMessage("Can't create");
                returnValue.setMessageDetail("Extensions already created");
                logger.error(returnValue.getMessageDetail());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
            returnValue.setMessage("Can't Create ");
            returnValue.setMessageDetail("Extension already present, from given range");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        return returnValue;
    }

    private void createServicesByLevel(String extension, Integer level) {
        List serviceCodes = this.getServiceCodesByLevel(level);
        LocalDateTime now = LocalDateTime.now();
        for (String serviceCode : serviceCodes) {
            ExtensionsServices extensionsServices = new ExtensionsServices();
            extensionsServices.setExtension(extension);
            extensionsServices.setServiceCode(serviceCode);
            extensionsServices.setCreatedOn(now);
            this.extensionsServicesRepository.save((Object)extensionsServices);
        }
    }

    private List<String> getServiceCodesByLevel(Integer level) {
        if (level == null) {
            return Collections.emptyList();
        }
        switch (level) {
            case 5: {
                return Arrays.asList("dialing-intercom", "dialing-local", "dialing-std", "dialing-isd");
            }
            case 4: {
                return Arrays.asList("dialing-intercom", "dialing-local", "dialing-std");
            }
            case 3: {
                return Arrays.asList("dialing-intercom", "dialing-local");
            }
            case 0: {
                return Collections.singletonList("dialing-intercom");
            }
        }
        return Collections.emptyList();
    }
}

