/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.service;

import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.telephony.pbx.repository.FeatureCodeRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.hotel.model.HotelExtensionCreateModel;
import com.coraltele.service.hotel.model.VmAndDndModel;
import com.coraltele.service.pbx.extension_service.service.ExtensionsServicesService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HotelExtensionService {
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    private FeatureCodeRepository featureCodeRepository;
    @Autowired
    private ExtensionsServicesService extensionsServicesService;
    @Autowired
    private ExtensionsServicesRepository extensionsServicesRepository;

    public RequestResponse createExtension(HotelExtensionCreateModel model) {
        RequestResponse response = new RequestResponse();
        Optional extensionOptional = this.extensionsRepository.findByExtension(model.getExtension());
        if (extensionOptional.isPresent()) {
            response.setMessage("Extension Already exist with the " + model.getExtension());
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        List listExtension = this.extensionsRepository.findByExtensionTypeAndExtensionSubtype(model.getExtensionType(), "");
        if (!listExtension.isEmpty()) {
            response.setMessage("Extension already exists with number: " + ((Extension)listExtension.get(0)).getExtension() + " and feature type: " + model.getExtensionType());
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        Extension extension = new Extension();
        extension.setName(model.getExtensionName());
        extension.setExtension(model.getExtension());
        extension.setExtensionType(model.getExtensionType());
        extension.setExtensionSubtype("");
        this.extensionsRepository.save((Object)extension);
        response.setMessage("Extension Created successfully");
        response.setStatus(Constants.Error.OK);
        return response;
    }

    public RequestResponse updateExtension(HotelExtensionCreateModel model) {
        RequestResponse response = new RequestResponse();
        if (model.getId() == null) {
            response.setMessage("Extension ID is required for update.");
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        Optional existingExtensionOpt = this.extensionsRepository.findById((Object)model.getId());
        if (!existingExtensionOpt.isPresent()) {
            response.setMessage("Extension not found with ID: " + model.getId());
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        Optional extensionByNumber = this.extensionsRepository.findByExtension(model.getExtension());
        if (extensionByNumber.isPresent() && !((Extension)extensionByNumber.get()).getId().equals(model.getId())) {
            response.setMessage("Another extension already exists with number: " + model.getExtension());
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        List duplicatesByTypeSubtype = this.extensionsRepository.findByExtensionTypeAndExtensionSubtype(model.getExtensionType(), "");
        boolean hasOtherSubtypeConflict = duplicatesByTypeSubtype.stream().anyMatch(ext -> !ext.getId().equals(model.getId()));
        if (hasOtherSubtypeConflict) {
            response.setMessage("Another extension already exists with feature type: " + model.getExtensionType());
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        Extension extension = (Extension)existingExtensionOpt.get();
        extension.setName(model.getExtensionName());
        extension.setExtension(model.getExtension());
        extension.setExtensionType(model.getExtensionType());
        extension.setExtensionSubtype("");
        this.extensionsRepository.save((Object)extension);
        response.setMessage("Extension updated successfully.");
        response.setStatus(Constants.Error.OK);
        return response;
    }

    public RequestResponse listAllExtensions() {
        RequestResponse response = new RequestResponse();
        List<String> validSubtypes = Arrays.asList("minibar", "dirtyclean");
        List extensions = this.extensionsRepository.findByExtensionTypeInAndExtensionSubtype(validSubtypes, "");
        if (extensions == null || extensions.isEmpty()) {
            response.setStatus(Constants.Error.OK);
            response.setMessage("No extensions found.");
            response.setData(new ArrayList());
            return response;
        }
        List models = extensions.stream().map(extension -> {
            HotelExtensionCreateModel model = new HotelExtensionCreateModel();
            model.setId(Integer.valueOf(extension.getId() != null ? extension.getId() : 0));
            model.setExtensionName(extension.getName() != null ? extension.getName() : "");
            model.setExtension(extension.getExtension() != null ? extension.getExtension() : "");
            model.setExtensionType(extension.getExtensionType() != null ? extension.getExtensionType() : "");
            model.setExtensionSubtype(extension.getExtensionSubtype() != null ? extension.getExtensionSubtype() : "");
            return model;
        }).collect(Collectors.toList());
        response.setStatus(Constants.Error.OK);
        response.setMessage("Filtered list of Extensions");
        response.setData(models);
        return response;
    }

    public RequestResponse deleteHotelExtension(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        List ids = input.getIntId();
        ArrayList<Extension> toDelete = new ArrayList<Extension>();
        for (Integer id : ids) {
            Optional optionalExtension = this.extensionsRepository.findById((Object)id);
            if (!optionalExtension.isPresent()) {
                response.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                response.setMessage("Record with ID " + id + " not found.");
                return response;
            }
            Extension extension = (Extension)optionalExtension.get();
            boolean isAssociated = this.featureCodeRepository.existsByExtension(extension);
            if (isAssociated) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Cannot delete extension with extension " + extension.getExtension() + " because it is associated with feature codes.");
                return response;
            }
            toDelete.add(extension);
        }
        this.extensionsRepository.deleteAll(toDelete);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Records deleted successfully.");
        return response;
    }

    public RequestResponse updateExtensionLevel(String extension, Integer level) {
        RequestResponse response = new RequestResponse();
        Optional extensionOptional = this.extensionsRepository.findByExtension(extension);
        if (!extensionOptional.isPresent()) {
            response.setMessage("Extension not found with ID: " + extension);
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        Extension extensions = (Extension)extensionOptional.get();
        extensions.setLevel(level);
        this.extensionsRepository.save((Object)extensions);
        this.extensionsServicesService.deleteAllExtensionExceptVmAndDnd(extension);
        List serviceCodes = this.getServiceCodesByLevel(level);
        LocalDateTime now = LocalDateTime.now();
        List servicesList = serviceCodes.stream().map(code -> {
            ExtensionsServices service = new ExtensionsServices();
            service.setServiceCode(code);
            service.setExtension(extension);
            service.setCreatedOn(now);
            return service;
        }).collect(Collectors.toList());
        this.extensionsServicesRepository.saveAll(servicesList);
        response.setMessage("Room level updated successfully");
        response.setStatus(Constants.Error.OK);
        return response;
    }

    private List<String> getServiceCodesByLevel(Integer level) {
        if (level == null) {
            return Collections.emptyList();
        }
        switch (level) {
            case 5: {
                return Arrays.asList("dialing-intercom", "dialing-local", "dialing-std", "dialing-isd");
            }
            case 4: {
                return Arrays.asList("dialing-intercom", "dialing-local", "dialing-std");
            }
            case 3: {
                return Arrays.asList("dialing-intercom", "dialing-local");
            }
            case 0: {
                return Collections.singletonList("dialing-intercom");
            }
        }
        return Collections.emptyList();
    }

    public RequestResponse updateExtensionVmAndDnd(VmAndDndModel vmAndDndModel) {
        RequestResponse response = new RequestResponse();
        Optional extensionOptional = this.extensionsRepository.findByExtension(vmAndDndModel.getExtension());
        if (!extensionOptional.isPresent()) {
            response.setMessage("Extension not found with ID: " + vmAndDndModel.getExtension());
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        String serviceCode = null;
        String display = null;
        if (vmAndDndModel.getExtensionServices().equals("vm")) {
            if (vmAndDndModel.getValue().booleanValue()) {
                this.extensionsServicesService.deleteVm(vmAndDndModel.getExtension());
                serviceCode = "VM";
                display = "Voice mail";
                ExtensionsServices service = new ExtensionsServices();
                service.setServiceCode(serviceCode);
                service.setExtension(vmAndDndModel.getExtension());
                service.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)service);
                response.setMessage("Room set to " + display + " successfully");
            } else {
                this.extensionsServicesService.deleteVm(vmAndDndModel.getExtension());
                response.setMessage("Room set to disable successfully");
            }
        } else if (vmAndDndModel.getExtensionServices().equalsIgnoreCase("dnd")) {
            if (vmAndDndModel.getValue().booleanValue()) {
                this.extensionsServicesService.deleteVm(vmAndDndModel.getExtension());
                serviceCode = "dnd";
                display = "Do not disturb";
                ExtensionsServices service = new ExtensionsServices();
                service.setServiceCode(serviceCode);
                service.setExtension(vmAndDndModel.getExtension());
                service.setCreatedOn(LocalDateTime.now());
                this.extensionsServicesRepository.save((Object)service);
                response.setMessage("Room set to " + display + " successfully");
            } else {
                this.extensionsServicesService.deleteDnd(vmAndDndModel.getExtension());
                response.setMessage("Room set to disable successfully");
            }
        }
        response.setStatus(Constants.Error.OK);
        return response;
    }

    public RequestResponse listAllCheckInUser() {
        RequestResponse response = new RequestResponse();
        List extensions = this.extensionsRepository.findByCheckIn(Integer.valueOf(1));
        if ((extensions = extensions.stream().filter(ext -> "phone".equalsIgnoreCase(ext.getExtensionType()) && "room".equalsIgnoreCase(ext.getExtensionSubtype())).collect(Collectors.toList())) == null || extensions.isEmpty()) {
            response.setStatus(Constants.Error.OK);
            response.setMessage("No extensions found.");
            return response;
        }
        List models = extensions.stream().map(extension -> {
            HotelExtensionCreateModel model = new HotelExtensionCreateModel();
            model.setId(Integer.valueOf(extension.getId() != null ? extension.getId() : 0));
            model.setExtensionName(extension.getName() != null ? extension.getName() : "");
            model.setExtension(extension.getExtension() != null ? extension.getExtension() : "");
            model.setExtensionType(extension.getExtensionType() != null ? extension.getExtensionType() : "");
            model.setExtensionSubtype(extension.getExtensionSubtype() != null ? extension.getExtensionSubtype() : "");
            model.setCheckIn(Integer.valueOf(extension.getCheckIn() != null ? extension.getCheckIn() : 0));
            model.setGroupType(extension.getGroupType() != null ? extension.getGroupType() : "");
            return model;
        }).collect(Collectors.toList());
        response.setStatus(Constants.Error.OK);
        response.setMessage("Filtered list of Extensions");
        response.setData(models);
        return response;
    }
}

