/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.service;

import com.coraltele.db.telephony.pbx.entity.HmsConfiguration;
import com.coraltele.db.telephony.pbx.repository.HmsConfigurationRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.hotel.model.HmsConfigModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class HmsConfigService {
    @Autowired
    private HmsConfigurationRepository hmsConfigurationRepository;

    public RequestResponse saveOrUpdateHmsConfiguration(HmsConfigModel model) {
        RequestResponse response = new RequestResponse();
        try {
            List existingConfigs = (List)this.hmsConfigurationRepository.findAll();
            if (existingConfigs.isEmpty() && (model.getId() == null || model.getId() == 0)) {
                HmsConfiguration config = new HmsConfiguration();
                config.setCallLevel(model.getCallLevel());
                this.hmsConfigurationRepository.save((Object)config);
                response.setStatus(Constants.Error.OK);
                response.setMessage("Configuration created successfully.");
            } else {
                if (model.getId() == null) {
                    response.setStatus(Constants.Error.ERROR);
                    response.setMessage("Only one HMS configuration is allowed.");
                    return response;
                }
                Optional optionalConfig = this.hmsConfigurationRepository.findById((Object)model.getId());
                if (!optionalConfig.isPresent()) {
                    response.setStatus(Constants.Error.ERROR);
                    response.setMessage("HMS Configuration not found for update.");
                    return response;
                }
                HmsConfiguration configToUpdate = (HmsConfiguration)optionalConfig.get();
                configToUpdate.setCallLevel(model.getCallLevel());
                this.hmsConfigurationRepository.save((Object)configToUpdate);
                response.setStatus(Constants.Error.OK);
                response.setMessage("Configuration updated successfully.");
            }
        }
        catch (Exception e) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to save or update configuration.");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    public RequestResponse deleteHmsConfig(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        List ids = input.getIntId();
        ArrayList toDelete = new ArrayList();
        for (Integer id : ids) {
            Optional alarmType = this.hmsConfigurationRepository.findById((Object)id);
            if (alarmType.isPresent()) {
                toDelete.add(alarmType.get());
                continue;
            }
            response.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            response.setMessage("Record with ID " + id + " not found.");
            return response;
        }
        this.hmsConfigurationRepository.deleteAll(toDelete);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Records deleted successfully.");
        return response;
    }

    public RequestResponse listAll() {
        RequestResponse response = new RequestResponse();
        List codes = (List)this.hmsConfigurationRepository.findAll();
        if (codes == null || codes.isEmpty()) {
            response.setStatus(Constants.Error.OK);
            response.setMessage("No Feature codes found.");
            response.setData(Collections.emptyList());
            return response;
        }
        List models = codes.stream().map(code -> {
            HmsConfigModel model = new HmsConfigModel();
            model.setId(code.getId());
            model.setCallLevel(code.getCallLevel());
            return model;
        }).collect(Collectors.toList());
        response.setStatus(Constants.Error.OK);
        response.setMessage("List Feature of Codes");
        response.setData(models);
        return response;
    }

    public String getDefaultLevel() {
        String callLevel;
        List codes = (List)this.hmsConfigurationRepository.findAll();
        if (codes != null && !codes.isEmpty() && (callLevel = ((HmsConfiguration)codes.get(0)).getCallLevel()) != null && StringUtils.hasText((String)callLevel)) {
            return callLevel;
        }
        return null;
    }
}

