/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.service;

import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.FeatureCode;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.FeatureCodeRepository;
import com.coraltele.db.telephony.pbx.specification.FeatureCodeSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.hotel.model.FeatureCodeModel;
import com.coraltele.service.hotel.model.UpdateGroupModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class FeatureCodeService {
    private static final Logger logger = LogManager.getLogger(FeatureCodeService.class);
    @Autowired
    private FeatureCodeRepository featureCodeRepository;
    @Autowired
    private ExtensionsRepository extensionRepository;

    public RequestResponse createFeatureCode(FeatureCodeModel model) {
        RequestResponse response = new RequestResponse();
        if (model.getFeatureCode() == null || model.getFeatureCode().trim().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Feature Subtype cannot be empty.");
            return response;
        }
        Optional extensionOptional = this.extensionRepository.findByExtension(model.getExtension());
        if (!extensionOptional.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Extension not found.");
            return response;
        }
        Optional existing = this.featureCodeRepository.findByFeatureCodeAndExtension_Extension(model.getFeatureCode().trim(), model.getExtension().trim());
        if (existing.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Feature Subtype code with the same Extension already exists.");
            return response;
        }
        FeatureCode featureCode = new FeatureCode();
        featureCode.setFeatureCode(model.getFeatureCode().trim());
        featureCode.setDescription(model.getDescription());
        featureCode.setExtension((Extension)extensionOptional.get());
        this.featureCodeRepository.save((Object)featureCode);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Feature Subtype code created successfully.");
        return response;
    }

    public RequestResponse updateFeatureCode(FeatureCodeModel model) {
        Optional duplicateCheck;
        RequestResponse response = new RequestResponse();
        if (model.getId() == null) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("ID is required for update.");
            return response;
        }
        Optional existingOptional = this.featureCodeRepository.findById(model.getId());
        if (!existingOptional.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Feature Subtype code not found.");
            return response;
        }
        FeatureCode existingFeatureCode = (FeatureCode)existingOptional.get();
        if (!(existingFeatureCode.getFeatureCode().equals(model.getFeatureCode().trim()) && existingFeatureCode.getExtension().getExtension().equals(model.getExtension().trim()) || !(duplicateCheck = this.featureCodeRepository.findByFeatureCodeAndExtension_Extension(model.getFeatureCode().trim(), model.getExtension().trim())).isPresent())) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Another feature Subtype code with the same Feature code already exists.");
            return response;
        }
        existingFeatureCode.setFeatureCode(model.getFeatureCode().trim());
        existingFeatureCode.setDescription(model.getDescription());
        if (model.getExtension() != null) {
            Optional codeOptional = this.extensionRepository.findByExtension(model.getExtension().trim());
            if (codeOptional.isPresent()) {
                existingFeatureCode.setExtension((Extension)codeOptional.get());
            } else {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Provided Feature code does not exist.");
                return response;
            }
        }
        this.featureCodeRepository.save((Object)existingFeatureCode);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Feature Subtype code updated successfully.");
        return response;
    }

    public RequestResponse deleteFeatureCode(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional featureCodeOptional = this.featureCodeRepository.findById(ids);
            if (featureCodeOptional.isPresent()) {
                addValue.add(featureCodeOptional.get());
                this.featureCodeRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = FeatureCodeSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.featureCodeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.featureCodeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<FeatureCodeModel> entityToModelConversion(List<FeatureCode> report) {
        ArrayList<FeatureCodeModel> addValue = new ArrayList<FeatureCodeModel>();
        for (FeatureCode row : report) {
            FeatureCodeModel data = new FeatureCodeModel();
            data.setId(row.getId());
            data.setExtension(row.getExtension().getExtension());
            data.setExtensionDescription(row.getExtension().getExtensionType());
            data.setDescription(row.getDescription());
            data.setFeatureCode(row.getFeatureCode());
            if (Boolean.TRUE.equals(row.isDirtyCleanMaster())) {
                data.setDirtyCleanMaster(true);
            } else {
                data.setDirtyCleanMaster(false);
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse updateGroup(UpdateGroupModel model) {
        RequestResponse response = new RequestResponse();
        ArrayList<String> extensionStringList = new ArrayList<String>();
        for (String ext : model.getExtension()) {
            Optional optionalExtension = this.extensionRepository.findByExtension(ext);
            if (optionalExtension.isPresent()) {
                Extension extensionEntity = (Extension)optionalExtension.get();
                if (model.getGroupType() == null || model.getGroupType() == "") {
                    extensionEntity.setGroupType(null);
                } else {
                    extensionEntity.setGroupType(model.getGroupType());
                }
                this.extensionRepository.save((Object)extensionEntity);
                extensionStringList.add(extensionEntity.getExtension());
                continue;
            }
            response.setMessage("Extension not found: " + ext);
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        response.setStatus(Constants.Error.OK);
        response.setMessage("Group updated for extensions: " + extensionStringList);
        return response;
    }

    public RequestResponse updateDirtyCleanMaster(Long id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            List extension = this.extensionRepository.findByExtensionTypeAndExtensionSubtype("phone", "dirtyclean");
            if (!extension.isEmpty()) {
                List featureCodeList = this.featureCodeRepository.findByExtension_Extension(((Extension)extension.get(0)).getExtension());
                if (featureCodeList.isEmpty()) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("No feature code exist for dirty clean type");
                    return returnValue;
                }
                if (!featureCodeList.stream().anyMatch(featureCode -> featureCode.getId() == id)) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Selected ID is not a dirty clean type");
                    return returnValue;
                }
                for (FeatureCode featureCode2 : featureCodeList) {
                    if (featureCode2.getId() == id) {
                        featureCode2.setDirtyCleanMaster(true);
                    } else {
                        featureCode2.setDirtyCleanMaster(false);
                    }
                    this.featureCodeRepository.save((Object)featureCode2);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Dirty Clean Master updated successfully");
                returnValue.setMessageDetail("Dirty Clean Master updated successfully");
                return returnValue;
            }
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No any dirty-clean extension exists");
            return returnValue;
        }
        catch (Exception e) {
            logger.error("Error updating Dirty Clean Master", (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error updating Dirty Clean Master: " + e.getMessage());
            return returnValue;
        }
    }
}

