/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.service;

import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.FeatureCode;
import com.coraltele.db.telephony.pbx.entity.FeatureCodeHistory;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.FeatureCodeHistoryRepository;
import com.coraltele.db.telephony.pbx.repository.FeatureCodeRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.hotel.model.FeatureCodeModel;
import com.coraltele.service.hotel.model.FeatureHistoryCodeModel;
import com.coraltele.service.hotel.service.HotelService;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeatureCodeHistoryService {
    private static final Logger logger = LogManager.getLogger(FeatureCodeHistoryService.class);
    @Autowired
    FeatureCodeRepository featureCodeRepository;
    @Autowired
    ExtensionsRepository extensionRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    HotelService hotelService;
    @Autowired
    private FeatureCodeHistoryRepository featureCodeHistoryRepository;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse createFeatureCdeHistory(FeatureCodeModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            List extension = this.extensionRepository.findByExtensionTypeAndExtensionSubtype("phone", "dirtyclean");
            if (extension.isEmpty()) {
                logger.error("Set Master data for dirtyClean checkCode,No data found for extension: " + ((Extension)extension.get(0)).getExtension());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Set Extension for dirtyClean checkCode");
                return returnValue;
            }
            String getMasterDirtyCleanFeatureCode = this.getMasterDirtyCleanFeatureCode(((Extension)extension.get(0)).getExtension());
            if (getMasterDirtyCleanFeatureCode == null) {
                logger.error("Set Master data for dirtyClean checkCode,No data found for extension: " + ((Extension)extension.get(0)).getExtension());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Set Master data for dirtyClean checkCode");
                logger.error("Set Master data for dirtyClean checkCode,No data found for extension: " + ((Extension)extension.get(0)).getExtension());
                return returnValue;
            }
            if (!this.featureCodeExists(data.getFeatureCode())) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid Feature Code selected");
                return returnValue;
            }
            FeatureCodeHistory featureCode = new FeatureCodeHistory();
            featureCode.setCreatedOn(Long.valueOf(System.currentTimeMillis()));
            featureCode.setExtension(data.getExtension());
            featureCode.setDescription(data.getDescription());
            featureCode.setFeatureCode(data.getFeatureCode());
            this.featureCodeHistoryRepository.save((Object)featureCode);
            if (data.getFeatureCode().equals(getMasterDirtyCleanFeatureCode)) {
                this.hotelService.updateRoomClean(data.getExtension());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Feature Code History Created Successfully");
            return returnValue;
        }
        catch (Exception e) {
            logger.error("Error creating Feature Code History", (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error creating Feature Code History: " + e.getMessage());
        }
        return returnValue;
    }

    public String getMasterDirtyCleanFeatureCode(String extension) {
        try {
            Optional data = this.featureCodeRepository.findByExtension_ExtensionAndDirtyCleanMaster(extension, true);
            if (data.isPresent()) {
                return ((FeatureCode)data.get()).getFeatureCode();
            }
            logger.error("Set Master data for dirtyClean checkCode,No data found for extension: " + extension);
        }
        catch (Exception e) {
            logger.error("Error getting Master Dirty Clean Feature Code", (Throwable)e);
        }
        return null;
    }

    public boolean featureCodeExists(String featureCode) {
        try {
            Optional data = this.featureCodeRepository.findByFeatureCode(featureCode);
            if (data.isPresent()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Error checking Feature Code existence", (Throwable)e);
        }
        return false;
    }

    public RequestResponse getFeatureCodeHistoryByRoomNumber(String extension) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional extensionOptional = this.extensionsRepository.findByExtension(extension);
            if (!extensionOptional.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data found for this extension");
                return returnValue;
            }
            LocalDate today = LocalDate.now();
            long startOfDay = today.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            long endOfDay = today.plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli() - 1L;
            List featureCodeHistoryList = this.featureCodeHistoryRepository.findTodayByExtension(extension, Long.valueOf(startOfDay), Long.valueOf(endOfDay));
            List modelList = featureCodeHistoryList.stream().map(history -> {
                FeatureHistoryCodeModel model = new FeatureHistoryCodeModel();
                model.setId(history.getId());
                model.setExtension(history.getExtension());
                model.setFeatureCode(history.getFeatureCode());
                Optional featureCodeOptional = this.featureCodeRepository.findByFeatureCode(history.getFeatureCode());
                if (featureCodeOptional.isPresent()) {
                    model.setDescription(((FeatureCode)featureCodeOptional.get()).getDescription());
                } else {
                    model.setDescription("Unknown");
                }
                model.setCreatedOn(history.getCreatedOn());
                return model;
            }).collect(Collectors.toList());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data fetched successfully");
            returnValue.setData(modelList);
        }
        catch (Exception e) {
            logger.error("Error fetching Feature Code History", (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error fetching Feature Code History: " + e.getMessage());
        }
        return returnValue;
    }
}

