/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.service;

import com.coraltele.db.telephony.pbx.entity.AlarmType;
import com.coraltele.db.telephony.pbx.repository.AlarmTypeRepository;
import com.coraltele.db.telephony.pbx.specification.AlarmTypeSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.hotel.model.AlarmTypeCreateModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class AlarmTypeService {
    private static final Logger logger = LogManager.getLogger(AlarmTypeService.class);
    @Autowired
    private AlarmTypeRepository alarmTypeRepository;

    public RequestResponse createAlarmType(AlarmTypeCreateModel model) {
        RequestResponse response = new RequestResponse();
        if (model.getAlarmCode() == null || model.getAlarmCode().trim().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Alarm code cannot be empty.");
            return response;
        }
        Optional existingAlarmType = this.alarmTypeRepository.findByAlarmCode(model.getAlarmCode().trim());
        if (existingAlarmType.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Alarm code already exists.");
            return response;
        }
        AlarmType alarmType = new AlarmType();
        alarmType.setCreatedBy(this.getLoggedInUsername());
        alarmType.setCreatedOn(LocalDateTime.now());
        alarmType.setAlarmCode(model.getAlarmCode().trim());
        alarmType.setDescription(model.getDescription());
        alarmType.setRetryCount(model.getRetryCount());
        alarmType.setRetryDelay(model.getRetryDelay());
        alarmType.setActive(model.getActive());
        alarmType.setDefaultLanguage(model.getDefaultLanguage());
        alarmType.setDefaultFile(model.getDefaultFile());
        alarmType.setAlternateNumber(model.getAlternateNumber());
        this.alarmTypeRepository.save((Object)alarmType);
        response.setStatus(Constants.Error.OK);
        response.setMessage("AlarmType created successfully.");
        return response;
    }

    public RequestResponse updateAlarmType(AlarmTypeCreateModel model) {
        RequestResponse response = new RequestResponse();
        if (model.getId() == null) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("ID must be provided for update.");
            return response;
        }
        Optional optionalAlarmType = this.alarmTypeRepository.findById(model.getId());
        if (!optionalAlarmType.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("AlarmType not found.");
            return response;
        }
        Optional duplicateAlarmCode = this.alarmTypeRepository.findByAlarmCode(model.getAlarmCode());
        if (duplicateAlarmCode.isPresent() && !((AlarmType)duplicateAlarmCode.get()).getId().equals(model.getId())) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Alarm code already exists for another record.");
            return response;
        }
        AlarmType alarmType = (AlarmType)optionalAlarmType.get();
        alarmType.setLastUpdatedBy(this.getLoggedInUsername());
        alarmType.setLastUpdatedOn(LocalDateTime.now());
        alarmType.setAlarmCode(model.getAlarmCode());
        alarmType.setDescription(model.getDescription());
        alarmType.setRetryCount(model.getRetryCount());
        alarmType.setRetryDelay(model.getRetryDelay());
        alarmType.setActive(model.getActive());
        alarmType.setDefaultLanguage(model.getDefaultLanguage());
        alarmType.setDefaultFile(model.getDefaultFile());
        alarmType.setAlternateNumber(model.getAlternateNumber());
        this.alarmTypeRepository.save((Object)alarmType);
        response.setStatus(Constants.Error.OK);
        response.setMessage("AlarmType updated successfully.");
        return response;
    }

    public RequestResponse deleteAlarmType(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        List ids = input.getIntId();
        ArrayList toDelete = new ArrayList();
        for (Integer id : ids) {
            Optional alarmType = this.alarmTypeRepository.findById(id);
            if (alarmType.isPresent()) {
                toDelete.add(alarmType.get());
                continue;
            }
            response.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            response.setMessage("Record with ID " + id + " not found.");
            return response;
        }
        this.alarmTypeRepository.deleteAll(toDelete);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Records deleted successfully.");
        return response;
    }

    public RequestResponse getAllRoomExtension(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AlarmTypeSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.alarmTypeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.alarmTypeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public String getLoggedInUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof UserDetails) {
                return ((UserDetails)principal).getUsername();
            }
            return principal.toString();
        }
        return null;
    }

    public RequestResponse listAllAlarmTypes() {
        RequestResponse response = new RequestResponse();
        List alarmTypes = (List)this.alarmTypeRepository.findAll();
        if (alarmTypes == null || alarmTypes.isEmpty()) {
            response.setStatus(Constants.Error.OK);
            response.setMessage("No alarm types found.");
            response.setData(Collections.emptyList());
            return response;
        }
        List models = alarmTypes.stream().map(type -> {
            AlarmTypeCreateModel model = new AlarmTypeCreateModel();
            model.setId(Integer.valueOf(type.getId() != null ? type.getId() : 0));
            model.setCreatedBy(type.getCreatedBy() != null ? type.getCreatedBy() : "");
            model.setCreatedOn(type.getCreatedOn() != null ? type.getCreatedOn().toString() : "");
            model.setLastUpdatedBy(type.getLastUpdatedBy() != null ? type.getLastUpdatedBy() : "");
            model.setLastUpdatedOn(type.getLastUpdatedOn() != null ? type.getLastUpdatedOn().toString() : "");
            model.setAlarmCode(type.getAlarmCode() != null ? type.getAlarmCode() : "");
            model.setDescription(type.getDescription() != null ? type.getDescription() : "");
            model.setRetryCount(Integer.valueOf(type.getRetryCount() != null ? type.getRetryCount() : 0));
            model.setRetryDelay(Integer.valueOf(type.getRetryDelay() != null ? type.getRetryDelay() : 0));
            model.setActive(Boolean.valueOf(type.getActive() != null ? type.getActive() : false));
            model.setDefaultLanguage(type.getDefaultLanguage() != null ? type.getDefaultLanguage() : "");
            model.setDefaultFile(type.getDefaultFile() != null ? type.getDefaultFile() : "");
            model.setAlternateNumber(type.getAlternateNumber() != null ? type.getAlternateNumber() : "");
            return model;
        }).collect(Collectors.toList());
        response.setStatus(Constants.Error.OK);
        response.setMessage("List of Alarm Types");
        response.setData(models);
        return response;
    }
}

