/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.service;

import com.coraltele.db.telephony.pbx.entity.AlarmDetail;
import com.coraltele.db.telephony.pbx.entity.AlarmType;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.AlarmDetailRepository;
import com.coraltele.db.telephony.pbx.repository.AlarmTypeRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.specification.AlarmDetailByPhoneNumberSpecification;
import com.coraltele.db.telephony.pbx.specification.AlarmDetailSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateConverter;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.hotel.model.AlarmDetailCreateModel;
import com.coraltele.service.hotel.model.AlarmDetailModel;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AlarmDetailService {
    private static final Logger logger = LogManager.getLogger(AlarmDetailService.class);
    @Autowired
    AlarmDetailRepository alarmDetailRepository;
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    AlarmTypeRepository alarmTypeRepository;
    @Autowired
    DateConverter dateConverter;

    public RequestResponse alarmProvision(AlarmDetailModel data) {
        LocalDate date = this.dateConverter.convertToLocalDate(data.getScheduledTime());
        RequestResponse returnValue = new RequestResponse();
        if (data.getExtension() == null || data.getActivate() == null) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("parameter is required.");
            returnValue.setMessageDetail("Please provide a valid parameter of extension and activate status.");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        Optional extensions = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getExtension(), "phone", "room");
        Optional alarmType = this.alarmTypeRepository.findByAlarmCode(data.getAlarmTypeCode());
        List alarm = this.alarmDetailRepository.findAllByPhoneNumber(data.getExtension());
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not registered with type phone and subType room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() != 1) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("room not checkIn to set alarm!");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (!alarmType.isPresent() || ((AlarmType)alarmType.get()).getAlarmCode() == null || ((AlarmType)alarmType.get()).getAlarmCode().isEmpty()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("alarm code not exist!");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getActivate().equals(false)) {
            if (alarm.isEmpty()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("alarm not set of this extension for deactivate");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            for (AlarmDetail id : alarm) {
                this.alarmDetailRepository.deleteById((Object)id.getId());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("alarm successfully deactivated ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getActivate().equals(true)) {
            Integer epoch = this.dateConverter.concatenateAndConvertToEpoch(data.getScheduledTime(), date);
            AlarmDetail alarmDetail = new AlarmDetail();
            alarmDetail.setCreatedOn(LocalDateTime.now());
            alarmDetail.setAlarmSource(((AlarmType)alarmType.get()).getCreatedBy());
            alarmDetail.setAlarmTypeId(Long.valueOf(((AlarmType)alarmType.get()).getId().intValue()));
            alarmDetail.setAlarmTypeCode(((AlarmType)alarmType.get()).getAlarmCode());
            alarmDetail.setPhoneNumber(data.getExtension());
            alarmDetail.setScheduledDate(date);
            alarmDetail.setScheduledTime(data.getScheduledTime());
            alarmDetail.setLanguageCode(((AlarmType)alarmType.get()).getDefaultLanguage());
            alarmDetail.setIsActive(((AlarmType)alarmType.get()).getActive());
            alarmDetail.setIsProcessed(Integer.valueOf(1));
            alarmDetail.setScheduledDateTimeEpoch(Integer.valueOf(epoch));
            alarmDetail.setNoOfTry(Integer.valueOf(1));
            alarmDetail.setFilePath(((AlarmType)alarmType.get()).getDefaultFile());
            alarmDetail.setRetryCount(((AlarmType)alarmType.get()).getRetryCount());
            alarmDetail.setRetryDelay(((AlarmType)alarmType.get()).getRetryDelay());
            this.alarmDetailRepository.save((Object)alarmDetail);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("alarm configure successfully");
        returnValue.setData((Object)data);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void removeAlarm(String extension) {
        List list = this.alarmDetailRepository.findAllByPhoneNumber(extension);
        if (!list.isEmpty()) {
            for (AlarmDetail id : list) {
                this.alarmDetailRepository.deleteById((Object)id.getId());
            }
        }
    }

    public RequestResponse createAlarmDetail(AlarmDetailCreateModel model) {
        RequestResponse response = new RequestResponse();
        Optional alarmType = this.alarmTypeRepository.findByAlarmCode(model.getAlarmTypeCode());
        if (!alarmType.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Alarm type not found.");
            return response;
        }
        AlarmDetail detail = new AlarmDetail();
        detail.setAlarmSource(((AlarmType)alarmType.get()).getCreatedBy());
        detail.setAlarmTypeId(Long.valueOf(((AlarmType)alarmType.get()).getId().intValue()));
        detail.setAlarmTypeCode(((AlarmType)alarmType.get()).getAlarmCode());
        detail.setPhoneNumber(model.getPhoneNumber());
        detail.setScheduledDate(model.getScheduledDate() != null ? DateFormatUtility.convertStringToLocalDate((CharSequence)model.getScheduledDate()) : null);
        detail.setScheduledTime(model.getScheduledTime() != null ? DateFormatUtility.stringToLocalTime((String)model.getScheduledTime()) : null);
        detail.setLanguageCode(((AlarmType)alarmType.get()).getDefaultLanguage());
        detail.setIsActive(((AlarmType)alarmType.get()).getActive());
        if (model.getIsActive() == null || !model.getIsActive().booleanValue()) {
            detail.setIsActive(Boolean.valueOf(false));
        } else {
            detail.setIsActive(model.getIsActive());
        }
        detail.setIsProcessed(Integer.valueOf(0));
        detail.setScheduledDateTimeEpoch(Integer.valueOf(model.getScheduledDateTimeEpoch() != null ? model.getScheduledDateTimeEpoch() : 0));
        detail.setNoOfTry(model.getNoOfTry());
        detail.setFilePath(((AlarmType)alarmType.get()).getDefaultFile());
        detail.setRetryCount(((AlarmType)alarmType.get()).getRetryCount());
        detail.setRetryDelay(((AlarmType)alarmType.get()).getRetryDelay());
        detail.setCreatedOn(LocalDateTime.now());
        this.alarmDetailRepository.save((Object)detail);
        response.setStatus(Constants.Error.OK);
        response.setMessage("AlarmDetail created successfully.");
        return response;
    }

    public RequestResponse createAlarmDetail1(AlarmDetailCreateModel data) {
        RequestResponse response = new RequestResponse();
        if (data.getPhoneNumber() == null) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("parameter is required.");
            response.setMessageDetail("Please provide a valid parameter of extension and activate status.");
            logger.info(response.getMessageDetail());
            return response;
        }
        Optional extensionOpt = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getPhoneNumber(), "phone", "room");
        if (!extensionOpt.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Extension not registered with type phone and subType room");
            logger.info(response.getMessage());
            return response;
        }
        if (((Extension)extensionOpt.get()).getCheckIn() != 1) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("room not checkIn to set alarm!");
            logger.info(response.getMessage());
            return response;
        }
        Optional alarmTypeOpt = this.alarmTypeRepository.findByAlarmCode(data.getAlarmTypeCode());
        if (!alarmTypeOpt.isPresent() || ((AlarmType)alarmTypeOpt.get()).getAlarmCode() == null || ((AlarmType)alarmTypeOpt.get()).getAlarmCode().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("alarm code not exist!");
            logger.info(response.getMessage());
            return response;
        }
        LocalDate date = this.dateConverter.convertToLocalDate(LocalTime.parse(data.getScheduledTime()));
        Integer epoch = this.dateConverter.concatenateAndConvertToEpoch(LocalTime.parse(data.getScheduledTime()), date);
        List existingAlarms = this.alarmDetailRepository.findAllByPhoneNumber(data.getPhoneNumber());
        boolean alarmExists = existingAlarms.stream().anyMatch(alarm -> alarm.getScheduledDateTimeEpoch().equals(epoch));
        if (alarmExists) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Alarm already scheduled at the same time for this extension.");
            logger.info(response.getMessage());
            return response;
        }
        AlarmType alarmType = (AlarmType)alarmTypeOpt.get();
        AlarmDetail alarmDetail = new AlarmDetail();
        alarmDetail.setCreatedOn(LocalDateTime.now());
        alarmDetail.setAlarmSource(alarmType.getCreatedBy());
        alarmDetail.setAlarmTypeId(Long.valueOf(alarmType.getId().intValue()));
        alarmDetail.setAlarmTypeCode(alarmType.getAlarmCode());
        alarmDetail.setPhoneNumber(data.getPhoneNumber());
        alarmDetail.setScheduledDate(date);
        alarmDetail.setScheduledTime(LocalTime.parse(data.getScheduledTime()));
        alarmDetail.setLanguageCode(alarmType.getDefaultLanguage());
        alarmDetail.setIsActive(alarmType.getActive());
        alarmDetail.setIsProcessed(Integer.valueOf(1));
        alarmDetail.setScheduledDateTimeEpoch(epoch);
        alarmDetail.setNoOfTry(Integer.valueOf(1));
        alarmDetail.setFilePath(alarmType.getDefaultFile());
        alarmDetail.setRetryCount(alarmType.getRetryCount());
        alarmDetail.setRetryDelay(alarmType.getRetryDelay());
        this.alarmDetailRepository.save((Object)alarmDetail);
        response.setStatus(Constants.Error.OK);
        response.setMessage("alarm configure successfully");
        response.setData((Object)data);
        logger.info(response.getMessage());
        return response;
    }

    public RequestResponse updateAlarmDetail(AlarmDetailCreateModel data) {
        RequestResponse response = new RequestResponse();
        if (data.getPhoneNumber() == null || data.getScheduledTime() == null || data.getId() == null) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("phoneNumber, scheduledTime, and id are required.");
            logger.info(response.getMessage());
            return response;
        }
        Optional extensionOpt = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getPhoneNumber(), "phone", "room");
        if (!extensionOpt.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Extension not registered with type phone and subType room");
            logger.info(response.getMessage());
            return response;
        }
        if (((Extension)extensionOpt.get()).getCheckIn() != 1) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Room not checkIn to update alarm!");
            logger.info(response.getMessage());
            return response;
        }
        Optional alarmTypeOpt = this.alarmTypeRepository.findByAlarmCode(data.getAlarmTypeCode());
        if (!alarmTypeOpt.isPresent() || ((AlarmType)alarmTypeOpt.get()).getAlarmCode() == null || ((AlarmType)alarmTypeOpt.get()).getAlarmCode().isEmpty()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Alarm code does not exist!");
            logger.info(response.getMessage());
            return response;
        }
        LocalDate date = this.dateConverter.convertToLocalDate(LocalTime.parse(data.getScheduledTime()));
        Integer newEpoch = this.dateConverter.concatenateAndConvertToEpoch(LocalTime.parse(data.getScheduledTime()), date);
        Optional alarmOpt = this.alarmDetailRepository.findById(data.getId());
        if (!alarmOpt.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Alarm record not found.");
            logger.info(response.getMessage());
            return response;
        }
        AlarmDetail alarmDetail = (AlarmDetail)alarmOpt.get();
        List conflicts = this.alarmDetailRepository.findAllByPhoneNumber(data.getPhoneNumber());
        boolean conflictExists = conflicts.stream().anyMatch(a -> a.getScheduledDateTimeEpoch().equals(newEpoch) && !a.getId().equals(data.getId()));
        if (conflictExists) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Another alarm is already scheduled at this time for this extension.");
            logger.info(response.getMessage());
            return response;
        }
        AlarmType alarmType = (AlarmType)alarmTypeOpt.get();
        alarmDetail.setAlarmSource(alarmType.getCreatedBy());
        alarmDetail.setAlarmTypeId(Long.valueOf(alarmType.getId().intValue()));
        alarmDetail.setAlarmTypeCode(alarmType.getAlarmCode());
        alarmDetail.setScheduledDate(date);
        alarmDetail.setScheduledTime(LocalTime.parse(data.getScheduledTime()));
        alarmDetail.setScheduledDateTimeEpoch(newEpoch);
        alarmDetail.setLanguageCode(alarmType.getDefaultLanguage());
        alarmDetail.setIsActive(alarmType.getActive());
        alarmDetail.setFilePath(alarmType.getDefaultFile());
        alarmDetail.setRetryCount(alarmType.getRetryCount());
        alarmDetail.setRetryDelay(alarmType.getRetryDelay());
        this.alarmDetailRepository.save((Object)alarmDetail);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Alarm updated successfully.");
        response.setData((Object)data);
        logger.info(response.getMessage());
        return response;
    }

    public RequestResponse deleteAlarmDetail(InputIdModel input) {
        RequestResponse response = new RequestResponse();
        List ids = input.getIntId();
        ArrayList toDelete = new ArrayList();
        for (Integer id : ids) {
            Optional optional = this.alarmDetailRepository.findById(id);
            if (optional.isPresent()) {
                toDelete.add(optional.get());
                continue;
            }
            response.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            response.setMessage("AlarmDetail with ID " + id + " not found.");
            return response;
        }
        this.alarmDetailRepository.deleteAll(toDelete);
        response.setStatus(Constants.Error.OK);
        response.setMessage("AlarmDetail records deleted successfully.");
        return response;
    }

    public RequestResponse getAllAlarmDetails(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AlarmDetailSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.alarmDetailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.alarmDetailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<AlarmDetailCreateModel> entityToModelConversion(List<AlarmDetail> entityList) {
        ArrayList<AlarmDetailCreateModel> modelList = new ArrayList<AlarmDetailCreateModel>();
        for (AlarmDetail entity : entityList) {
            AlarmDetailCreateModel model = new AlarmDetailCreateModel();
            model.setId(entity.getId());
            model.setAlarmSource(entity.getAlarmSource());
            model.setAlarmTypeId(entity.getAlarmTypeId());
            model.setAlarmTypeCode(entity.getAlarmTypeCode());
            model.setPhoneNumber(entity.getPhoneNumber());
            model.setScheduledDate(DateFormatUtility.localDateToString((LocalDate)entity.getScheduledDate()));
            model.setScheduledTime(DateFormatUtility.localTimeToString1((LocalTime)entity.getScheduledTime()));
            model.setLanguageCode(entity.getLanguageCode());
            model.setFilePath(entity.getFilePath());
            model.setIsActive(entity.getIsActive());
            model.setIsProcessed(entity.getIsProcessed());
            model.setScheduledDateTimeEpoch(entity.getScheduledDateTimeEpoch());
            model.setNoOfTry(entity.getNoOfTry());
            model.setRetryCount(entity.getRetryCount());
            model.setRetryDelay(entity.getRetryDelay());
            modelList.add(model);
        }
        return modelList;
    }

    public void updatePhoneNumberByExtension(String oldExtension, String newExtension) {
        if (oldExtension == null || newExtension == null || oldExtension.isEmpty() || newExtension.isEmpty()) {
            return;
        }
        List list = this.alarmDetailRepository.findAllByPhoneNumber(oldExtension);
        if (list.isEmpty()) {
            return;
        }
        for (AlarmDetail detail : list) {
            detail.setPhoneNumber(newExtension);
        }
        this.alarmDetailRepository.saveAll((Iterable)list);
    }

    public RequestResponse getFilterAlarmByPhoneNumber(SearchRequest searchRequestData, String extType) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AlarmDetailByPhoneNumberSpecification.generateFilters((SearchRequest)searchRequestData, (String)extType);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.alarmDetailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.alarmDetailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

