/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.hotel.model.HotelExtensionCreateModel;
import com.coraltele.service.hotel.model.UpdateGroupModel;
import com.coraltele.service.hotel.model.VmAndDndModel;
import com.coraltele.service.hotel.service.FeatureCodeService;
import com.coraltele.service.hotel.service.HotelExtensionService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/hotelExtension"})
public class HotelExtensionController {
    private static final Logger logger = LogManager.getLogger(HotelExtensionController.class);
    @Autowired
    private HotelExtensionService hotelExtensionService;
    @Autowired
    FeatureCodeService featureCodeService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createData(@RequestBody HotelExtensionCreateModel data) {
        RequestResponse returnValue = this.hotelExtensionService.createExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateData(@RequestBody HotelExtensionCreateModel data) {
        RequestResponse returnValue = this.hotelExtensionService.updateExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.hotelExtensionService.listAllExtensions();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.hotelExtensionService.deleteHotelExtension(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/callBarring"})
    public ResponseEntity<RequestResponse> callBarring(@RequestBody UpdateGroupModel id) {
        RequestResponse returnValue = this.featureCodeService.updateGroup(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateLevel/{extension}/{level}"})
    public ResponseEntity<RequestResponse> getAllHotel(@PathVariable(value="extension") String extension, @PathVariable(value="level") Integer level) {
        RequestResponse returnValue = this.hotelExtensionService.updateExtensionLevel(extension, level);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateVmOrDnd"})
    public ResponseEntity<RequestResponse> updateVm(@RequestBody VmAndDndModel model) {
        RequestResponse returnValue = this.hotelExtensionService.updateExtensionVmAndDnd(model);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllCheckInUser"})
    public ResponseEntity<RequestResponse> getAllCheckInUser() {
        RequestResponse returnValue = this.hotelExtensionService.listAllCheckInUser();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

