/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.hotel.model.FeatureCodeModel;
import com.coraltele.service.hotel.model.UpdateGroupModel;
import com.coraltele.service.hotel.service.FeatureCodeHistoryService;
import com.coraltele.service.hotel.service.FeatureCodeService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/featureCode"})
public class FeatureCodeController {
    private static final Logger logger = LogManager.getLogger(FeatureCodeController.class);
    @Autowired
    private FeatureCodeService featureCodeService;
    @Autowired
    private FeatureCodeHistoryService featureCodeHistoryService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createData(@RequestBody FeatureCodeModel data) {
        RequestResponse returnValue = this.featureCodeService.createFeatureCode(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateData(@RequestBody FeatureCodeModel data) {
        RequestResponse returnValue = this.featureCodeService.updateFeatureCode(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.featureCodeService.deleteFeatureCode(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllExtensionView(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.featureCodeService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("Code list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting code list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateGroup"})
    public ResponseEntity<RequestResponse> updateGroup(@RequestBody UpdateGroupModel model) {
        RequestResponse returnValue = this.featureCodeService.updateGroup(model);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateDirtyCleanMaster/{id}"})
    public ResponseEntity<RequestResponse> updateDirtyCleanMaster(@PathVariable Long id) {
        RequestResponse returnValue = this.featureCodeService.updateDirtyCleanMaster(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/saveCheckCodeCDR"})
    public ResponseEntity<RequestResponse> saveCheckCodeCDR(@RequestBody FeatureCodeModel data) {
        RequestResponse returnValue = this.featureCodeHistoryService.createFeatureCdeHistory(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/getTodayHistory/{extension}"})
    public ResponseEntity<RequestResponse> getAllHotel(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.featureCodeHistoryService.getFeatureCodeHistoryByRoomNumber(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

