/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.hotel.model.AlarmDetailCreateModel;
import com.coraltele.service.hotel.service.AlarmDetailService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/alarmDetail"})
public class AlarmDetailController {
    private static final Logger logger = LogManager.getLogger(AlarmDetailController.class);
    @Autowired
    private AlarmDetailService alarmDetailService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createData(@RequestBody AlarmDetailCreateModel data) {
        RequestResponse returnValue = this.alarmDetailService.createAlarmDetail1(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateData(@RequestBody AlarmDetailCreateModel data) {
        RequestResponse returnValue = this.alarmDetailService.updateAlarmDetail(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.alarmDetailService.deleteAlarmDetail(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllAlarmDetails(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.alarmDetailService.getAllAlarmDetails(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("Alarm detail list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting Alarm detail list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/{extType}"})
    public ResponseEntity<RequestResponse> getFilterAlarmByPhoneNumber(@PathVariable(value="extType") String extType, @RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.alarmDetailService.getFilterAlarmByPhoneNumber(searchRequest, extType);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

