/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.users.service;

import com.coraltele.db.coralapps.users.entity.Users;
import com.coraltele.db.coralapps.users.repository.UsersRepositoryCoralApps;
import com.coraltele.service.user.model.UserModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UsersService {
    private static final Logger logger = LogManager.getLogger(UsersService.class);
    @Autowired
    UsersRepositoryCoralApps usersRepository;
    @Autowired
    private PasswordEncoder bcryptEncoder;

    public void createNewUser(UserModel data, Principal principal) {
        try {
            Users users = new Users();
            users.setUsername(data.getUsername());
            if (data.getDefaultPassword() != null && data.getDefaultPassword().booleanValue()) {
                users.setPassword(this.bcryptEncoder.encode((CharSequence)"12345"));
            } else {
                users.setPassword(this.bcryptEncoder.encode((CharSequence)data.getPassword()));
            }
            if (StringUtils.hasText((String)data.getContactNo())) {
                users.setExtension(Integer.valueOf(Integer.parseInt(data.getContactNo())));
            }
            users.setFirstName(data.getDescription());
            users.setIsDisabled(Boolean.valueOf(data.getEnabled() == null || data.getEnabled() == false));
            users.setCreatedOn(LocalDateTime.now());
            users.setCreatedBy(principal.getName());
            users.setEmployeeId(data.getUsername());
            users.setEmailId(data.getEmailId());
            users.setIsOnDemand(data.getIsOnDemand());
            users.setMaxNoAnswer(data.getMaxNoAnswer());
            users.setWrapUpTime(data.getWrapUpTime());
            users.setRejectDelayTime(data.getRejectDelayTime());
            users.setBusyDelayTime(data.getBusyDelayTime());
            users.setNoAnswerDelayTime(data.getNoAnswerDelayTime());
            users.setCallTimeout(data.getCallTimeout());
            users.setAutoAnswer(data.getAutoAnswer());
            this.usersRepository.save((Object)users);
            logger.info("New user created successfully for coralApps");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error on Creation New user for coralApps,{}", (Object)e.getMessage());
        }
    }

    public void updateUser(UserModel data, Principal principal) {
        try {
            Optional users = this.usersRepository.findByUsername(data.getUsername());
            if (users.isPresent()) {
                if (data.getUsername() != null) {
                    ((Users)users.get()).setUsername(data.getUsername());
                }
                if (data.getEnabled() != null) {
                    if (data.getEnabled().booleanValue()) {
                        ((Users)users.get()).setIsDisabled(Boolean.valueOf(true));
                    } else {
                        ((Users)users.get()).setIsDisabled(Boolean.valueOf(false));
                    }
                }
                if (data.getEmailId() != null) {
                    ((Users)users.get()).setEmailId(data.getEmailId());
                }
                if (data.getContactNo() != null) {
                    ((Users)users.get()).setExtension(Integer.valueOf(Integer.parseInt(data.getContactNo())));
                }
                if (data.getIsOnDemand() != null) {
                    ((Users)users.get()).setIsOnDemand(data.getIsOnDemand());
                }
                if (data.getMaxNoAnswer() != null) {
                    ((Users)users.get()).setMaxNoAnswer(data.getMaxNoAnswer());
                }
                if (data.getWrapUpTime() != null) {
                    ((Users)users.get()).setWrapUpTime(data.getWrapUpTime());
                }
                if (data.getRejectDelayTime() != null) {
                    ((Users)users.get()).setRejectDelayTime(data.getRejectDelayTime());
                }
                if (data.getBusyDelayTime() != null) {
                    ((Users)users.get()).setBusyDelayTime(data.getBusyDelayTime());
                }
                if (data.getNoAnswerDelayTime() != null) {
                    ((Users)users.get()).setNoAnswerDelayTime(data.getNoAnswerDelayTime());
                }
                if (data.getCallTimeout() != null) {
                    ((Users)users.get()).setCallTimeout(data.getCallTimeout());
                }
                if (data.getAutoAnswer() != null) {
                    ((Users)users.get()).setAutoAnswer(data.getAutoAnswer());
                }
                if (data.getPassword() != null) {
                    ((Users)users.get()).setPassword(this.bcryptEncoder.encode((CharSequence)data.getPassword()));
                }
                this.usersRepository.save(users.get());
                logger.info("update coralApps user successfully");
            } else {
                logger.error("user not present in coralApps");
            }
        }
        catch (Exception e) {
            logger.error("failed to update coralApps user data");
        }
    }
}

