/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.systemConfiguration.service;

import com.coraltele.db.coralapps.callcenter.entity.SystemConfiguration;
import com.coraltele.db.coralapps.callcenter.repository.SystemConfigurationRepository;
import com.coraltele.db.coralapps.callcenter.specification.SystemConfigurationSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.systemConfiguration.model.SystemConfigurationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SystemConfigurationService {
    private static final Logger logger = LogManager.getLogger(SystemConfigurationService.class);
    @Autowired
    private SystemConfigurationRepository systemConfigurationRepository;

    /*
     * Enabled aggressive block sorting
     */
    public RequestResponse createOrUpdateConfig(SystemConfigurationModel model) {
        SystemConfiguration config;
        RequestResponse response = new RequestResponse();
        if (model == null) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Request body is missing.");
            return response;
        }
        if (model.getId() != null) {
            Optional existing = this.systemConfigurationRepository.findById((Object)model.getId());
            if (!existing.isPresent()) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("System config with ID " + model.getId() + " not found.");
                return response;
            }
            config = (SystemConfiguration)existing.get();
        } else {
            long count = this.systemConfigurationRepository.count();
            if (count > 0L) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Only one system configuration is allowed.");
                return response;
            }
            config = new SystemConfiguration();
        }
        config.setStartAgentActivity(Boolean.valueOf(Boolean.TRUE.equals(model.getStartAgentActivity())));
        config.setStartAgentSyncAcrossServers(Boolean.valueOf(Boolean.TRUE.equals(model.getStartAgentSyncAcrossServers())));
        config.setPostCallDispositionUrl(model.getPostCallDispositionUrl() != null ? model.getPostCallDispositionUrl().trim() : "");
        config.setPreviewDialingMode(Integer.valueOf(model.getPreviewDialingMode() != null ? model.getPreviewDialingMode() : 0));
        config.setRealtimeDataDaysCallCenter(Integer.valueOf(model.getRealtimeDataDaysCallCenter() != null ? model.getRealtimeDataDaysCallCenter() : 1));
        config.setCallCenterAgentMode(Integer.valueOf(model.getCallCenterAgentMode() != null ? model.getCallCenterAgentMode() : 0));
        this.systemConfigurationRepository.save((Object)config);
        response.setStatus(Constants.Error.OK);
        response.setMessage(model.getId() != null ? "Updated successfully." : "Created successfully.");
        return response;
    }

    public RequestResponse deleteSystemConfiguration(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional shift = this.systemConfigurationRepository.findById((Object)ids);
            if (shift.isPresent()) {
                addValue.add(shift.get());
                this.systemConfigurationRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = SystemConfigurationSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.systemConfigurationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.systemConfigurationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<SystemConfigurationModel> entityToModelConversion(List<SystemConfiguration> configList) {
        ArrayList<SystemConfigurationModel> result = new ArrayList<SystemConfigurationModel>();
        for (SystemConfiguration entity : configList) {
            SystemConfigurationModel model = new SystemConfigurationModel();
            model.setId(entity.getId());
            model.setStartAgentActivity(Boolean.valueOf(entity.getStartAgentActivity() != null ? entity.getStartAgentActivity() : false));
            model.setStartAgentSyncAcrossServers(Boolean.valueOf(entity.getStartAgentSyncAcrossServers() != null ? entity.getStartAgentSyncAcrossServers() : false));
            model.setPostCallDispositionUrl(entity.getPostCallDispositionUrl() != null ? entity.getPostCallDispositionUrl() : "");
            model.setPreviewDialingMode(Integer.valueOf(entity.getPreviewDialingMode() != null ? entity.getPreviewDialingMode() : 0));
            model.setRealtimeDataDaysCallCenter(Integer.valueOf(entity.getRealtimeDataDaysCallCenter() != null ? entity.getRealtimeDataDaysCallCenter() : 1));
            model.setCallCenterAgentMode(Integer.valueOf(entity.getCallCenterAgentMode() != null ? entity.getCallCenterAgentMode() : 0));
            result.add(model);
        }
        return result;
    }
}

