/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.systemConfiguration.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.systemConfiguration.model.SystemConfigurationModel;
import com.coraltele.service.coralApps.callcenter.systemConfiguration.service.SystemConfigurationService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/systemConfiguration"})
public class SystemConfigurationController {
    private static final Logger logger = LogManager.getLogger(SystemConfigurationController.class);
    @Autowired
    private SystemConfigurationService systemConfigService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createOrUpdateConfig(@RequestBody SystemConfigurationModel configModel) {
        RequestResponse response = this.systemConfigService.createOrUpdateConfig(configModel);
        if (Constants.Error.OK.equals((Object)response.getStatus())) {
            return ResponseEntity.ok((Object)response);
        }
        return ResponseEntity.badRequest().body((Object)response);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.systemConfigService.deleteSystemConfiguration(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllExtensionView(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.systemConfigService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("queueTL list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting queueTL list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

