/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.uc_notification.service;

import com.coraltele.db.billing.main.entity.UcNotification;
import com.coraltele.db.billing.main.repository.UcNotificationRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.billing.main.uc_notification.model.NotificationModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class UcNotificationService {
    private static final Logger logger = LogManager.getLogger(UcNotificationService.class);
    @Autowired
    private UcNotificationRepository repository;

    public RequestResponse getCountNotification(Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("count notification api call");
        List list = this.repository.findAllByUcUser(authentication.getName());
        ArrayList data = new ArrayList();
        if (list != null && !list.isEmpty()) {
            for (UcNotification row : list) {
                data.addAll(this.createNotificationModels(row));
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("list of count notification");
        returnValue.setData(data);
        logger.info("notification list return successfully");
        return returnValue;
    }

    private void checkNotificationRecord(String userName) {
        Optional userRecord = this.repository.findByUcUser(userName);
        if (!userRecord.isPresent()) {
            this.createNotificationRecord(userName);
        }
    }

    private synchronized void createNotificationRecord(String userName) {
        try {
            UcNotification userRecord = new UcNotification();
            userRecord.setUcUser(userName);
            userRecord.setCallback(Integer.valueOf(0));
            userRecord.setFax(Integer.valueOf(0));
            userRecord.setFileUpload(Integer.valueOf(0));
            userRecord.setMessages(Integer.valueOf(0));
            userRecord.setMissedCall(Integer.valueOf(0));
            userRecord.setVoicemail(Integer.valueOf(0));
            this.repository.save((Object)userRecord);
        }
        catch (Exception E) {
            logger.error("Error while creating  uc user record for {} ", (Object)userName);
        }
    }

    private List<NotificationModel> createNotificationModels(UcNotification row) {
        ArrayList<NotificationModel> models = new ArrayList<NotificationModel>();
        models.add(this.createModel("4", row.getMissedCall()));
        models.add(this.createModel("1", row.getVoicemail()));
        models.add(this.createModel("5", row.getCallback()));
        models.add(this.createModel("6", row.getMessages()));
        models.add(this.createModel("2", row.getFax()));
        return models;
    }

    private NotificationModel createModel(String messageType, Integer count) {
        NotificationModel model = new NotificationModel();
        model.setMessageType(messageType);
        model.setCount(count);
        return model;
    }

    public RequestResponse updateMessageCount(List<String> ucUser) {
        logger.debug("Data For UcNotification {0} ", ucUser);
        RequestResponse returnValue = new RequestResponse();
        ucUser.forEach(destination -> {
            this.checkNotificationRecord(destination);
            Optional received = this.repository.findByUcUser(destination);
            if (received.isPresent()) {
                ((UcNotification)received.get()).setMessages(Integer.valueOf((((UcNotification)received.get()).getMessages() == null ? 0 : ((UcNotification)received.get()).getMessages()) + 1));
                this.repository.save(received.get());
            }
        });
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("UcNotification Has Been Updated With New Records ");
        logger.info("Records In UcNotification Has Been Updated");
        return returnValue;
    }

    public RequestResponse updateFaxCount(List<String> ucUser) {
        logger.debug("Data For UcNotification {0} ", ucUser);
        RequestResponse returnValue = new RequestResponse();
        ucUser.forEach(destination -> {
            this.checkNotificationRecord(destination);
            Optional received = this.repository.findByUcUser(destination);
            if (received.isPresent()) {
                ((UcNotification)received.get()).setFax(Integer.valueOf(((UcNotification)received.get()).getFax() + 1));
                this.repository.save(received.get());
            }
        });
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("UcNotification Has Been Updated With New Records ");
        logger.info("Records In UcNotification Has Been Updated");
        return returnValue;
    }

    public RequestResponse updateVoiceMailCount(List<String> ucUser) {
        logger.debug("Data For UcNotification {0} ", ucUser);
        RequestResponse returnValue = new RequestResponse();
        ucUser.forEach(destination -> {
            this.checkNotificationRecord(destination);
            Optional received = this.repository.findByUcUser(destination);
            if (received.isPresent()) {
                ((UcNotification)received.get()).setVoicemail(Integer.valueOf(((UcNotification)received.get()).getVoicemail() + 1));
                this.repository.save(received.get());
            }
        });
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("UcNotification Has Been Updated With New Records ");
        logger.info("Records In UcNotification Has Been Updated");
        return returnValue;
    }

    public RequestResponse updateNotificationForMissedCall(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.checkNotificationRecord(principal.getName());
        List list = this.repository.findAllByUcUser(principal.getName());
        if (list != null && !list.isEmpty()) {
            for (UcNotification data : list) {
                data.setMissedCall(Integer.valueOf(0));
                this.repository.save((Object)data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Data Updated");
        returnValue.setMessageDetail("successfully update");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse updateNotificationForMessages(Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        this.checkNotificationRecord(authentication.getName());
        List list = this.repository.findAllByUcUser(authentication.getName());
        if (list != null && !list.isEmpty()) {
            for (UcNotification data : list) {
                data.setMessages(Integer.valueOf(0));
                this.repository.save((Object)data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Data Updated");
        returnValue.setMessageDetail("successfully update");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse updateNotificationForVoicemail(Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        this.checkNotificationRecord(authentication.getName());
        List list = this.repository.findAllByUcUser(authentication.getName());
        if (list != null && !list.isEmpty()) {
            for (UcNotification data : list) {
                data.setVoicemail(Integer.valueOf(0));
                this.repository.save((Object)data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Data Updated");
        returnValue.setMessageDetail("successfully update");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse updateNotificationForFax(Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        this.checkNotificationRecord(authentication.getName());
        List list = this.repository.findAllByUcUser(authentication.getName());
        if (list != null && !list.isEmpty()) {
            for (UcNotification data : list) {
                data.setFax(Integer.valueOf(0));
                this.repository.save((Object)data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Data Updated");
        returnValue.setMessageDetail("successfully update");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse updateNotificationForCallBack(Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        this.checkNotificationRecord(authentication.getName());
        List list = this.repository.findAllByUcUser(authentication.getName());
        if (list != null && !list.isEmpty()) {
            for (UcNotification data : list) {
                data.setCallback(Integer.valueOf(0));
                this.repository.save((Object)data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Data Updated");
        returnValue.setMessageDetail("successfully update");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }
}

