/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.helper.Constants;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.joda.time.Days;
import org.joda.time.ReadablePartial;
import org.springframework.stereotype.Component;

@Component
public class DateFormatUtility {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static long getDaysDifference(LocalDate previousDate, LocalDate currentDate) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String convertPreviousDate = dateTimeFormatter.format(previousDate);
        String convertCurrentDate = dateTimeFormatter.format(currentDate);
        org.joda.time.LocalDate dateBefore = org.joda.time.LocalDate.parse((String)convertPreviousDate);
        org.joda.time.LocalDate dateAfter = org.joda.time.LocalDate.parse((String)convertCurrentDate);
        long daysDifference = Math.abs(Days.daysBetween((ReadablePartial)dateBefore, (ReadablePartial)dateAfter).getDays());
        return daysDifference;
    }

    public static LocalDateTime convertStringToTimestamp(String dateString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM d, yyyy h:mm:ss a");
        LocalDateTime localDateTime = LocalDateTime.parse(dateString, formatter);
        return localDateTime;
    }

    public static LocalDateTime epochToLocalDateTimeAsString(Long epoch) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epoch), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss a");
        String formatDateTime = localDateTime.format(formatter);
        return LocalDateTime.parse(formatDateTime, formatter);
    }

    public static LocalDateTime epochToLocalDateTimeAsStringForSecond(Long epoch) {
        if (epoch == null || epoch == 0L) {
            return LocalDateTime.of(1970, 1, 1, 0, 0, 0);
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-ddHH:mm:ss a");
        String formatDateTime = localDateTime.format(formatter);
        return LocalDateTime.parse(formatDateTime, formatter);
    }

    public static String epochToLocalDateTimeAsStringToHandleNull(Long epoch) {
        if (epoch == null || epoch == 0L) {
            return "";
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return localDateTime.format(formatter);
    }

    public static String dateAndTimeFormatter(LocalDateTime currentTime) {
        DateTimeFormatter myFormatObj = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm");
        if (currentTime != null) {
            String formattedDateAndTime = currentTime.format(myFormatObj);
            return formattedDateAndTime;
        }
        return "";
    }

    public static String dateAndTimeFormatterForSeconds(LocalDateTime currentTime) {
        DateTimeFormatter myFormatObj = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        if (currentTime != null) {
            String formattedDateAndTime = currentTime.format(myFormatObj);
            return formattedDateAndTime;
        }
        return "";
    }

    public static Object epochToLocalDateTimeAsStringForSecondToHandleZero(Long epoch) {
        if (epoch == 0L || epoch == null) {
            return "";
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formatDateTime = localDateTime.format(formatter);
        return formatDateTime;
    }

    public static LocalDateTime convertStringToLocalDateTime(String dateTimeInput) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
        LocalDateTime dateTime = LocalDateTime.parse(dateTimeInput, formatter);
        return dateTime;
    }

    public static LocalDate convertStringToLocalDate(CharSequence date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate localDate = LocalDate.parse(date, formatter);
        return localDate;
    }

    public static int convertToLocalDateTimeToEpoch(LocalDateTime localDateTime) {
        return (int)localDateTime.toEpochSecond(OffsetDateTime.now().getOffset());
    }

    public static long convertLocalDateTimeToEpochLong(LocalDateTime localDateTime) {
        if (localDateTime != null) {
            return localDateTime.toEpochSecond(OffsetDateTime.now().getOffset());
        }
        return 0L;
    }

    public static long convertToEpochSeconds(LocalDateTime dateTime) {
        return dateTime.toEpochSecond(OffsetDateTime.now().getOffset());
    }

    public static String findLocalTime(Long time) {
        if (time != null) {
            long hours = time / 3600L;
            long minutes = time % 3600L / 60L;
            long seconds = time % 60L;
            String formattedTime = String.format("%02d:%02d:%02d", hours, minutes, seconds);
            return formattedTime;
        }
        return "00:00:00";
    }

    public static String findLocalTimeForInteger(Integer time) {
        if (time != null) {
            long hours = time / 3600;
            long minutes = time % 3600 / 60;
            long seconds = time % 60;
            String formattedTime = String.format("%02d:%02d:%02d", hours, minutes, seconds);
            return formattedTime;
        }
        return "00:00:00";
    }

    public LocalDate epochToLocalDate(Long epoch) {
        if (epoch == null) {
            return null;
        }
        Instant instant = epoch > 1000000000000L ? Instant.ofEpochMilli(epoch) : Instant.ofEpochSecond(epoch);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
    }

    public static Long toEpochSeconds(String dateTimeStr) {
        LocalDateTime dateTime = LocalDateTime.parse(dateTimeStr);
        return dateTime.atZone(ZoneId.systemDefault()).toInstant().getEpochSecond();
    }

    public static String fromEpochSeconds(Long epochSeconds) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds), ZoneId.systemDefault());
        return dateTime.toString();
    }

    public static long convertLocalTimeToSeconds(LocalTime time) {
        return time.getHour() * 3600 + time.getMinute() * 60;
    }

    public static LocalTime convertSecondsToLocalTime(Long seconds) {
        if (seconds == null) {
            return null;
        }
        int hours = (int)(seconds / 3600L);
        int minutes = (int)(seconds % 3600L / 60L);
        return LocalTime.of(hours, minutes);
    }

    public static LocalDateTime epochToLocalDateTime(Long epoch) {
        if (epoch == null) {
            throw new IllegalArgumentException("Epoch value cannot be null");
        }
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), ZoneId.systemDefault());
    }

    public static Long localDateTimeToEpoch(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            throw new IllegalArgumentException("LocalDateTime cannot be null");
        }
        return localDateTime.toEpochSecond(ZoneOffset.ofTotalSeconds(ZoneId.systemDefault().getRules().getOffset(localDateTime).getTotalSeconds()));
    }

    public static String localTimeToString(LocalTime time) {
        if (time == null) {
            return null;
        }
        return time.format(formatter);
    }

    public static String localTimeToString1(LocalTime time) {
        if (time == null) {
            return null;
        }
        return time.format(DateTimeFormatter.ofPattern("HH:mm"));
    }

    public static LocalTime stringToLocalTime(String timeStr) {
        if (timeStr == null || timeStr.isEmpty()) {
            return null;
        }
        try {
            return LocalTime.parse(timeStr, formatter);
        }
        catch (DateTimeParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LocalDateTime parseToLocalDateTime(String dateTimeStr) {
        if (dateTimeStr == null || dateTimeStr.isEmpty()) {
            return null;
        }
        try {
            return LocalDateTime.parse(dateTimeStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        catch (DateTimeParseException e) {
            System.err.println("Invalid date format: " + dateTimeStr);
            return null;
        }
    }

    public static String formatToString(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static LocalDateTime epochToLocalDateTimeInUTC(Long epoch) {
        if (epoch == null || epoch == 0L) {
            return LocalDateTime.of(1970, 1, 1, 0, 0, 0);
        }
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), ZoneOffset.UTC);
    }

    public LocalDate epochToLocalDateForLocalTimeZone(Long epoch) {
        return Instant.ofEpochSecond(epoch).atZone(ZoneId.of(Constants.TIME_ZONE_FOR_SUMMARY)).toLocalDate();
    }

    public static LocalDateTime epochToLocalDateTimeForLocalTimeZone(Long epoch) {
        if (epoch == null || epoch == 0L) {
            return LocalDateTime.of(1970, 1, 1, 0, 0, 0);
        }
        ZoneId zoneId = ZoneId.of(Constants.TIME_ZONE_FOR_SUMMARY);
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), zoneId);
    }

    public static String localDateToString(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }
}

