/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.stereotype.Service;

@Service
public class CallServerConfiguration {
    private static String configurationFile = "/etc/coraltele/conf/app.config";

    public String getProperty(String propertyName) {
        FileInputStream input = null;
        Properties prop = new Properties();
        String returnValue = "";
        try {
            input = new FileInputStream(configurationFile);
            prop.load(input);
            returnValue = prop.getProperty(propertyName);
            ((InputStream)input).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public Integer getIntProperty(String propertyName) {
        FileInputStream input = null;
        Properties prop = new Properties();
        Integer returnValue = 0;
        try {
            input = new FileInputStream(configurationFile);
            prop.load(input);
            String propertyValue = prop.getProperty(propertyName);
            if (propertyValue == null || propertyValue.isEmpty()) {
                returnValue = 30;
            } else {
                try {
                    returnValue = Integer.parseInt(propertyValue);
                }
                catch (Exception e) {
                    returnValue = 30;
                }
            }
            ((InputStream)input).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public void setProperty(String propertyName, String propertyValue) {
        FileInputStream input = null;
        Properties prop = new Properties();
        try {
            input = new FileInputStream(configurationFile);
            prop.load(input);
            ((InputStream)input).close();
            FileOutputStream output = new FileOutputStream(configurationFile);
            prop.setProperty(propertyName, propertyValue);
            prop.store(output, null);
            output.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

