DO $$
BEGIN
    IF NOT EXISTS (
        SELECT FROM pg_tables WHERE schemaname = 'public' AND tablename = 'voicemail_msgs'
    ) THEN
        
        CREATE TABLE public.voicemail_msgs (
            created_epoch integer,
            read_epoch integer,
            username character varying(255),
            domain character varying(255),
            uuid character varying(255),
            cid_name character varying(255),
            cid_number character varying(255),
            in_folder character varying(255),
            file_path character varying(255),
            message_len integer,
            flags character varying(255),
            read_flags character varying(255),
            forwarded_by character varying(255),
            coralid integer,
            destinationucuser character varying(255),
            isnotified boolean,
            isread boolean,
            isslavedata integer,
            mailsent integer DEFAULT 0,
            nooftry integer DEFAULT 0,
            remarks character varying(255),
            sourceservercode character varying(255),
            sourceucuser character varying(255)
        );


        ALTER TABLE public.voicemail_msgs OWNER TO postgres;

        CREATE INDEX voicemail_msgs_idx1 ON public.voicemail_msgs USING btree (created_epoch);

        CREATE INDEX voicemail_msgs_idx2 ON public.voicemail_msgs USING btree (username);

        CREATE INDEX voicemail_msgs_idx3 ON public.voicemail_msgs USING btree (domain);

        CREATE INDEX voicemail_msgs_idx4 ON public.voicemail_msgs USING btree (uuid);

        CREATE INDEX voicemail_msgs_idx5 ON public.voicemail_msgs USING btree (in_folder);

        CREATE INDEX voicemail_msgs_idx6 ON public.voicemail_msgs USING btree (read_flags);

        CREATE INDEX voicemail_msgs_idx7 ON public.voicemail_msgs USING btree (forwarded_by);

        CREATE INDEX voicemail_msgs_idx8 ON public.voicemail_msgs USING btree (read_epoch);

        CREATE INDEX voicemail_msgs_idx9 ON public.voicemail_msgs USING btree (flags);

    END IF;
END $$;