/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userStatusMaster.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.user.userStatusMaster.model.RoleStatusModel;
import com.coraltele.service.user.userStatusMaster.model.UserStatusMasterModel;
import com.coraltele.service.user.userStatusMaster.service.UserStatusMasterService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/userStatusMaster"})
@RestController
public class UserStatusMasterController {
    @Autowired
    UserStatusMasterService userStatusMasterService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody UserStatusMasterModel data, Principal principal) {
        RequestResponse returnValue = this.userStatusMasterService.createStatus(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody UserStatusMasterModel data, Principal principal) {
        RequestResponse returnValue = this.userStatusMasterService.updateById(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.userStatusMasterService.deleteById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/roleStatus"})
    public ResponseEntity<RequestResponse> getStatusByRole(@RequestBody RoleStatusModel data) {
        RequestResponse returnValue = this.userStatusMasterService.getByRole(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllUserStatusByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.userStatusMasterService.getAllUserStatusByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllUserStatus() {
        RequestResponse returnValue = this.userStatusMasterService.getStatusDropdown();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

