/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentPerformanceSummary.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.entity.AgentPerformanceSummary;
import com.coraltele.db.telemetry.main.repository.AgentPerformanceSummaryRepository;
import com.coraltele.db.telemetry.main.specification.AgentPerformanceSummarySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="dailyReportPdf")
public class DailyReportPDF
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(DailyReportPDF.class);
    private static String reportFileName = "Daily Report";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    LocalDateTime currentTime = null;
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    private static int noOfColumns = 0;
    @Autowired
    private AgentPerformanceSummaryRepository repository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static final String NET_LOGIN_TIME_COLUMN = "netLoginTime";
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                DailyReportPDF.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData, principal);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData, Principal principal) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean managerUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            }
            Specification filters = AgentPerformanceSummarySpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List filteredData = sort != null ? this.repository.findAll(filters, sort) : this.repository.findAll(filters);
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            for (String columnName : searchRequestData.getColumnNames()) {
                BaseColor lightBlue = new BaseColor(2, 111, 194);
                PdfPCell cell = columnName.equals("netLoginTime") ? new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE))) : new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            this.getDbData(table, filteredData, searchRequestData.getColumnNames());
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void getDbData(PdfPTable table, List<AgentPerformanceSummary> filteredData, List<String> columnNames1) {
        try {
            BaseColor lightBackground = new BaseColor(230, 230, 230);
            for (int rowIndex = 0; rowIndex < filteredData.size(); ++rowIndex) {
                AgentPerformanceSummary agentPerformance = filteredData.get(rowIndex);
                table.setWidthPercentage(100.0f);
                table.getDefaultCell().setHorizontalAlignment(1);
                table.getDefaultCell().setVerticalAlignment(5);
                table.getDefaultCell().setBorder(0);
                if (rowIndex % 2 == 0) {
                    table.getDefaultCell().setBackgroundColor(BaseColor.WHITE);
                } else {
                    table.getDefaultCell().setBackgroundColor(lightBackground);
                }
                for (String columnName : columnNames1) {
                    Duration totalLoginDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(agentPerformance.getTotalLoginDuration().longValue())));
                    Duration totalUnServiceDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(agentPerformance.getUnServiceDuration().longValue())));
                    Duration totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(agentPerformance.getTotalBreakDuration().longValue())));
                    Duration totalRingDuration = Duration.ofSeconds(this.getDurationOrZero(agentPerformance.getTotalRingDuration()));
                    Duration totalDialedDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(agentPerformance.getTotalDialedDuration().longValue())));
                    Duration netRingDuration = totalRingDuration.plus(totalDialedDuration);
                    switch (columnName) {
                        case "fullname": {
                            table.addCell(this.getCellValue(agentPerformance.getFullname()));
                            break;
                        }
                        case "agentName": {
                            table.addCell(this.getCellValue(agentPerformance.getAgentName()));
                            break;
                        }
                        case "totalOffered": {
                            table.addCell(this.getCellValue(String.valueOf(agentPerformance.getTotalOffered())));
                            break;
                        }
                        case "totalNoAnswered": {
                            table.addCell(this.getCellValue(String.valueOf(agentPerformance.getTotalNoAnswered())));
                            break;
                        }
                        case "totalAnswered": {
                            table.addCell(this.getCellValue(String.valueOf(agentPerformance.getTotalAnswered())));
                            break;
                        }
                        case "totalLoginDuration": {
                            Duration unServiceDuration;
                            Duration netLoginTime;
                            if (agentPerformance.getLogoutTime() != null) {
                                netLoginTime = totalLoginDuration;
                            } else {
                                netLoginTime = Duration.between(agentPerformance.getLoginTime(), LocalDateTime.now());
                                netLoginTime = netLoginTime.plus(totalLoginDuration);
                            }
                            if (agentPerformance.getStartCallTime() == null && agentPerformance.getUnLoginTime() != null) {
                                unServiceDuration = Duration.between(agentPerformance.getUnLoginTime(), LocalDateTime.now());
                                unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                            } else {
                                unServiceDuration = totalUnServiceDuration;
                            }
                            Duration totalTime = netLoginTime.minus(totalBreakDuration).minus(unServiceDuration);
                            table.addCell(DateFormatUtility.findLocalTime((Long)totalTime.getSeconds()));
                            break;
                        }
                        case "totalBreakDuration": {
                            if (agentPerformance.getTotalBreakDuration() != null) {
                                table.addCell(DateFormatUtility.findLocalTime((Long)agentPerformance.getTotalBreakDuration().longValue()));
                                break;
                            }
                            table.addCell("00:00:00");
                            break;
                        }
                        case "netLoginTime": {
                            Duration netLoginTime;
                            if (agentPerformance.getLogoutTime() != null) {
                                netLoginTime = totalLoginDuration;
                            } else {
                                netLoginTime = Duration.between(agentPerformance.getLoginTime(), LocalDateTime.now());
                                netLoginTime = netLoginTime.plus(totalLoginDuration);
                            }
                            table.addCell(DateFormatUtility.findLocalTime((Long)netLoginTime.getSeconds()));
                            break;
                        }
                        case "totalRingDuration": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)netRingDuration.getSeconds())));
                            break;
                        }
                        case "totalTalkDuration": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)agentPerformance.getTotalTalkDuration())));
                            break;
                        }
                        case "averageTalkDuration": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)agentPerformance.getAverageTalkDuration())));
                            break;
                        }
                        case "totalAcwDuration": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)agentPerformance.getTotalAcwDuration().longValue()));
                            break;
                        }
                        case "totalIdleDuration": {
                            Duration unServiceDuration;
                            Duration netLoginTime;
                            if (agentPerformance.getLogoutTime() != null) {
                                netLoginTime = totalLoginDuration;
                            } else {
                                netLoginTime = Duration.between(agentPerformance.getLoginTime(), LocalDateTime.now());
                                netLoginTime = netLoginTime.plus(totalLoginDuration);
                            }
                            Duration totalTalkDuration = Duration.ofSeconds(this.getDurationOrZero(agentPerformance.getTotalTalkDuration()));
                            Duration totalAcwDuration = Duration.ofSeconds(agentPerformance.getTotalAcwDuration().intValue());
                            if (agentPerformance.getStartCallTime() == null && agentPerformance.getUnLoginTime() != null) {
                                unServiceDuration = Duration.between(agentPerformance.getUnLoginTime(), LocalDateTime.now());
                                unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                            } else {
                                unServiceDuration = totalUnServiceDuration;
                            }
                            Duration totalIdleDuration = netLoginTime.minus(netRingDuration).minus(totalAcwDuration).minus(totalTalkDuration).minus(totalBreakDuration).minus(unServiceDuration);
                            table.addCell(DateFormatUtility.findLocalTime((Long)totalIdleDuration.getSeconds()));
                            break;
                        }
                        case "startDate": {
                            if (agentPerformance.getStartDate() != null) {
                                table.addCell(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)agentPerformance.getStartDate()).toString());
                                break;
                            }
                            table.addCell("");
                            break;
                        }
                        case "unServiceDuration": {
                            Duration unServiceDuration;
                            if (agentPerformance.getUnServiceDuration() != null) {
                                if (agentPerformance.getStartCallTime() == null && agentPerformance.getUnLoginTime() != null) {
                                    unServiceDuration = Duration.between(agentPerformance.getUnLoginTime(), LocalDateTime.now());
                                    unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                                } else {
                                    unServiceDuration = totalUnServiceDuration;
                                }
                                table.addCell(DateFormatUtility.findLocalTime((Long)unServiceDuration.getSeconds()));
                                break;
                            }
                            table.addCell("00:00:00");
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private String getCellValue(String value) {
        return value != null && !value.isEmpty() ? value : "";
    }

    private static void leaveEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    static {
        columnMappings.put("netLoginTime", "Total Login Time");
        columnMappings.put("fullname", "Agent Name");
        columnMappings.put("agentName", "AgentId");
        columnMappings.put("totalOffered", "Call Offered");
        columnMappings.put("totalNoAnswered", "No Answer");
        columnMappings.put("totalAnswered", "Answered");
        columnMappings.put("totalLoginDuration", "Net Login Time");
        columnMappings.put("totalBreakDuration", "Break Time");
        columnMappings.put("totalRingDuration", "Ring Time");
        columnMappings.put("totalTalkDuration", "Talk Time");
        columnMappings.put("averageTalkDuration", "Avg Talk Time");
        columnMappings.put("totalAcwDuration", "ACW Time");
        columnMappings.put("totalIdleDuration", "Idle Time");
        columnMappings.put("startDate", "Start Date");
        columnMappings.put("unServiceDuration", "Total Unservice Time");
    }
}

