/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentPerformanceSummary.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.entity.AgentPerformanceSummary;
import com.coraltele.db.telemetry.main.repository.AgentPerformanceSummaryRepository;
import com.coraltele.db.telemetry.main.specification.AgentPerformanceSummarySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="dailyPerformanceSummaryPDF")
public class DailyPerformanceSummaryReportPDF
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(DailyPerformanceSummaryReportPDF.class);
    private static String reportFileName = "Daily Performance Summary Report";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    LocalDateTime currentTime = null;
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    private static int noOfColumns = 0;
    @Autowired
    private AgentPerformanceSummaryRepository repository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static final String NET_LOGIN_TIME_COLUMN = "netLoginTime";
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                DailyPerformanceSummaryReportPDF.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData, principal);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData, Principal principal) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean managerUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            }
            Specification filters = AgentPerformanceSummarySpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List filteredData = sort != null ? this.repository.findAll(filters, sort) : this.repository.findAll(filters);
            ConcurrentHashMap<String, AgentPerformanceSummary> summaryMap = new ConcurrentHashMap<String, AgentPerformanceSummary>();
            HashMap<String, Set> agentDateMap = new HashMap<String, Set>();
            for (AgentPerformanceSummary performance : filteredData) {
                String agentName = performance.getAgentName();
                Long startDate = performance.getStartDate();
                agentDateMap.computeIfAbsent(agentName, k -> new HashSet()).add(startDate);
                int totalConnectedCalls = (performance.getTotalAnswered() != null ? performance.getTotalAnswered() : 0) + (performance.getTotalConnected() != null ? performance.getTotalConnected() : 0);
                long totalTalkSeconds = performance.getTotalTalkDuration() != null ? performance.getTotalTalkDuration() : 0L;
                performance.setTotalConnectedCalls(totalConnectedCalls);
                performance.setTotalTalkDurationInSeconds(totalTalkSeconds);
                summaryMap.merge(performance.getAgentName(), performance, (existing, newEntry) -> {
                    existing.setTotalOffered(Integer.valueOf(existing.getTotalOffered() + newEntry.getTotalOffered()));
                    existing.setTotalDialed(Integer.valueOf(existing.getTotalDialed() + newEntry.getTotalDialed()));
                    existing.setTotalNoAnswered(Integer.valueOf(existing.getTotalNoAnswered() + newEntry.getTotalNoAnswered()));
                    existing.setTotalNotConnected(Integer.valueOf(existing.getTotalNotConnected() + newEntry.getTotalNotConnected()));
                    existing.setTotalAnswered(Integer.valueOf(existing.getTotalAnswered() + newEntry.getTotalAnswered()));
                    existing.setTotalConnected(Integer.valueOf(existing.getTotalConnected() + newEntry.getTotalConnected()));
                    existing.setTotalRingDuration(Long.valueOf(existing.getTotalRingDuration() + newEntry.getTotalRingDuration()));
                    existing.setTotalTalkDuration(Long.valueOf(existing.getTotalTalkDuration() + newEntry.getTotalTalkDuration()));
                    existing.setAverageTalkDuration(Long.valueOf(existing.getAverageTalkDuration() + newEntry.getAverageTalkDuration()));
                    existing.setUnServiceDuration(Integer.valueOf(existing.getUnServiceDuration() + newEntry.getUnServiceDuration()));
                    existing.setRealTotalDialedDuration(Integer.valueOf(existing.getRealTotalDialedDuration() + newEntry.getRealTotalDialedDuration()));
                    existing.setTotalIdleDuration(Integer.valueOf(existing.getTotalIdleDuration() + newEntry.getTotalIdleDuration()));
                    existing.setTotalBreakDuration(Integer.valueOf(existing.getTotalBreakDuration() + newEntry.getTotalBreakDuration()));
                    existing.setTotalLoginDuration(Integer.valueOf(existing.getTotalLoginDuration() + newEntry.getTotalLoginDuration()));
                    existing.setTotalAcwDuration(Integer.valueOf(existing.getTotalAcwDuration() + newEntry.getTotalAcwDuration()));
                    existing.setSecond10(Integer.valueOf(existing.getSecond10() + newEntry.getSecond10()));
                    existing.setSecond20(Integer.valueOf(existing.getSecond20() + newEntry.getSecond20()));
                    existing.setSecond30(Integer.valueOf(existing.getSecond30() + newEntry.getSecond30()));
                    existing.setSecond40(Integer.valueOf(existing.getSecond40() + newEntry.getSecond40()));
                    existing.setSecond50(Integer.valueOf(existing.getSecond50() + newEntry.getSecond50()));
                    existing.setSecond60(Integer.valueOf(existing.getSecond60() + newEntry.getSecond60()));
                    existing.setStartDate(existing.getStartDate() != null ? existing.getStartDate() : newEntry.getStartDate());
                    existing.setTotalConnectedCalls(existing.getTotalConnectedCalls() + newEntry.getTotalConnectedCalls());
                    existing.setTotalTalkDurationInSeconds(existing.getTotalTalkDurationInSeconds() + newEntry.getTotalTalkDurationInSeconds());
                    return existing;
                });
            }
            summaryMap.forEach((agent, summary) -> {
                Set dates = agentDateMap.getOrDefault(agent, Collections.emptySet());
                summary.setNumberOfDays(Integer.valueOf(dates.size()));
            });
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            BaseColor lightBlue = new BaseColor(2, 111, 194);
            for (String columnName : searchRequestData.getColumnNames()) {
                PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            int rowIndex = 0;
            for (AgentPerformanceSummary agentPerformance : summaryMap.values()) {
                if (rowIndex % 2 == 0) {
                    table.getDefaultCell().setBackgroundColor(BaseColor.WHITE);
                } else {
                    table.getDefaultCell().setBackgroundColor(new BaseColor(230, 230, 230));
                }
                for (String columnName : searchRequestData.getColumnNames()) {
                    Duration netRingDuration;
                    Duration totalIdleDuration;
                    Duration unServiceDuration;
                    Duration totalTime;
                    Duration totalLoginDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(agentPerformance.getTotalLoginDuration().longValue())));
                    Duration totalUnServiceDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(agentPerformance.getUnServiceDuration().longValue())));
                    Duration totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(agentPerformance.getTotalBreakDuration().longValue())));
                    Duration totalRingDuration = Duration.ofSeconds(this.getDurationOrZero(agentPerformance.getTotalRingDuration()));
                    Duration realTotalDialedDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(agentPerformance.getRealTotalDialedDuration().longValue())));
                    Duration totalTalkDuration = Duration.ofSeconds(this.getDurationOrZero(agentPerformance.getTotalTalkDuration()));
                    Duration totalAcwDuration = Duration.ofSeconds(agentPerformance.getTotalAcwDuration().intValue());
                    if (agentPerformance.getLoginTime() == null && agentPerformance.getLogoutTime() == null) {
                        totalTime = Duration.ZERO;
                        unServiceDuration = Duration.ZERO;
                        totalLoginDuration = Duration.ZERO;
                        totalIdleDuration = Duration.ZERO;
                        netRingDuration = Duration.ZERO;
                        totalBreakDuration = Duration.ZERO;
                    } else {
                        if (agentPerformance.getLoginTime() != null && agentPerformance.getLogoutTime() == null) {
                            Duration totalLogin = Duration.between(agentPerformance.getLoginTime(), LocalDateTime.now());
                            totalLoginDuration = totalLoginDuration.plus(totalLogin);
                        }
                        netRingDuration = totalRingDuration.plus(realTotalDialedDuration);
                        if (agentPerformance.getStartCallTime() == null && agentPerformance.getUnLoginTime() != null) {
                            unServiceDuration = Duration.between(agentPerformance.getUnLoginTime(), LocalDateTime.now());
                            unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                        } else {
                            unServiceDuration = totalUnServiceDuration;
                        }
                        totalTime = totalLoginDuration.minus(totalBreakDuration).minus(unServiceDuration);
                        if (agentPerformance.getBreakTime() != null && agentPerformance.getLogoutTime() == null) {
                            Duration totalBreakTime = Duration.between(agentPerformance.getBreakTime(), LocalDateTime.now());
                            totalBreakDuration = totalBreakDuration.plus(totalBreakTime);
                        }
                        totalIdleDuration = totalLoginDuration.minus(netRingDuration).minus(totalAcwDuration).minus(totalTalkDuration).minus(totalBreakDuration).minus(unServiceDuration);
                    }
                    switch (columnName) {
                        case "fullname": {
                            table.addCell(this.getCellValue(agentPerformance.getFullname()));
                            break;
                        }
                        case "agentName": {
                            table.addCell(this.getCellValue(agentPerformance.getAgentName()));
                            break;
                        }
                        case "totalOffered": {
                            table.addCell(this.getCellValue(String.valueOf(agentPerformance.getTotalOffered())));
                            break;
                        }
                        case "totalDialed": {
                            table.addCell(this.getCellValue(String.valueOf(agentPerformance.getTotalDialed())));
                            break;
                        }
                        case "totalNoAnswered": {
                            table.addCell(this.getCellValue(String.valueOf(agentPerformance.getTotalNoAnswered() + agentPerformance.getTotalNotConnected())));
                            break;
                        }
                        case "totalAnswered": {
                            table.addCell(this.getCellValue(String.valueOf(agentPerformance.getTotalAnswered() + agentPerformance.getTotalConnected())));
                            break;
                        }
                        case "totalRingDuration": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)netRingDuration.getSeconds())));
                            break;
                        }
                        case "totalTalkDuration": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)agentPerformance.getTotalTalkDuration())));
                            break;
                        }
                        case "averageTalkDuration": {
                            long avgTalkSeconds = 0L;
                            if (agentPerformance.getTotalConnectedCalls() > 0) {
                                avgTalkSeconds = agentPerformance.getTotalTalkDurationInSeconds() / (long)agentPerformance.getTotalConnectedCalls();
                            }
                            Duration averageTalkDuration = Duration.ofSeconds(avgTalkSeconds);
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)averageTalkDuration.getSeconds())));
                            break;
                        }
                        case "totalIdleDuration": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)totalIdleDuration.getSeconds()));
                            break;
                        }
                        case "totalLoginDuration": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)totalTime.getSeconds()));
                            break;
                        }
                        case "totalBreakDuration": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)totalBreakDuration.getSeconds()));
                            break;
                        }
                        case "netLoginTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)totalLoginDuration.getSeconds()));
                            break;
                        }
                        case "second10": {
                            table.addCell(this.getCellValue(agentPerformance.getSecond10().toString()));
                            break;
                        }
                        case "second20": {
                            table.addCell(this.getCellValue(agentPerformance.getSecond20().toString()));
                            break;
                        }
                        case "second30": {
                            table.addCell(this.getCellValue(agentPerformance.getSecond30().toString()));
                            break;
                        }
                        case "second40": {
                            table.addCell(this.getCellValue(agentPerformance.getSecond40().toString()));
                            break;
                        }
                        case "second50": {
                            table.addCell(this.getCellValue(agentPerformance.getSecond50().toString()));
                            break;
                        }
                        case "second60": {
                            table.addCell(this.getCellValue(agentPerformance.getSecond60().toString()));
                            break;
                        }
                        case "totalAcwDuration": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)agentPerformance.getTotalAcwDuration().longValue()));
                            break;
                        }
                        case "startDate": {
                            if (agentPerformance.getStartDate() != null) {
                                table.addCell(this.dateFormatUtility.epochToLocalDateForLocalTimeZone(agentPerformance.getStartDate()).toString());
                                break;
                            }
                            table.addCell("");
                            break;
                        }
                        case "unServiceDuration": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)unServiceDuration.getSeconds()));
                            break;
                        }
                        case "numberOfDays": {
                            table.addCell(this.getCellValue(agentPerformance.getNumberOfDays().toString()));
                            break;
                        }
                    }
                }
                ++rowIndex;
            }
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private String getCellValue(String value) {
        return value != null && !value.isEmpty() ? value : "";
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    static {
        columnMappings.put("netLoginTime", "Total Login Time");
        columnMappings.put("fullname", "Agent Name");
        columnMappings.put("agentName", "AgentId");
        columnMappings.put("totalOffered", "Call Offered");
        columnMappings.put("totalDialed", "Dialed Out");
        columnMappings.put("totalNoAnswered", "No Answer");
        columnMappings.put("totalAnswered", "Answered");
        columnMappings.put("totalRingDuration", "Total Ring Time");
        columnMappings.put("totalTalkDuration", "Total Talk Time");
        columnMappings.put("averageTalkDuration", "Avg Talk Time");
        columnMappings.put("totalIdleDuration", "Total Idle Time");
        columnMappings.put("totalBreakDuration", "Total Break Time");
        columnMappings.put("totalLoginDuration", "Net Login Time");
        columnMappings.put("totalAcwDuration", "ACW Time");
        columnMappings.put("second10", "10 Sec");
        columnMappings.put("second20", "20 Sec");
        columnMappings.put("second30", "30 Sec");
        columnMappings.put("second40", "40 Sec");
        columnMappings.put("second50", "50 Sec");
        columnMappings.put("second60", "60 Sec");
        columnMappings.put("startDate", "Start Date");
        columnMappings.put("unServiceDuration", "Total Unservice Time");
        columnMappings.put("numberOfDays", "Number Of Days");
    }
}

