/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentPerformanceSummary.controller;

import com.coraltele.db.telemetry.main.entity.AgentPerformanceSummary;
import com.coraltele.db.telemetry.main.repository.AgentPerformanceSummaryRepository;
import com.coraltele.db.telemetry.main.specification.AgentPerformanceSummarySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.service.AgentPerformanceSummaryService;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.service.DailyReportPDF;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/agentPerformanceSummary"})
public class AgentPerformanceSummaryController {
    private static final Logger logger = LogManager.getLogger(AgentPerformanceSummaryController.class);
    @Autowired
    DailyReportPDF agentPerformanceSummaryPDF;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    AgentPerformanceSummaryRepository agentPerformanceSummaryRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    AgentPerformanceSummaryService agentPerformanceSummaryService;
    private static final ConcurrentHashMap<String, String> columnMappingsForDailyPerformance = new ConcurrentHashMap();
    private static final String NET_LOGIN_TIME_COLUMN = "netLoginTime";

    @PostMapping(value={"/dailyPerformanceReportDownloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForDailyPerformance(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for daily report--");
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean managerUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            }
            Specification filters = AgentPerformanceSummarySpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List page = sort == null ? this.agentPerformanceSummaryRepository.findAll(filters) : this.agentPerformanceSummaryRepository.findAll(filters, sort);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappingsForDailyPerformance.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                HashMap<String, AgentPerformanceSummary> summarizedDataMap = new HashMap<String, AgentPerformanceSummary>();
                HashMap<String, Set> agentDateMap = new HashMap<String, Set>();
                for (AgentPerformanceSummary item : page) {
                    String agentName = item.getAgentName();
                    Long startDate = item.getStartDate();
                    agentDateMap.computeIfAbsent(agentName, k -> new HashSet()).add(startDate);
                    int totalConnectedCalls = (item.getTotalAnswered() != null ? item.getTotalAnswered() : 0) + (item.getTotalConnected() != null ? item.getTotalConnected() : 0);
                    long totalTalkSeconds = item.getTotalTalkDuration() != null ? item.getTotalTalkDuration() : 0L;
                    item.setTotalConnectedCalls(totalConnectedCalls);
                    item.setTotalTalkDurationInSeconds(totalTalkSeconds);
                    summarizedDataMap.merge(agentName, item, (existing, newItem) -> {
                        existing.setTotalAnswered(Integer.valueOf(existing.getTotalAnswered() + newItem.getTotalAnswered()));
                        existing.setTotalConnected(Integer.valueOf(existing.getTotalConnected() + newItem.getTotalConnected()));
                        existing.setTotalNoAnswered(Integer.valueOf(existing.getTotalNoAnswered() + newItem.getTotalNoAnswered()));
                        existing.setTotalNotConnected(Integer.valueOf(existing.getTotalNotConnected() + newItem.getTotalNotConnected()));
                        existing.setTotalOffered(Integer.valueOf(existing.getTotalOffered() + newItem.getTotalOffered()));
                        existing.setTotalDialed(Integer.valueOf(existing.getTotalDialed() + newItem.getTotalDialed()));
                        existing.setSecond10(Integer.valueOf(existing.getSecond10() + newItem.getSecond10()));
                        existing.setSecond20(Integer.valueOf(existing.getSecond20() + newItem.getSecond20()));
                        existing.setSecond30(Integer.valueOf(existing.getSecond30() + newItem.getSecond30()));
                        existing.setSecond40(Integer.valueOf(existing.getSecond40() + newItem.getSecond40()));
                        existing.setSecond50(Integer.valueOf(existing.getSecond50() + newItem.getSecond50()));
                        existing.setSecond60(Integer.valueOf(existing.getSecond60() + newItem.getSecond60()));
                        existing.setTotalTalkDuration(Long.valueOf(existing.getTotalTalkDuration() + newItem.getTotalTalkDuration()));
                        existing.setTotalAcwDuration(Integer.valueOf(existing.getTotalAcwDuration() + newItem.getTotalAcwDuration()));
                        existing.setTotalLoginDuration(Integer.valueOf(existing.getTotalLoginDuration() + newItem.getTotalLoginDuration()));
                        existing.setUnServiceDuration(Integer.valueOf(existing.getUnServiceDuration() + newItem.getUnServiceDuration()));
                        existing.setTotalBreakDuration(Integer.valueOf(existing.getTotalBreakDuration() + newItem.getTotalBreakDuration()));
                        existing.setTotalRingDuration(Long.valueOf(existing.getTotalRingDuration() + newItem.getTotalRingDuration()));
                        existing.setRealTotalDialedDuration(Integer.valueOf(existing.getRealTotalDialedDuration() + newItem.getRealTotalDialedDuration()));
                        existing.setTotalConnectedCalls(existing.getTotalConnectedCalls() + newItem.getTotalConnectedCalls());
                        existing.setTotalTalkDurationInSeconds(existing.getTotalTalkDurationInSeconds() + newItem.getTotalTalkDurationInSeconds());
                        return existing;
                    });
                }
                summarizedDataMap.forEach((agent, summary) -> {
                    Set dates = agentDateMap.getOrDefault(agent, Collections.emptySet());
                    summary.setNumberOfDays(Integer.valueOf(dates.size()));
                });
                for (AgentPerformanceSummary item : summarizedDataMap.values()) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValues(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for daily report cdr", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading daily report CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValues(AgentPerformanceSummary item, String columnName) {
        Duration totalIdleDuration;
        Duration totalTime;
        Duration netRingDuration;
        Duration unServiceDuration;
        Duration totalTalkDuration = Duration.ofSeconds(this.getDurationOrZero(item.getTotalTalkDuration()));
        Duration totalAcwDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalAcwDuration().longValue())));
        Duration totalLoginDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalLoginDuration().longValue())));
        Duration totalUnServiceDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getUnServiceDuration().longValue())));
        Duration totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalBreakDuration().longValue())));
        Duration totalRingDuration = Duration.ofSeconds(this.getDurationOrZero(item.getTotalRingDuration()));
        Duration realTotalDialedDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getRealTotalDialedDuration().longValue())));
        if (item.getLoginTime() == null && item.getLogoutTime() == null) {
            totalLoginDuration = Duration.ZERO;
            unServiceDuration = Duration.ZERO;
            totalBreakDuration = Duration.ZERO;
            netRingDuration = Duration.ZERO;
            totalTime = Duration.ZERO;
            totalIdleDuration = Duration.ZERO;
        } else {
            if (item.getLoginTime() != null && item.getLogoutTime() == null) {
                Duration totalLogin = Duration.between(item.getLoginTime(), LocalDateTime.now());
                totalLoginDuration = totalLoginDuration.plus(totalLogin);
            }
            netRingDuration = totalRingDuration.plus(realTotalDialedDuration);
            if (item.getStartCallTime() == null && item.getUnLoginTime() != null) {
                unServiceDuration = Duration.between(item.getUnLoginTime(), LocalDateTime.now());
                unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
            } else {
                unServiceDuration = totalUnServiceDuration;
            }
            totalTime = totalLoginDuration.minus(totalBreakDuration).minus(unServiceDuration);
            if (item.getBreakTime() != null && item.getLogoutTime() == null) {
                Duration totalBreakTime = Duration.between(item.getBreakTime(), LocalDateTime.now());
                totalBreakDuration = totalBreakDuration.plus(totalBreakTime);
            }
            totalIdleDuration = totalLoginDuration.minus(netRingDuration).minus(totalAcwDuration).minus(totalTalkDuration).minus(totalBreakDuration).minus(unServiceDuration);
        }
        switch (columnName) {
            case "fullname": {
                return this.checkNull((Object)item.getFullname());
            }
            case "agentName": {
                return this.checkNull((Object)item.getAgentName());
            }
            case "totalOffered": {
                return this.checkNull((Object)item.getTotalOffered());
            }
            case "totalDialed": {
                return this.checkNull((Object)item.getTotalDialed());
            }
            case "totalNoAnswered": {
                return this.checkNull((Object)(item.getTotalNoAnswered() + item.getTotalNotConnected()));
            }
            case "totalAnswered": {
                return this.checkNull((Object)(item.getTotalAnswered() + item.getTotalConnected()));
            }
            case "totalRingDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)netRingDuration.getSeconds()));
            }
            case "totalLoginDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalTime.getSeconds()));
            }
            case "totalBreakDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalBreakDuration.getSeconds()));
            }
            case "netLoginTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalLoginDuration.getSeconds()));
            }
            case "totalTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalTalkDuration.getSeconds()));
            }
            case "averageTalkDuration": {
                long avgTalkSeconds = 0L;
                if (item.getTotalConnectedCalls() > 0) {
                    avgTalkSeconds = item.getTotalTalkDurationInSeconds() / (long)item.getTotalConnectedCalls();
                }
                Duration averageTalkDuration = Duration.ofSeconds(avgTalkSeconds);
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)averageTalkDuration.getSeconds()));
            }
            case "totalIdleDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalIdleDuration.getSeconds()));
            }
            case "second10": {
                return this.checkNull((Object)item.getSecond10());
            }
            case "second20": {
                return this.checkNull((Object)item.getSecond20());
            }
            case "second30": {
                return this.checkNull((Object)item.getSecond30());
            }
            case "second40": {
                return this.checkNull((Object)item.getSecond40());
            }
            case "second50": {
                return this.checkNull((Object)item.getSecond50());
            }
            case "second60": {
                return this.checkNull((Object)item.getSecond60());
            }
            case "startDate": {
                return this.dateFormatUtility.epochToLocalDateForLocalTimeZone(item.getStartDate());
            }
            case "totalAcwDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalAcwDuration.getSeconds()));
            }
            case "unServiceDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)unServiceDuration.getSeconds()));
            }
            case "numberOfDays": {
                return this.checkNull((Object)item.getNumberOfDays());
            }
        }
        return null;
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/dailyPerformanceReportList"})
    public ResponseEntity<RequestResponse> getAllByFilterForDailyPerformanceOfSummary(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.agentPerformanceSummaryService.getAllByFilterForDailyPerformanceOfSummary(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappingsForDailyPerformance.put(NET_LOGIN_TIME_COLUMN, "Total Login Time");
        columnMappingsForDailyPerformance.put("fullname", "Agent Name");
        columnMappingsForDailyPerformance.put("agentName", "AgentId");
        columnMappingsForDailyPerformance.put("totalOffered", "Call Offered");
        columnMappingsForDailyPerformance.put("totalDialed", "Dialed Out");
        columnMappingsForDailyPerformance.put("totalNoAnswered", "No Answer");
        columnMappingsForDailyPerformance.put("totalAnswered", "Answered");
        columnMappingsForDailyPerformance.put("totalRingDuration", "Total Ring Time");
        columnMappingsForDailyPerformance.put("totalTalkDuration", "Total Talk Time");
        columnMappingsForDailyPerformance.put("averageTalkDuration", "Avg Talk Time");
        columnMappingsForDailyPerformance.put("totalIdleDuration", "Total Idle Time");
        columnMappingsForDailyPerformance.put("totalBreakDuration", "Total Break Time");
        columnMappingsForDailyPerformance.put("totalLoginDuration", "Net Login Time");
        columnMappingsForDailyPerformance.put("totalAcwDuration", "ACW Time");
        columnMappingsForDailyPerformance.put("second10", "10 Sec");
        columnMappingsForDailyPerformance.put("second20", "20 Sec");
        columnMappingsForDailyPerformance.put("second30", "30 Sec");
        columnMappingsForDailyPerformance.put("second40", "40 Sec");
        columnMappingsForDailyPerformance.put("second50", "50 Sec");
        columnMappingsForDailyPerformance.put("second60", "60 Sec");
        columnMappingsForDailyPerformance.put("startDate", "Start Date");
        columnMappingsForDailyPerformance.put("unServiceDuration", "Total Unservice Time");
        columnMappingsForDailyPerformance.put("numberOfDays", "Number Of Days");
    }
}

