/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.imsi.service;

import com.coraltele.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.db.telemetry.coralnms.specification.IMSISpecification;
import com.coraltele.db.telemetry.main.entity.UserZone;
import com.coraltele.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.db.telephony.billing.entity.Department;
import com.coraltele.db.telephony.billing.repository.DepartmentRepository;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.coralnms.imsi.model.DeviceInformationModel;
import com.coraltele.service.telemetry.coralnms.imsi.model.IMSIModel;
import com.coraltele.service.telemetry.coralnms.imsi.model.UserDetailModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class IMSIService {
    private static final Logger logger = LogManager.getLogger(IMSIService.class);
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    UserZoneRepository userZoneRepository;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    DepartmentRepository departmentRepository;

    public RequestResponse createData(IMSIModel data) {
        logger.debug("create new IMSI : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            IMSI imsi = new IMSI();
            Optional extensionNumber = this.imsiRepository.findByExtensionNumber(data.getExtensionNumber());
            if (extensionNumber.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Extension Number is Already Present");
                returnValue.setMessageDetail("Please Select Different Extension Number");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            Optional imsiNumber = this.imsiRepository.findByImsINumber(data.getImsINumber());
            if (imsiNumber.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("IMSI Number is Already Present");
                returnValue.setMessageDetail("Please Enter Different IMSI Number");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            Optional scaDaAsset = this.scadaAssetRepository.findById(data.getAsset());
            Optional extension = this.extensionsRepository.findByExtension(data.getExtensionNumber());
            ((Extension)extension.get()).setZone(data.getZone());
            ((Extension)extension.get()).setDepartment(data.getDepartment());
            ((Extension)extension.get()).setName(data.getExtensionName());
            imsi.setAsset((SCADAAsset)scaDaAsset.get());
            imsi.setBloodGroup(this.getOrDefault(data.getBloodGroup()));
            imsi.setCellId(this.getOrDefault(data.getCellId()));
            if (data.getConnected() != null) {
                imsi.setConnected(data.getConnected());
            } else {
                imsi.setConnected(Boolean.valueOf(false));
            }
            imsi.setEmergencyStatus(this.getOrDefault(data.getEmergencyStatus()));
            imsi.setExtensionName(this.getOrDefault(data.getExtensionName()));
            imsi.setExtensionNumber(data.getExtensionNumber());
            imsi.setGeoX(this.getOrDefault(data.getGeoX()));
            imsi.setGeoY(this.getOrDefault(data.getGeoY()));
            imsi.setHaddredd(this.getOrDefault(data.getHaddredd()));
            imsi.setImsINumber(data.getImsINumber());
            imsi.setMedDetails(this.getOrDefault(data.getMedDetails()));
            imsi.setName(this.getOrDefault(data.getName()));
            imsi.setOaddress(this.getOrDefault(data.getOaddress()));
            imsi.setPecName(this.getOrDefault(data.getPecName()));
            imsi.setPecNumber(this.getOrDefault(data.getPecNumber()));
            imsi.setSecName(this.getOrDefault(data.getSecName()));
            imsi.setSecNumber(this.getOrDefault(data.getSecNumber()));
            imsi.setZone(this.getOrDefault(data.getZone()));
            imsi.setDepartment(this.getOrDefault(data.getDepartment()));
            imsi.setDeviceType(data.getDeviceType());
            imsi.setDeviceId(data.getDeviceId());
            imsi.setBatteryPercentage(data.getBatteryPercentage());
            imsi.setRsRpSim1(data.getRsRpSim1());
            imsi.setRsRpSim2(data.getRsRpSim2());
            imsi.setDirection(data.getDirection());
            if (data.getIsDataUpdate() != null && data.getIsDataUpdate().booleanValue()) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String jsonData = objectMapper.writeValueAsString((Object)this.getJsonData(data));
                    imsi.setData(jsonData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                }
            }
            this.imsiRepository.save((Object)imsi);
            this.extensionsRepository.save(extension.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("IMSI created successfully");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create IMSI");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
            return returnValue;
        }
    }

    public RequestResponse updateById(IMSIModel data) {
        logger.debug("Update IMSI {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional extensionNumber = this.imsiRepository.findByExtensionNumber(data.getExtensionNumber());
        Optional scaDaAsset = this.scadaAssetRepository.findById(data.getAsset());
        if (!extensionNumber.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("IMSI not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Optional extension = this.extensionsRepository.findByExtension(data.getExtensionNumber());
        ((Extension)extension.get()).setZone(data.getZone());
        ((Extension)extension.get()).setDepartment(data.getDepartment());
        ((Extension)extension.get()).setName(data.getExtensionName());
        ((IMSI)extensionNumber.get()).setAsset((SCADAAsset)scaDaAsset.get());
        ((IMSI)extensionNumber.get()).setBloodGroup(this.getOrDefault(data.getBloodGroup()));
        ((IMSI)extensionNumber.get()).setCellId(this.getOrDefault(data.getCellId()));
        ((IMSI)extensionNumber.get()).setConnected(data.getConnected());
        ((IMSI)extensionNumber.get()).setEmergencyStatus(this.getOrDefault(data.getEmergencyStatus()));
        ((IMSI)extensionNumber.get()).setExtensionName(this.getOrDefault(data.getExtensionName()));
        ((IMSI)extensionNumber.get()).setGeoX(this.getOrDefault(data.getGeoX()));
        ((IMSI)extensionNumber.get()).setGeoY(this.getOrDefault(data.getGeoY()));
        ((IMSI)extensionNumber.get()).setHaddredd(this.getOrDefault(data.getHaddredd()));
        ((IMSI)extensionNumber.get()).setMedDetails(this.getOrDefault(data.getMedDetails()));
        ((IMSI)extensionNumber.get()).setName(this.getOrDefault(data.getName()));
        ((IMSI)extensionNumber.get()).setOaddress(this.getOrDefault(data.getOaddress()));
        ((IMSI)extensionNumber.get()).setPecName(this.getOrDefault(data.getPecName()));
        ((IMSI)extensionNumber.get()).setPecNumber(this.getOrDefault(data.getPecNumber()));
        ((IMSI)extensionNumber.get()).setSecName(this.getOrDefault(data.getSecName()));
        ((IMSI)extensionNumber.get()).setSecNumber(this.getOrDefault(data.getSecNumber()));
        ((IMSI)extensionNumber.get()).setZone(this.getOrDefault(data.getZone()));
        ((IMSI)extensionNumber.get()).setDepartment(this.getOrDefault(data.getDepartment()));
        ((IMSI)extensionNumber.get()).setDirection(this.getOrDefault(data.getDirection()));
        ((IMSI)extensionNumber.get()).setDeviceType(this.getOrDefault(data.getDeviceType()));
        ((IMSI)extensionNumber.get()).setDeviceId(data.getDeviceId());
        ((IMSI)extensionNumber.get()).setBatteryPercentage(data.getBatteryPercentage());
        ((IMSI)extensionNumber.get()).setRsRpSim1(data.getRsRpSim1());
        ((IMSI)extensionNumber.get()).setRsRpSim2(data.getRsRpSim2());
        if (data.getIsDataUpdate() != null && data.getIsDataUpdate().booleanValue()) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String jsonData = objectMapper.writeValueAsString((Object)this.getJsonData(data));
                ((IMSI)extensionNumber.get()).setData(jsonData);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
        } else {
            ((IMSI)extensionNumber.get()).setData("");
        }
        this.imsiRepository.save(extensionNumber.get());
        this.extensionsRepository.save(extension.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("IMSI Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteIMSIByExtensionNumber(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String ids : data.getStringId()) {
            Optional imsi = this.imsiRepository.findByExtensionNumber(ids.toString());
            Optional extension = this.extensionsRepository.findByExtension(ids.toString());
            if (imsi.isPresent()) {
                if (extension.isPresent()) {
                    Extension ext = (Extension)extension.get();
                    ext.setZone("");
                    this.extensionsRepository.save((Object)ext);
                }
                addValue.add(imsi.get());
                this.imsiRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllIMSIByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = IMSISpecification.generateFilters((SearchRequest)searchRequestData, (boolean)false);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.imsiRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.imsiRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<IMSIModel> entityToModelConversion(List<IMSI> imsi) {
        ArrayList<IMSIModel> addValue = new ArrayList<IMSIModel>();
        for (IMSI row : imsi) {
            IMSIModel data = new IMSIModel();
            data.setAsset(row.getAsset().getId());
            data.setAssetName(row.getAsset().getNodeName());
            data.setBloodGroup(row.getBloodGroup());
            data.setCellId(row.getCellId());
            data.setConnected(row.getConnected());
            data.setEmergencyStatus(row.getEmergencyStatus());
            data.setExtensionName(row.getExtensionName());
            data.setExtensionNumber(row.getExtensionNumber());
            data.setGeoX(row.getGeoX());
            data.setGeoY(row.getGeoY());
            data.setHaddredd(row.getHaddredd());
            data.setImsINumber(row.getImsINumber());
            data.setMedDetails(row.getMedDetails());
            data.setName(row.getName());
            data.setOaddress(row.getOaddress());
            data.setPecName(row.getPecName());
            data.setPecNumber(row.getPecNumber());
            data.setSecName(row.getSecName());
            data.setSecNumber(row.getSecNumber());
            data.setCreatedOn(row.getCreatedOn());
            data.setDirection(row.getDirection());
            data.setDeviceType(row.getDeviceType());
            data.setDeviceId(row.getDeviceId());
            data.setBatteryPercentage(row.getBatteryPercentage());
            data.setRsRpSim1(row.getRsRpSim1());
            data.setRsRpSim2(row.getRsRpSim2());
            if (row.getZone() == null || row.getZone().equals("")) {
                data.setZone("");
            } else {
                Optional userZone = this.userZoneRepository.findByDescription(row.getZone());
                if (userZone.isPresent()) {
                    data.setZone(((UserZone)userZone.get()).getDescription());
                } else {
                    data.setZone("");
                }
            }
            if (row.getDepartment() == null || row.getDepartment().equals("")) {
                data.setDepartment("");
            } else {
                Optional department = this.departmentRepository.findByDescription(row.getDepartment());
                data.setDepartment(((Department)department.get()).getDescription());
            }
            if (row.getData() != null && !row.getData().isEmpty()) {
                data.setData(row.getData());
            }
            addValue.add(data);
        }
        return addValue;
    }

    private String getOrDefault(String value) {
        return value != null ? value : "";
    }

    public RequestResponse getAllEmergencyIMSI(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = IMSISpecification.generateFilters((SearchRequest)searchRequestData, (boolean)true);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.imsiRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.imsiRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public UserDetailModel getJsonData(IMSIModel data) {
        UserDetailModel userDetails = new UserDetailModel();
        userDetails.setName(this.getOrDefault(data.getName()));
        userDetails.setBloodGroup(this.getOrDefault(data.getBloodGroup()));
        userDetails.setHomeAddress(this.getOrDefault(data.getHaddredd()));
        userDetails.setOfficeAddress(this.getOrDefault(data.getOaddress()));
        userDetails.setPrimaryEmergencyContactName(this.getOrDefault(data.getPecName()));
        userDetails.setPrimaryEmergencyContactNumber(this.getOrDefault(data.getPecNumber()));
        userDetails.setSecondaryEmergencyContactName(this.getOrDefault(data.getSecName()));
        userDetails.setSecondaryEmergencyContactNumber(this.getOrDefault(data.getSecNumber()));
        userDetails.setMedicalDetails(this.getOrDefault(data.getMedDetails()));
        return userDetails;
    }

    public IMSI getImSiByExtension(String extension) {
        try {
            return this.imsiRepository.findByExtensionNumber(extension).orElse(null);
        }
        catch (Exception e) {
            logger.error("Error fetching IMSI by extension: " + extension, (Throwable)e);
            return null;
        }
    }

    public void updateDeviceUser(DeviceInformationModel data) {
        logger.info("Device Information for imsi:{}", (Object)data);
        Optional imSiData = this.imsiRepository.findByDeviceId(data.getDeviceId());
        if (imSiData.isPresent()) {
            if (data.getDeviceId() != null) {
                ((IMSI)imSiData.get()).setDeviceId(data.getDeviceId());
            }
            if (data.getBatteryPercentage() != null) {
                ((IMSI)imSiData.get()).setBatteryPercentage(data.getBatteryPercentage());
            }
            if (data.getRsrpData() != null) {
                if (data.getRsrpData().getSim1() != null) {
                    ((IMSI)imSiData.get()).setRsRpSim1(data.getRsrpData().getSim1());
                }
                if (data.getRsrpData().getSim2() != null) {
                    ((IMSI)imSiData.get()).setRsRpSim2(data.getRsrpData().getSim2());
                }
            }
            if (data.getUsername() != null) {
                ((IMSI)imSiData.get()).setUsername(data.getUsername());
            }
            this.imsiRepository.save(imSiData.get());
        }
    }
}

