/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.syncData.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.syncData.service.PostgresBackupService;
import com.coraltele.service.syncData.service.PostgresRestoreService;
import com.coraltele.service.syncData.service.RestoreByClusterService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v2/sync"})
public class SyncDataController {
    private static final Logger logger = LogManager.getLogger(SyncDataController.class);
    @Autowired
    private PostgresBackupService backupService;
    @Autowired
    private PostgresRestoreService restoreService;
    @Autowired
    RestoreByClusterService restoreByClusterService;

    @PostMapping(value={"/sync-data"})
    public ResponseEntity<RequestResponse> syncData() {
        RequestResponse returnValue = new RequestResponse();
        try {
            logger.info("Starting backup process.");
            returnValue = this.backupService.performBackup();
            if (!Constants.Error.OK.equals((Object)returnValue.getStatus())) {
                logger.error("Backup failed - " + returnValue.getMessage());
                return new ResponseEntity((Object)returnValue, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            long backupVersion = (Long)returnValue.getData();
            logger.info("Backup successful. Proceeding to restore.");
            returnValue = this.restoreByClusterService.restoreToAllServers(backupVersion);
            if (Constants.Error.OK.equals((Object)returnValue.getStatus())) {
                logger.info("Restore successful - " + returnValue.getMessage());
                return ResponseEntity.ok((Object)returnValue);
            }
            logger.error("Restore failed - " + returnValue.getMessage());
            return new ResponseEntity((Object)returnValue, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception ex) {
            logger.error("Exception occurred during sync - " + ex.getMessage(), (Throwable)ex);
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Exception occurred during backup/restore process.");
            returnValue.setMessageDetail(ex.getMessage());
            return new ResponseEntity((Object)returnValue, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/getList/{ip}"})
    public ResponseEntity<RequestResponse> getLatestBackups(@PathVariable String ip) {
        RequestResponse returnValue = this.backupService.getList(ip);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/backupList/{ip}"})
    public ResponseEntity<RequestResponse> getBackupList(@PathVariable String ip) {
        RequestResponse returnValue = this.backupService.getLastFiveBackupVersionList(ip);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/backupRestore/{versionId}/{ip}"})
    public ResponseEntity<RequestResponse> restoreSelectedVersion(@PathVariable long versionId, @PathVariable String ip) {
        RequestResponse returnValue = this.restoreService.restoreToSelectedServer(versionId, ip);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/blockDbConnection/{dbName}"})
    public ResponseEntity<RequestResponse> blockDbConnection(@PathVariable(value="dbName") String dbName) {
        RequestResponse returnValue = this.restoreByClusterService.blockNewConnections(dbName);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/unBlockDbConnection/{dbName}"})
    public ResponseEntity<RequestResponse> unBlockDbConnection(@PathVariable(value="dbName") String dbName) {
        RequestResponse returnValue = this.restoreByClusterService.unBlockDbConnections(dbName);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/saveFile"})
    public ResponseEntity<RequestResponse> saveFile(@RequestParam(value="file") MultipartFile file, @RequestParam String path) {
        RequestResponse returnValue = this.restoreByClusterService.saveFile(file, path);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/createDropDb"})
    public ResponseEntity<RequestResponse> createDropDb(@RequestParam String dbName, @RequestParam boolean isPartial, @RequestParam String localBackupPath, @RequestParam(required=false) List<String> tables) {
        RequestResponse returnValue = this.restoreByClusterService.dropCreateDbCmd(dbName, isPartial, tables, localBackupPath);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

