/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.videoRecording.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.VideoRecording;
import com.coraltele.db.telephony.pbx.repository.VideoRecordingRepository;
import com.coraltele.db.telephony.pbx.specification.VideoRecordingsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.videoRecording.model.MultipleVideoRecordings;
import com.coraltele.service.pbx.videoRecording.model.VideoRecordingMultipleUpdates;
import com.coraltele.service.pbx.videoRecording.model.VideoRecordingsModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class VideoRecordingService {
    private static final Logger logger = LogManager.getLogger(VideoRecordingService.class);
    @Autowired
    private VideoRecordingRepository videoRecordingsRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;

    public RequestResponse createVideoRecordings(MultipleVideoRecordings records) {
        logger.debug("create new videoRecording : {} ", (Object)records);
        RequestResponse returnValue = new RequestResponse();
        try {
            for (VideoRecordingsModel row : records.getVideoRecordingsModel()) {
                VideoRecording videoRecordings = new VideoRecording();
                videoRecordings.setAccountCode(row.getAccountCode());
                videoRecordings.setAnswerStamp(LocalDateTime.now());
                videoRecordings.setBillSec(row.getBillSec());
                videoRecordings.setBLegUuid(row.getBLegUuid());
                videoRecordings.setBridgeUuid(row.getBridgeUuid());
                videoRecordings.setCallerIdName(row.getCallerIdName());
                videoRecordings.setCallerIdNumber(row.getCallerIdNumber());
                videoRecordings.setCcRecordFilename(row.getCcRecordFilename());
                videoRecordings.setCreatedOn(LocalDateTime.now());
                videoRecordings.setDestinationName(row.getDestinationName());
                videoRecordings.setDestinationNumber(row.getDestinationNumber());
                videoRecordings.setDirection(row.getDirection());
                videoRecordings.setEndStamp(row.getEndStamp());
                videoRecordings.setHangupCause(row.getHangupCause());
                videoRecordings.setStartStamp(LocalDateTime.now());
                videoRecordings.setUserRemarks(row.getUserRemarks());
                videoRecordings.setUuid(row.getUuid());
                this.videoRecordingsRepository.save((Object)videoRecordings);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("videoRecording created");
            returnValue.setMessageDetail("videoRecordings created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (DataIntegrityViolationException ex) {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("videoRecording created");
            returnValue.setMessageDetail("videoRecordings created successfully");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Not created");
            returnValue.setMessageDetail("videoRecordings not created!!");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteMultipleRecords(List<Integer> ids) {
        logger.debug("Delete Recordings {}", ids);
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer id : ids) {
            Optional videoRecordings = this.videoRecordingsRepository.findById((Object)id);
            if (!videoRecordings.isPresent()) continue;
            addValue.add(videoRecordings.get());
        }
        this.videoRecordingsRepository.deleteAll(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("records has been deleted");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateAll(HttpServletRequest request, VideoRecordingMultipleUpdates data, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (Integer id : data.getIds()) {
            Optional videoRecordings = this.videoRecordingsRepository.findById((Object)id);
            if (!videoRecordings.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("videoRecordings not found");
                logger.info(returnValue.getMessage());
                continue;
            }
            this.saveData(request, (VideoRecording)videoRecordings.get(), authentication);
            if (data.getAccountCode() != null) {
                ((VideoRecording)videoRecordings.get()).setAccountCode(data.getAccountCode());
            }
            if (data.getAnswerStamp() != null) {
                ((VideoRecording)videoRecordings.get()).setAnswerStamp(data.getAnswerStamp());
            }
            if (data.getBillSec() != 0) {
                ((VideoRecording)videoRecordings.get()).setBillSec(data.getBillSec());
            }
            if (data.getBLegUuid() != null) {
                ((VideoRecording)videoRecordings.get()).setBLegUuid(data.getBLegUuid());
            }
            if (data.getBridgeUuid() != null) {
                ((VideoRecording)videoRecordings.get()).setBridgeUuid(data.getBridgeUuid());
            }
            if (data.getCallerIdName() != null) {
                ((VideoRecording)videoRecordings.get()).setCallerIdName(data.getCallerIdName());
            }
            if (data.getCallerIdNumber() != null) {
                ((VideoRecording)videoRecordings.get()).setCallerIdNumber(data.getCallerIdNumber());
            }
            if (data.getCcRecordFilename() != null) {
                ((VideoRecording)videoRecordings.get()).setCcRecordFilename(data.getCcRecordFilename());
            }
            if (data.getCreatedOn() != null) {
                ((VideoRecording)videoRecordings.get()).setCreatedOn(data.getCreatedOn());
            }
            if (data.getDestinationName() != null) {
                ((VideoRecording)videoRecordings.get()).setDestinationName(data.getDestinationName());
            }
            if (data.getDestinationNumber() != null) {
                ((VideoRecording)videoRecordings.get()).setDestinationNumber(data.getDestinationNumber());
            }
            if (data.getDirection() != null) {
                ((VideoRecording)videoRecordings.get()).setDirection(data.getDirection());
            }
            if (data.getEndStamp() != null) {
                ((VideoRecording)videoRecordings.get()).setEndStamp(data.getEndStamp());
            }
            if (data.getHangupCause() != null) {
                ((VideoRecording)videoRecordings.get()).setHangupCause(data.getHangupCause());
            }
            if (data.getStartStamp() != null) {
                ((VideoRecording)videoRecordings.get()).setStartStamp(data.getStartStamp());
            }
            if (data.getUserRemarks() != null) {
                ((VideoRecording)videoRecordings.get()).setUserRemarks(data.getUserRemarks());
            }
            if (data.getUuid() != null) {
                ((VideoRecording)videoRecordings.get()).setUuid(data.getUuid());
            }
            this.videoRecordingsRepository.save(videoRecordings.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("videoRecordings Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getFilterVideoData(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = VideoRecordingsSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.videoRecordingsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.videoRecordingsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void saveData(HttpServletRequest request, VideoRecording videoRecording, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        try {
            if (videoRecording.getId() != null && this.videoRecordingsRepository.findById((Object)videoRecording.getId()).isPresent()) {
                Optional oldData = this.videoRecordingsRepository.findById((Object)videoRecording.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry set : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(set.getKey())) continue;
                        inputValue.setOldValue(set.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("videorecordings");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException e) {
            logger.info((Object)e);
        }
    }

    public String findFile(Integer id) {
        return ((VideoRecording)this.videoRecordingsRepository.findById((Object)id).get()).getCcRecordFilename();
    }
}

