/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taskType.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.taskType.model.TaskTypeModel;
import com.coraltele.service.pbx.taskType.service.TaskTypeService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/taskType"})
public class TaskTypeController {
    private static final Logger logger = LogManager.getLogger(TaskTypeController.class);
    @Autowired
    TaskTypeService taskTypeService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createTaskType(@RequestBody TaskTypeModel taskTypeModel, Principal principal) {
        RequestResponse returnValue = this.taskTypeService.createTaskType(taskTypeModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllTaskType() {
        RequestResponse returnValue = this.taskTypeService.getAllTaskType();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateTaskType(@RequestBody TaskTypeModel taskTypeModel, Principal principal) {
        RequestResponse returnValue = this.taskTypeService.updateTaskType(taskTypeModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteTaskType(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.taskTypeService.deleteTaskType(id);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getFilterTaskTypes(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.taskTypeService.getFilterTaskTypes(searchRequest);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

