/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.formJson.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.formJson.model.DynamicFormModel;
import com.coraltele.service.pbx.formJson.model.JsonFormModel;
import com.coraltele.service.pbx.formJson.service.FormJsonService;
import java.io.IOException;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/form"})
@RestController
public class FormJsonController {
    private static final Logger logger = LogManager.getLogger(FormJsonController.class);
    @Autowired
    FormJsonService formJsonService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createForm(@RequestBody JsonFormModel data, Principal principal) throws IOException {
        RequestResponse returnValue = this.formJsonService.createJsonForm(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateMeeting(@RequestBody JsonFormModel data, Principal authentication) throws IOException {
        RequestResponse returnValue = this.formJsonService.updateJsonForm(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteMeeting(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.formJsonService.deleteFormData(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/{formCode}"})
    public ResponseEntity<RequestResponse> getFormData(@PathVariable(value="formCode") String formCode) throws IOException {
        RequestResponse returnValue = this.formJsonService.getFormData(formCode);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.formJsonService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getList() {
        RequestResponse returnValue = this.formJsonService.getList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{formCode}"})
    public ResponseEntity<RequestResponse> createFile(@PathVariable(value="formCode") String formCode, @RequestBody DynamicFormModel data) throws Exception {
        RequestResponse returnValue = this.formJsonService.createJsonFile(formCode, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

