/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extension.service;

import com.coraltele.db.telephony.pbx.entity.AuthExtension;
import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.AuthExtensionRepository;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.extension.model.ExtensionNameUpdateModel;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AuthExtensionService {
    private static final Logger logger = LogManager.getLogger(AuthExtensionService.class);
    @Autowired
    AuthExtensionRepository authExtensionRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    private ExtensionsRepository extensionsRepository;

    public String getExtName(String contactNo) {
        Optional data = this.authExtensionRepository.findByExtension(contactNo);
        if (data.isPresent()) {
            return ((AuthExtension)data.get()).getName();
        }
        return "";
    }

    public String getExtensionOfUser(String username) {
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            String contactNo = ((User)user.get()).getContactNo();
            if (contactNo != null) {
                Optional data = this.authExtensionRepository.findByExtension(contactNo);
                if (data.isPresent() && contactNo.equals(((AuthExtension)data.get()).getExtension())) {
                    return contactNo;
                }
                Optional extension = this.authExtensionRepository.findByAssignedUserAndExtensionType(username, "phone");
                if (extension.isPresent()) {
                    return ((AuthExtension)extension.get()).getExtension();
                }
                return "";
            }
            return "";
        }
        return "";
    }

    public String getSOSNumber() {
        String coralFilePath = "/etc/default/coral";
        String sosNumber = "";
        try {
            Profile.Section cluster;
            Ini ini;
            File file = new File(coralFilePath);
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CLUSTER") && (cluster = (Profile.Section)ini.get((Object)"CLUSTER")).containsKey((Object)"SOS-NUMBER")) {
                sosNumber = (String)cluster.get((Object)"SOS-NUMBER");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return sosNumber;
    }

    public String getDepartment(String extension) {
        Optional data = this.authExtensionRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((AuthExtension)data.get()).getDepartment();
        }
        return "";
    }

    public String getZone(String extension) {
        Optional data = this.authExtensionRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((AuthExtension)data.get()).getZone();
        }
        return "";
    }

    public String getEcExtension(String department, String zone) {
        try {
            List listDepartment = this.authExtensionRepository.findByExtensionTypeAndDepartment("ec", department);
            List listZone = this.authExtensionRepository.findByExtensionTypeAndZone("ec", zone);
            if (!listDepartment.isEmpty()) {
                return ((AuthExtension)listDepartment.get(0)).getExtension();
            }
            if (!listZone.isEmpty()) {
                return ((AuthExtension)listZone.get(0)).getExtension();
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error on getting ec-extension:{}", (Object)e.getMessage());
            return "";
        }
    }

    public String getRluCodeForAll(String extension) {
        Optional data = this.authExtensionRepository.findByExtension(extension);
        String rluCode = "";
        if (data.isPresent()) {
            rluCode = ((AuthExtension)data.get()).getRluCode();
            if (rluCode != null && StringUtils.hasText((String)rluCode)) {
                return rluCode;
            }
            rluCode = ((ControlRluServer)this.controlRluServerRepository.findAllByOrderByIdDesc().get(0)).getRluCode();
        }
        return rluCode;
    }

    public String getDesignation(String extension) {
        Optional data = this.authExtensionRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((AuthExtension)data.get()).getDesignation();
        }
        return "";
    }

    public RequestResponse updateExtensionName(ExtensionNameUpdateModel extensionNameUpdateModel) {
        RequestResponse response = new RequestResponse();
        Optional extensionOptional = this.extensionsRepository.findByExtension(extensionNameUpdateModel.getExtensionNo());
        if (!extensionOptional.isPresent()) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Extension number is invalid");
            response.setMessageDetail("Extension Number is not present");
            return response;
        }
        Extension extension = (Extension)extensionOptional.get();
        extension.setName(extensionNameUpdateModel.getExtensionName());
        this.extensionsRepository.save((Object)extension);
        response.setStatus(Constants.Error.OK);
        response.setMessage("Extension Updated");
        response.setMessageDetail("Extension Updated With name " + extensionNameUpdateModel.getExtensionName());
        return response;
    }
}

