/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.dialCodeList.service;

import com.coraltele.db.telephony.pbx.entity.DialCodeList;
import com.coraltele.db.telephony.pbx.repository.DialCodeListRepository;
import com.coraltele.db.telephony.pbx.specification.DialCodeListSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.dialCodeList.model.DialCodeListModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DialCodeListService {
    private static final Logger logger = LogManager.getLogger(DialCodeListService.class);
    @Autowired
    DialCodeListRepository dialCodeListRepository;

    public RequestResponse createData(DialCodeListModel data, Principal principal) {
        logger.debug("create new dialCode : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            DialCodeList dialCode = new DialCodeList();
            dialCode.setIntercom(data.getIntercom());
            dialCode.setIsd(data.getIsd());
            dialCode.setLocal(data.getLocal());
            dialCode.setStd(data.getStd());
            this.dialCodeListRepository.save((Object)dialCode);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("DialCodeList Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create DialCodeList");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DialCodeListModel data) {
        logger.debug("Update dialCode {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional dialCode = this.dialCodeListRepository.findById((Object)data.getId());
        if (!dialCode.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("DialCodeList not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        ((DialCodeList)dialCode.get()).setIntercom(data.getIntercom());
        ((DialCodeList)dialCode.get()).setIsd(data.getIsd());
        ((DialCodeList)dialCode.get()).setLocal(data.getLocal());
        ((DialCodeList)dialCode.get()).setStd(data.getStd());
        this.dialCodeListRepository.save(dialCode.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("DialCodeList Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteDialCode(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional dialCodeList = this.dialCodeListRepository.findById((Object)ids);
            if (dialCodeList.isPresent()) {
                addValue.add(dialCodeList.get());
                this.dialCodeListRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DialCodeListSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.dialCodeListRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.dialCodeListRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<DialCodeListModel> entityToModelConversion(List<DialCodeList> DialCodeList2) {
        ArrayList<DialCodeListModel> addValue = new ArrayList<DialCodeListModel>();
        for (DialCodeList row : DialCodeList2) {
            DialCodeListModel data = new DialCodeListModel();
            data.setId(row.getId());
            data.setIntercom(row.getIntercom());
            data.setIsd(row.getIsd());
            data.setLocal(row.getLocal());
            data.setStd(row.getStd());
            addValue.add(data);
        }
        return addValue;
    }
}

