/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.externalApi.service;

import com.coraltele.helper.Constants;
import com.coraltele.helper.HttpUtils;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.billing.main.uc_notification.service.UcNotificationService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.uc.service.UCService;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ExternalApiService {
    private static final Logger logger = LogManager.getLogger(ExternalApiService.class);
    @Autowired
    private ExtensionsService extensionsService;
    @Autowired
    private UCService ucService;
    @Autowired
    UcNotificationService ucNotificationService;

    @PostConstruct
    private void postConstruct() {
    }

    public RequestResponse getCallBack(Authentication authentication) {
        this.ucNotificationService.updateNotificationForCallBack(authentication);
        RequestResponse returnValue = new RequestResponse();
        try {
            String extension = this.extensionsService.extensionForCallBack(authentication);
            String uri = HttpUtils.getWebsocketAPI() + "/getAllCallBackByNumber/" + extension;
            logger.info("Accessing callback data from {}", (Object)uri);
            RestTemplate restTemplate = new RestTemplate();
            Object result = restTemplate.getForObject(uri, Object.class, new Object[0]);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("callBack Data");
            returnValue.setMessageDetail("Assigned Extension:  " + extension);
            returnValue.setData(result);
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Records not found");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            return returnValue;
        }
    }

    public RequestResponse get() {
        RequestResponse returnValue = new RequestResponse();
        try {
            String url = HttpUtils.getSysConfigAPI() + "/sysconfig/api/syncLDAP";
            logger.info("Accessing LDAP data from {}", (Object)url);
            RestTemplate restTemplate = new RestTemplate();
            String result = (String)restTemplate.getForObject(url, String.class, new Object[0]);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Data Synced Successfully");
            returnValue.setData((Object)result);
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable To Sync Data");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            return returnValue;
        }
    }
}

