/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.main.service;

import com.coraltele.db.billing.main.repository.AgentStatusRepository;
import com.coraltele.db.coralapps.callcenter.entity.Queue;
import com.coraltele.db.coralapps.callcenter.entity.view.AgentQueueView;
import com.coraltele.db.coralapps.callcenter.repository.AgentQueueViewRepository;
import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.Member;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.main.repository.MemberRepository;
import com.coraltele.db.coralapps.main.repository.TiersRepository;
import com.coraltele.db.coralapps.main.specification.AgentSpecification;
import com.coraltele.db.telemetry.main.entity.AgentPerformanceSummary;
import com.coraltele.db.telemetry.main.repository.AgentPerformanceSummaryRepository;
import com.coraltele.db.telephony.pbx.entity.AgentQueue;
import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.repository.AgentQueueRepository;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.DidMappingRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PasswordConversion;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.XmlFileGenerator;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queue.model.QueueServicesModel;
import com.coraltele.service.coralApps.callcenter.queue.service.QueueService;
import com.coraltele.service.coralApps.main.model.AgentContactModel;
import com.coraltele.service.coralApps.main.model.AgentCreateModel;
import com.coraltele.service.coralApps.main.model.AgentModel;
import com.coraltele.service.coralApps.main.model.AgentTiersModel;
import com.coraltele.service.coralApps.main.model.AgentTiersMultipleUpdateModel;
import com.coraltele.service.coralApps.main.model.AgentTiersQueueModel;
import com.coraltele.service.coralApps.main.model.AgentUserModel;
import com.coraltele.service.coralApps.main.model.QueueAssignedModel;
import com.coraltele.service.coralApps.main.model.RunningCallModel;
import com.coraltele.service.coralApps.main.service.SwitchAcdTransactionalService;
import com.coraltele.service.coralApps.main.service.TiersService;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.pbx.fileConfiguration.defaultConfiguration.service.DefaultConfigurationService;
import com.coraltele.service.user.service.UserRoleService;
import com.coraltele.service.user.service.UserService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AgentService {
    private static final Logger logger = LogManager.getLogger(AgentService.class);
    @Autowired
    ExtensionsService extensionsService;
    @Autowired
    PasswordConversion sIPPasswordConversion;
    @Autowired
    DefaultConfigurationService extensionFileConfigurationService;
    @Autowired
    UserService userService;
    @Autowired
    UserRoleService userRoleService;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    AgentRepository agentRepository;
    @Autowired
    TiersService tiersService;
    @Autowired
    private PasswordEncoder bcryptEncoder;
    @Autowired
    AgentQueueViewRepository agentQueueRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    TiersRepository tiersRepository;
    @Autowired
    AgentQueueRepository agentQueueRepository2;
    @Autowired
    ExtensionsServicesRepository extensionsServicesRepository;
    @Autowired
    DidMappingRepository didMappingRepository;
    @Autowired
    AgentPerformanceSummaryRepository agentPerformanceSummaryRepository;
    @Autowired
    AgentStatusRepository statusRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    MemberRepository memberRepository;
    @Autowired
    private QueueRepository queueRepository;
    @Autowired
    private SwitchAcdTransactionalService switchAcdTransactionalService;
    @Autowired
    QueueService queueService;
    String rluCode = "";

    public boolean checkExtensionsFromGivenRangeForAgent(QueueServicesModel range) {
        for (int i = Integer.parseInt(range.getFrom()); i <= Integer.parseInt(range.getTo()); ++i) {
            Optional extensions = this.extensionsRepository.findByExtension(String.valueOf(i));
            if (!extensions.isPresent()) continue;
            return true;
        }
        return false;
    }

    public RequestResponse createExtensionAgentByGivenRange(QueueServicesModel extensionRange, Principal principal) throws IOException {
        RequestResponse returnValue;
        block12: {
            returnValue = new RequestResponse();
            boolean checkExtensionRange = this.checkExtensionsFromGivenRangeForAgent(extensionRange);
            String extSipPassword = this.extensionFileConfigurationService.getSipPassword();
            if (extSipPassword.equals("null") || extSipPassword == null || extSipPassword.equals("")) {
                extSipPassword = "1234";
            }
            try {
                if (!checkExtensionRange) {
                    for (int i = Integer.parseInt(extensionRange.getFrom()); i <= Integer.parseInt(extensionRange.getTo()); ++i) {
                        this.agentRepository.deleteAgentByName(String.valueOf(i));
                        String extension = String.valueOf(i);
                        String domain = this.extensionFileConfigurationService.getDomain();
                        if (domain.equals("null") || domain == null || domain.equals("")) {
                            domain = this.getDefaultDomain();
                        }
                        logger.info("Domain regarding to encrypted password:: " + domain);
                        logger.info("Extension regarding to encrypted password:: " + extension);
                        String password = extension + ":" + domain + ":1234";
                        logger.info("Over all password regarding to encrypted password:: " + password);
                        String sippwd = this.encryptPassword(password);
                        logger.info("Sip password Generated :: " + sippwd);
                        String filePath = "/etc/coraltele/sipserver/conf/directory/default/" + extension + ".xml";
                        try {
                            XmlFileGenerator.generateXmlFile((String)extension, (String)sippwd, (String)filePath);
                        }
                        catch (IOException ex) {
                            logger.error("Error generating XML file for extension {}: {}", (Object)extension, (Object)ex.getMessage());
                            throw new RuntimeException("Error generating XML file for extension " + extension, ex);
                        }
                        try {
                            this.createAgent(Integer.valueOf(i), extensionRange.getDefaultQueue(), extensionRange.getDispositionForm());
                        }
                        catch (Exception ex) {
                            logger.error("Error creating agent for extension {}: {}", (Object)extension, (Object)ex.getMessage());
                            throw new RuntimeException("Error creating agent for extension " + extension, ex);
                        }
                        Extension extensions = new Extension();
                        extensions.setExtension(String.valueOf(i));
                        extensions.setExtensionType("agent");
                        extensions.setSipPassword(this.sIPPasswordConversion.encryptContains(extSipPassword));
                        extensions.setPassword(this.bcryptEncoder.encode((CharSequence)"1234"));
                        extensions.setVmPassword(String.valueOf(i));
                        extensions.setDayInboundCos("0");
                        extensions.setDayOutboundCos("0");
                        extensions.setRluCode("");
                        extensions.setName("agent" + String.valueOf(i));
                        ExtensionsServices extService = new ExtensionsServices();
                        extService.setServiceCode("dialing-intercom");
                        extService.setExtension(String.valueOf(i));
                        ExtensionsServices extService1 = new ExtensionsServices();
                        extService1.setServiceCode("dialing-local");
                        extService1.setExtension(String.valueOf(i));
                        this.extensionsServicesRepository.save((Object)extService);
                        this.extensionsServicesRepository.save((Object)extService1);
                        DidMapping didMapping = new DidMapping();
                        didMapping.setExtNumber(String.valueOf(i));
                        this.didMappingRepository.save((Object)didMapping);
                        this.userService.createUserAgent(Integer.valueOf(i), principal);
                        this.userRoleService.createUserRoleAgent(Integer.valueOf(i));
                        this.extensionsRepository.save((Object)extensions);
                        if (!AgentService.getExtensionCreationAndDeletionTag()) continue;
                        AgentService.createKamailioExt((String)String.valueOf(i), (String)"1234");
                        logger.info("Password generated for KamailiosExt :: 1234");
                    }
                    try {
                        this.reloadXml();
                    }
                    catch (Exception e) {
                        logger.error("Exception while reloading XML", (Throwable)e);
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("agents created");
                    returnValue.setMessageDetail("All Agents have created successfully");
                    logger.info("Agent saved : {}", (Object)returnValue.getMessage());
                    break block12;
                }
                returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
                returnValue.setMessage("Can't create");
                returnValue.setMessageDetail("Extensions already created");
                logger.error(returnValue.getMessageDetail());
            }
            catch (Exception ex) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("agent can't create");
                returnValue.setMessageDetail("No such file or directory");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        }
        return returnValue;
    }

    public void createAgent(Integer i, String defaultQueue, String formName) throws IOException {
        Optional checkDefaultQueue;
        String string5 = "";
        String sBcPortUser = this.extensionFileConfigurationService.getSBCUserPort();
        if (sBcPortUser.equals("null") || sBcPortUser == null || sBcPortUser.equals("")) {
            sBcPortUser = "5060";
        }
        Agent agent = new Agent();
        String username = "agent";
        agent.setName(String.valueOf(i));
        agent.setSystem("single_box");
        agent.setType("callback");
        agent.setStatus("Logged Out");
        agent.setState("Waiting");
        agent.setAgentFullName(username + String.valueOf(i));
        agent.setInstanceId("single_box");
        agent.setDefaultQueue(defaultQueue);
        String portNumber = "";
        List list = this.controlRluServerRepository.findAllByOrderByIdAsc();
        if (list.size() >= 1) {
            this.rluCode = ((ControlRluServer)list.get(0)).getRluCode();
            string5 = ((ControlRluServer)list.get(0)).getVirtualIp();
            portNumber = ((ControlRluServer)list.get(0)).getMsfIpPort().toString();
        } else {
            this.rluCode = "";
            string5 = "";
            portNumber = "";
        }
        if (AgentService.getExtensionCreationAndDeletionTag()) {
            agent.setContact("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]sofia/internal/" + i + "@" + string5 + ":" + portNumber);
            logger.info("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]sofia/internal/{}@{}:{}", (Object)i, (Object)string5, (Object)portNumber);
        } else {
            agent.setContact("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]user/" + i);
            logger.info("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]user/{}", (Object)i);
        }
        this.agentRepository.save((Object)agent);
        if (defaultQueue != null && StringUtils.hasText((String)defaultQueue) && !(checkDefaultQueue = this.queueRepository.findBySystemName(defaultQueue)).isPresent()) {
            this.queueService.createQueue1(defaultQueue, formName);
        }
    }

    public synchronized void createAgent1(Integer i, String defaultQueue) throws IOException {
        String string5 = "";
        String sBcPortUser = this.extensionFileConfigurationService.getSBCUserPort();
        if (sBcPortUser.equals("null") || sBcPortUser == null || sBcPortUser.equals("")) {
            sBcPortUser = "5060";
        }
        Agent agent = new Agent();
        String username = "agent";
        agent.setName(String.valueOf(i));
        agent.setSystem("single_box");
        agent.setType("callback");
        agent.setStatus("Available");
        agent.setState("Waiting");
        agent.setAgentFullName(username + String.valueOf(i));
        agent.setInstanceId("single_box");
        agent.setDefaultQueue(defaultQueue);
        String portNumber = "";
        List list = this.controlRluServerRepository.findAllByOrderByIdAsc();
        if (list.size() >= 1) {
            this.rluCode = ((ControlRluServer)list.get(0)).getRluCode();
            string5 = ((ControlRluServer)list.get(0)).getVirtualIp();
            portNumber = ((ControlRluServer)list.get(0)).getMsfIpPort().toString();
        } else {
            this.rluCode = "";
            string5 = "";
            portNumber = "";
        }
        Optional extensionOptional = this.extensionsRepository.findByExtension(String.valueOf(i));
        if (extensionOptional.isPresent()) {
            Extension ext = (Extension)extensionOptional.get();
            if (Boolean.TRUE.equals(ext.getSgwUser())) {
                agent.setContact("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]user/" + i);
                logger.info("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]user/{}", (Object)i);
            } else {
                agent.setContact("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]sofia/internal/" + i + "@" + string5 + ":" + portNumber);
                logger.info("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]sofia/internal/{}@{}:{}", (Object)i, (Object)string5, (Object)portNumber);
            }
        }
        this.agentRepository.save((Object)agent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public RequestResponse updateAgentContact(AgentContactModel agentContactModel) {
        Agent agent;
        RequestResponse response;
        block11: {
            response = new RequestResponse();
            Optional agentOpt = this.agentRepository.findByName(agentContactModel.getAgentName());
            if (!agentOpt.isPresent()) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Agent not found");
                return response;
            }
            agent = (Agent)agentOpt.get();
            Optional extensionOptional = this.extensionsRepository.findByExtension(agent.getName());
            if (agentContactModel.getNewContact() != null && !agentContactModel.getNewContact().trim().isEmpty()) {
                agent.setContact(agentContactModel.getNewContact());
                logger.info("Replaced contact for agent {}: {}", (Object)agent.getName(), (Object)agentContactModel.getNewContact());
                response.setMessage("Contact replaced successfully.");
            } else {
                if (agentContactModel.getNewCallTimeout() != null) {
                    String contact = agent.getContact();
                    if (contact != null && contact.contains("call_timeout=")) {
                        String updatedContact = contact.replaceAll("call_timeout=\\d+", "call_timeout=" + agentContactModel.getNewCallTimeout());
                        agent.setContact(updatedContact);
                        logger.info("Updated call_timeout for agent {}: {}", (Object)agent.getName(), (Object)updatedContact);
                        response.setMessage("call_timeout value updated successfully.");
                        break block11;
                    } else {
                        response.setStatus(Constants.Error.ERROR);
                        response.setMessage("call_timeout not found in contact.");
                        response.setMessageDetail("Agent " + agent.getName() + " does not have a valid call_timeout in contact.");
                        return response;
                    }
                }
                if (Boolean.TRUE.equals(agentContactModel.getRecord())) {
                    if (!extensionOptional.isPresent()) {
                        response.setMessage("Cannot update record");
                        response.setMessageDetail("Agent not in Extension");
                        response.setStatus(Constants.Error.ERROR);
                        return response;
                    }
                    ((Extension)extensionOptional.get()).setRecord(Boolean.valueOf(true));
                    this.extensionsRepository.save(extensionOptional.get());
                } else {
                    if (!Boolean.FALSE.equals(agentContactModel.getRecord()) && agentContactModel.getRecord() != null) {
                        response.setStatus(Constants.Error.ERROR);
                        response.setMessage("Invalid request");
                        response.setMessageDetail("Either newContact or newCallTimeout must be provided.");
                        return response;
                    }
                    if (!extensionOptional.isPresent()) {
                        response.setMessage("Cannot update record");
                        response.setMessageDetail("Agent not in Extension");
                        response.setStatus(Constants.Error.ERROR);
                        return response;
                    }
                    ((Extension)extensionOptional.get()).setRecord(Boolean.valueOf(false));
                    this.extensionsRepository.save(extensionOptional.get());
                }
            }
        }
        this.agentRepository.save((Object)agent);
        response.setMessageDetail("Agent Saved with new Contact");
        return response;
    }

    public RequestResponse deleteAgent(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findById(id);
            Optional agent = this.agentRepository.findByName(((User)user.get()).getUsername());
            if (agent.isPresent()) {
                String agent1 = ((Agent)agent.get()).getName();
                if (AgentService.getExtensionCreationAndDeletionTag()) {
                    AgentService.removeKamailioExt((String)agent1);
                }
                this.extensionsService.deleteAgentExtension(((Agent)agent.get()).getName());
                this.userRoleService.deleteUserAgent(((Agent)agent.get()).getName());
                this.agentRepository.deleteByName(((Agent)agent.get()).getName());
                this.tiersService.deleteTiersAgent(((Agent)agent.get()).getName());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Record deleted successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete user");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAgentUsersDetail() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<AgentUserModel> addValue = new ArrayList<AgentUserModel>();
        List list = this.agentQueueRepository.findAll();
        if (list != null && !list.isEmpty()) {
            for (AgentQueueView row : list) {
                Optional user;
                if (row == null || row.getName() == null || !(user = this.userRepository.findByUsername(row.getName())).isPresent()) continue;
                AgentUserModel data = new AgentUserModel();
                data.setId(((User)user.get()).getId().intValue());
                data.setQueue(row.getQueue());
                data.setPosition(row.getPosition());
                data.setUserName(((User)user.get()).getUsername());
                data.setDescription(((User)user.get()).getDescription());
                data.setContactNo(((User)user.get()).getContactNo());
                data.setEmailId(((User)user.get()).getEmailId());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List of records");
            returnValue.setMessageDetail("List of agentUser");
            logger.info(returnValue.getMessageDetail());
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Empty");
            returnValue.setMessageDetail("AgentUser list is empty.");
            logger.info(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse updateAgentUser(AgentUserModel data) {
        logger.debug("Update user {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional user = this.userRepository.findById(data.getId());
        if (user.isPresent()) {
            if (user.isPresent()) {
                if (data.getContactNo() != null) {
                    ((User)user.get()).setContactNo(data.getContactNo());
                }
                if (data.getDescription() != null) {
                    ((User)user.get()).setDescription(data.getDescription());
                }
                if (data.getEmailId() != null) {
                    ((User)user.get()).setEmailId(data.getEmailId());
                }
                ((User)user.get()).setEnabled(Integer.valueOf(1));
                this.userRepository.save(user.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("updated");
                returnValue.setMessageDetail("user updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("user not found");
                logger.info(returnValue.getMessage());
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("user not found");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    protected String encryptPassword(String password) {
        StringBuffer sb = null;
        String rtrVal = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());
            byte[] byteData = md.digest();
            sb = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("exception at MD5 encryption:" + e.getMessage());
        }
        if (sb != null) {
            rtrVal = sb.toString().trim();
        }
        return rtrVal;
    }

    public RequestResponse getByName(String name) {
        RequestResponse returnValue = new RequestResponse();
        Optional agent = this.agentRepository.findByName(name);
        if (agent.isPresent()) {
            AgentModel data = new AgentModel();
            if (((Agent)agent.get()).getStatus().equals("Available (On Demand)") && ((Agent)agent.get()).getState().equals("Waiting")) {
                data.setStatus("Available (On Demand)");
            } else if (((Agent)agent.get()).getStatus().equals("Available") && ((Agent)agent.get()).getState().equals("Waiting")) {
                data.setStatus("Available");
            } else if (((Agent)agent.get()).getStatus().equals("Available (On Demand)") && ((Agent)agent.get()).getState().equals("Idle")) {
                data.setStatus("ACW");
            } else if ((((Agent)agent.get()).getStatus().equals("Available (On Demand)") || ((Agent)agent.get()).getStatus().equals("Available")) && ((Agent)agent.get()).getState().equals("In a queue call")) {
                data.setStatus("Talk");
            } else if ((((Agent)agent.get()).getStatus().equals("Available (On Demand)") || ((Agent)agent.get()).getStatus().equals("Available")) && ((Agent)agent.get()).getState().equalsIgnoreCase("Receiving")) {
                data.setStatus("Ring");
            } else if (((Agent)agent.get()).getStatus().equals("Off-Hook")) {
                data.setStatus("Off-Hook");
            } else {
                data.setStatus(((Agent)agent.get()).getStatus());
            }
            List performanceSummaries = this.agentPerformanceSummaryRepository.findByAgentName(name);
            LocalDate today = LocalDate.now();
            List todaysSummaries = performanceSummaries.stream().filter(summary -> {
                LocalDate summaryDate = Instant.ofEpochSecond(summary.getStartDate()).atZone(ZoneId.systemDefault()).toLocalDate();
                return summaryDate.isEqual(today);
            }).collect(Collectors.toList());
            if (!todaysSummaries.isEmpty()) {
                AgentPerformanceSummary agentPerformanceSummary = (AgentPerformanceSummary)todaysSummaries.get(0);
                data.setTotalAnswered(agentPerformanceSummary.getTotalAnswered());
                data.setTotalConnected(agentPerformanceSummary.getTotalConnected());
                data.setTotalDialed(agentPerformanceSummary.getTotalDialed());
                data.setTotalNoAnswered(agentPerformanceSummary.getTotalNoAnswered());
                data.setTotalNotConnected(agentPerformanceSummary.getTotalNotConnected());
                data.setTotalOffered(agentPerformanceSummary.getTotalOffered());
            } else {
                data.setTotalAnswered(Integer.valueOf(0));
                data.setTotalConnected(Integer.valueOf(0));
                data.setTotalDialed(Integer.valueOf(0));
                data.setTotalNoAnswered(Integer.valueOf(0));
                data.setTotalNotConnected(Integer.valueOf(0));
                data.setTotalOffered(Integer.valueOf(0));
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData((Object)data);
            logger.info(returnValue.getMessage());
        } else {
            Optional user = this.userRepository.findByUsername(name);
            if (user.isPresent()) {
                Optional agentName = this.agentRepository.findByName(((User)user.get()).getContactNo());
                AgentModel data2 = new AgentModel();
                if (((Agent)agentName.get()).getStatus().equals("Available (On Demand)") && ((Agent)agentName.get()).getState().equals("Waiting")) {
                    data2.setStatus("Available (On Demand)");
                } else if (((Agent)agent.get()).getStatus().equals("Available") && ((Agent)agent.get()).getState().equals("Waiting")) {
                    data2.setStatus("Available");
                } else if (((Agent)agentName.get()).getStatus().equals("Available (On Demand)") && ((Agent)agentName.get()).getState().equals("Idle")) {
                    data2.setStatus("ACW");
                } else if ((((Agent)agentName.get()).getStatus().equals("Available (On Demand)") || ((Agent)agent.get()).getStatus().equals("Available")) && ((Agent)agentName.get()).getState().equals("In a queue call")) {
                    data2.setStatus("Talk");
                } else if ((((Agent)agentName.get()).getStatus().equals("Available (On Demand)") || ((Agent)agent.get()).getStatus().equals("Available")) && ((Agent)agentName.get()).getState().equalsIgnoreCase("Receiving")) {
                    data2.setStatus("Ring");
                } else if (((Agent)agentName.get()).getStatus().equals("Off-Hook")) {
                    data2.setStatus("Off-Hook");
                } else {
                    data2.setStatus(((Agent)agentName.get()).getStatus());
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setData((Object)data2);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found in Agent");
                logger.error(returnValue.getMessageDetail());
            }
        }
        return returnValue;
    }

    public RequestResponse createInTiers(AgentTiersMultipleUpdateModel data) {
        RequestResponse returnValue = new RequestResponse();
        List names = data.getName();
        String queue = data.getQueue();
        try {
            for (String name : names) {
                Tiers updatedTier = new Tiers();
                updatedTier.setAgent(name);
                updatedTier.setQueue(queue);
                updatedTier.setLevel(Integer.valueOf(1));
                updatedTier.setPosition(Integer.valueOf(1));
                updatedTier.setState("Ready");
                this.tiersRepository.save((Object)updatedTier);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Records Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error");
            returnValue.setMessageDetail("Failed to create records: " + e.getMessage());
            logger.error(returnValue.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public synchronized RequestResponse updateInTiersAndAgent(AgentTiersMultipleUpdateModel data) {
        RequestResponse returnValue = new RequestResponse();
        List names = data.getName();
        String queue = data.getQueue();
        try {
            for (String name : names) {
                Optional existingTier;
                Optional optionalAgent = this.agentRepository.findByName(name);
                if (!optionalAgent.isPresent()) {
                    try {
                        this.createAgent1(Integer.valueOf(Integer.parseInt(name)), queue);
                    }
                    catch (NumberFormatException nfe) {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Invalid Agent ID");
                        returnValue.setMessageDetail("Agent ID must be numeric: " + name);
                        return returnValue;
                    }
                }
                if ((existingTier = this.tiersRepository.findByAgentAndQueue(name, queue)).isPresent()) {
                    logger.info("Tier already exists for agent '{}' in queue '{}', skipping creation.", (Object)name, (Object)queue);
                    continue;
                }
                Tiers updatedTier = new Tiers();
                updatedTier.setAgent(name);
                updatedTier.setQueue(queue);
                updatedTier.setLevel(Integer.valueOf(1));
                updatedTier.setPosition(Integer.valueOf(1));
                updatedTier.setState("Ready");
                this.tiersRepository.save((Object)updatedTier);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    logger.warn("Thread interrupted during sleep: {}", (Object)ie.getMessage(), (Object)ie);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Success");
            returnValue.setMessageDetail("Tiers and agent records updated successfully.");
            logger.info("Tiers and agent records updated for queue '{}': {}", (Object)queue, (Object)names);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error");
            returnValue.setMessageDetail("Failed to update tiers or create agent: " + e.getMessage());
            logger.error("Error in updateInTiersAndAgent for queue '{}': {}", (Object)queue, (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public RequestResponse getAgentUsersDetailsWithoutQueue(String queueToExclude, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<AgentTiersModel> addValue = new ArrayList<AgentTiersModel>();
        List agents = this.agentRepository.findAll();
        List tiers = this.tiersRepository.findAll();
        boolean isTLUser = this.userService.checkRoleTL(principal.getName());
        for (Agent agent : agents) {
            AgentTiersModel agentUserModel;
            if (!this.isValidAgent(agent.getName())) continue;
            boolean excludeAgent = false;
            String agentQueue = null;
            for (Tiers tier : tiers) {
                if (!agent.getName().equals(tier.getAgent())) continue;
                String tierQueue = tier.getQueue();
                if (tierQueue.equals(queueToExclude)) {
                    excludeAgent = true;
                    break;
                }
                agentQueue = tierQueue;
            }
            if (excludeAgent) continue;
            if (isTLUser) {
                if (agent.getReportingHead() == null || !agent.getReportingHead().equals(principal.getName())) continue;
                agentUserModel = new AgentTiersModel();
                agentUserModel.setAgentFullName(agent.getAgentFullName());
                agentUserModel.setId(agent.getName());
                agentUserModel.setQueue(agentQueue);
                addValue.add(agentUserModel);
                continue;
            }
            agentUserModel = new AgentTiersModel();
            agentUserModel.setAgentFullName(agent.getAgentFullName());
            agentUserModel.setId(agent.getName());
            agentUserModel.setQueue(agentQueue);
            addValue.add(agentUserModel);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of list:" + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAgentUsersDetailsWithQueue(String queueToInclude) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<AgentTiersQueueModel> addValue = new ArrayList<AgentTiersQueueModel>();
        List tiers = this.tiersRepository.findByQueue(queueToInclude);
        for (Tiers tier : tiers) {
            Optional agent = this.agentRepository.findByName(tier.getAgent());
            if (!agent.isPresent()) continue;
            Optional extensionOptional = this.extensionsRepository.findByExtension(((Agent)agent.get()).getName());
            AgentTiersQueueModel agentUserModel = new AgentTiersQueueModel();
            agentUserModel.setAgentFullName(((Agent)agent.get()).getAgentFullName());
            agentUserModel.setName(((Agent)agent.get()).getName());
            agentUserModel.setContact(((Agent)agent.get()).getContact());
            agentUserModel.setQueue(tier.getQueue());
            agentUserModel.setId(tier.getId());
            agentUserModel.setPosition(tier.getPosition());
            if (extensionOptional.isPresent()) {
                agentUserModel.setRecord(((Extension)extensionOptional.get()).getRecord());
            }
            addValue.add(agentUserModel);
        }
        addValue.sort(Comparator.comparing(AgentTiersQueueModel::getPosition));
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of list:" + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteTiersById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional tiers = this.tiersRepository.findById(Integer.valueOf(ids));
            if (tiers.isPresent()) {
                addValue.add(tiers.get());
                this.tiersRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteTiersAndAgentById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        List ids = data.getIntId();
        List tiersList = (List)this.tiersRepository.findAllById((Iterable)ids);
        if (tiersList.size() != ids.size()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Some records not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        ArrayList agentsToDelete = new ArrayList();
        for (Tiers tier2 : tiersList) {
            this.agentRepository.findByName(tier2.getAgent()).ifPresent(agentsToDelete::add);
        }
        if (agentsToDelete != null && !agentsToDelete.isEmpty()) {
            Iterator iterator = agentsToDelete.iterator();
            while (iterator.hasNext()) {
                boolean hasOtherQueues;
                Agent agent = (Agent)iterator.next();
                String agentName = agent.getName();
                if (agentName == null) {
                    iterator.remove();
                    continue;
                }
                List allTiersForAgent = this.tiersRepository.findByAgent(agentName);
                if (allTiersForAgent == null || allTiersForAgent.isEmpty() || !(hasOtherQueues = allTiersForAgent.stream().anyMatch(tier -> !ids.contains(tier.getId())))) continue;
                iterator.remove();
            }
            if (!agentsToDelete.isEmpty()) {
                this.agentRepository.deleteAll(agentsToDelete);
            }
        }
        this.tiersRepository.deleteAll((Iterable)tiersList);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getQueueAgainstAgent(String agentName) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        List agents = this.agentRepository.findAll();
        List tiers = this.tiersRepository.findAll();
        for (Agent agent : agents) {
            if (agentName != null && !agent.getName().equals(agentName)) continue;
            ArrayList<QueueAssignedModel> queuesAssigned = new ArrayList<QueueAssignedModel>();
            for (Tiers tier : tiers) {
                if (!agent.getName().equals(tier.getAgent())) continue;
                String tierQueue = tier.getQueue();
                QueueAssignedModel queueAssignedModel = new QueueAssignedModel();
                queueAssignedModel.setQueueName(tierQueue);
                Optional queueOptional = this.queueRepository.findBySystemName(tierQueue);
                if (queueOptional.isPresent()) {
                    queueAssignedModel.setQueueFullName(tierQueue + " - " + ((Queue)queueOptional.get()).getDescription());
                }
                queuesAssigned.add(queueAssignedModel);
            }
            if (agentName == null || !agent.getName().equals(agentName)) continue;
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Number of queues assigned to " + agentName + ": " + queuesAssigned.size());
            returnValue.setData(queuesAssigned);
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of list:" + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getQueueAgainstExtension(String extensionName) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<QueueAssignedModel> queuesAssigned = new ArrayList<QueueAssignedModel>();
        List extensions = this.extensionsRepository.findAll().stream().filter(ext -> "phone".equalsIgnoreCase(ext.getExtensionType())).collect(Collectors.toList());
        List tiers = this.tiersRepository.findAll();
        for (Extension extension : extensions) {
            if (extensionName != null && !extension.getExtension().equals(extensionName)) continue;
            for (Tiers tier : tiers) {
                if (!extension.getExtension().equals(tier.getAgent())) continue;
                String tierQueue = tier.getQueue();
                QueueAssignedModel queueAssignedModel = new QueueAssignedModel();
                queueAssignedModel.setQueueName(tierQueue);
                Optional queueOptional = this.queueRepository.findBySystemName(tierQueue);
                queueOptional.ifPresent(queue -> queueAssignedModel.setQueueFullName(tierQueue + " - " + queue.getDescription()));
                queuesAssigned.add(queueAssignedModel);
            }
            if (extensionName == null || !extension.getExtension().equals(extensionName)) continue;
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Number of queues assigned to " + extensionName + ": " + queuesAssigned.size());
            returnValue.setData(queuesAssigned);
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("No queues found for the given extension.");
        returnValue.setData(queuesAssigned);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteSwitchAcd(Integer ext) {
        List didMappingList;
        Optional queueOptional;
        RequestResponse returnValue = new RequestResponse();
        Optional extensionOptional = this.extensionsRepository.findByExtension(ext.toString());
        if (!extensionOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to delete");
            returnValue.setMessageDetail(String.format("Extension not found : %s", ext));
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Extension extensionEntity = (Extension)extensionOptional.get();
        String extension = extensionEntity.getExtension();
        String queueSystemName = extensionEntity.getData();
        if (queueSystemName != null && (queueOptional = this.queueRepository.findBySystemName(queueSystemName)).isPresent()) {
            this.switchAcdTransactionalService.deleteFromCoralApps(queueSystemName, Integer.valueOf(((Queue)queueOptional.get()).getId()));
        }
        if (!(didMappingList = this.didMappingRepository.findAllByExtNumber(extension)).isEmpty()) {
            this.didMappingRepository.deleteAll((Iterable)didMappingList);
        }
        this.switchAcdTransactionalService.deleteFromExtensions(extension);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Deleted");
        returnValue.setMessageDetail("Queue, associated extension, and tiers deleted successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllAgentList() {
        List list = this.agentRepository.findAll();
        ArrayList<AgentTiersQueueModel> addValue = new ArrayList<AgentTiersQueueModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Agent agent : list) {
            AgentTiersQueueModel data = new AgentTiersQueueModel();
            if (agent.getAgentFullName() != null) {
                data.setAgentFullName(agent.getName() + "-" + agent.getAgentFullName());
            } else {
                data.setAgentFullName(agent.getName() + "-");
            }
            data.setName(agent.getName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createDataInAgent(AgentCreateModel data) {
        logger.debug("create new Agent : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userOptional = this.userRepository.findByUsername(data.getName());
        try {
            Agent agent = new Agent();
            agent.setAgentFullName(data.getAgentFullName());
            agent.setContact(data.getContact());
            agent.setDefaultQueue(data.getDefaultQueue());
            agent.setInstanceId("single_box");
            agent.setName(data.getName());
            agent.setType("callback");
            agent.setMaxNoAnswer(data.getMaxNoAnswer() != null ? data.getMaxNoAnswer() : 0);
            agent.setWrapUpTime(data.getWrapUpTime() != null ? data.getWrapUpTime() : 0);
            agent.setRejectDelayTime(data.getRejectDelayTime() != null ? data.getRejectDelayTime() : 0);
            agent.setBusyDelayTime(data.getBusyDelayTime() != null ? data.getBusyDelayTime() : 0);
            agent.setNoAnswerDelayTime(data.getNoAnswerDelayTime() != null ? data.getNoAnswerDelayTime() : 0);
            if (userOptional.isPresent()) {
                User user = (User)userOptional.get();
                if (Boolean.TRUE.equals(data.getIsOnDemand())) {
                    user.setIsOnDemand(Boolean.valueOf(true));
                } else {
                    user.setIsOnDemand(Boolean.valueOf(false));
                }
                this.userRepository.save((Object)user);
            }
            this.agentRepository.save((Object)agent);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Agent Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Agent");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(AgentCreateModel data) {
        logger.debug("Update Agent {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userOptional = this.userRepository.findByUsername(data.getName());
        Optional agentOptional = this.agentRepository.findById(data.getId());
        if (!agentOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Agent not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Agent agent = (Agent)agentOptional.get();
        if (data.getAgentFullName() != null) {
            agent.setAgentFullName(data.getAgentFullName());
        }
        if (data.getDefaultQueue() != null) {
            agent.setDefaultQueue(data.getDefaultQueue());
        }
        agent.setInstanceId("single_box");
        if (data.getType() != null) {
            agent.setType(data.getType());
        }
        if (data.getName() != null) {
            agent.setName(data.getName());
        }
        agent.setMaxNoAnswer(data.getMaxNoAnswer() != null ? data.getMaxNoAnswer() : 0);
        agent.setWrapUpTime(data.getWrapUpTime() != null ? data.getWrapUpTime() : 0);
        agent.setRejectDelayTime(data.getRejectDelayTime() != null ? data.getRejectDelayTime() : 0);
        agent.setBusyDelayTime(data.getBusyDelayTime() != null ? data.getBusyDelayTime() : 0);
        agent.setNoAnswerDelayTime(data.getNoAnswerDelayTime() != null ? data.getNoAnswerDelayTime() : 0);
        if (userOptional.isPresent()) {
            User user = (User)userOptional.get();
            if (Boolean.TRUE.equals(data.getIsOnDemand())) {
                user.setIsOnDemand(Boolean.valueOf(true));
            } else {
                user.setIsOnDemand(Boolean.valueOf(false));
            }
            this.userRepository.save((Object)user);
        }
        this.agentRepository.save((Object)agent);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Agent Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteAgentById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional agent = this.agentRepository.findById(Integer.valueOf(ids));
            String agentDel = ((Agent)agent.get()).getName();
            if (AgentService.getExtensionCreationAndDeletionTag()) {
                AgentService.removeKamailioExt((String)agentDel);
            }
            if (agent.isPresent()) {
                addValue.add(agent.get());
                this.agentRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AgentSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.agentRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.agentRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<AgentCreateModel> entityToModelConversion(List<Agent> agent) {
        ArrayList<AgentCreateModel> addValue = new ArrayList<AgentCreateModel>();
        for (Agent row : agent) {
            AgentCreateModel data = new AgentCreateModel();
            Optional userOptional = this.userRepository.findByUsername(row.getName());
            data.setId(row.getId());
            data.setAgentFullName(row.getAgentFullName());
            data.setName(row.getName());
            data.setContact(row.getContact());
            data.setDefaultQueue(row.getDefaultQueue());
            data.setInstanceId(row.getInstanceId());
            data.setType(row.getType());
            data.setMaxNoAnswer(Integer.valueOf(row.getMaxNoAnswer()));
            data.setBusyDelayTime(Integer.valueOf(row.getBusyDelayTime()));
            data.setRejectDelayTime(Integer.valueOf(row.getRejectDelayTime()));
            data.setWrapUpTime(Integer.valueOf(row.getWrapUpTime()));
            data.setNoAnswerDelayTime(Integer.valueOf(row.getNoAnswerDelayTime()));
            if (userOptional.isPresent()) {
                data.setIsOnDemand(((User)userOptional.get()).getIsOnDemand());
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse createAgentByQueue(QueueServicesModel extensionRange, Principal principal) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        if (extensionRange.getExistingQueue() != null || StringUtils.hasText((String)extensionRange.getExistingQueue())) {
            try {
                boolean checkExtensionRange = this.checkExtensionsFromGivenRangeForAgent(extensionRange);
                if (!checkExtensionRange) {
                    RequestResponse agentResponse = this.createExtensionAgentByGivenRange(extensionRange, principal);
                    if (agentResponse.getStatus().equals((Object)Constants.Error.OK)) {
                        for (int i = Integer.parseInt(extensionRange.getFrom()); i <= Integer.parseInt(extensionRange.getTo()); ++i) {
                            Tiers tier = new Tiers();
                            tier.setAgent(String.valueOf(i));
                            tier.setQueue(extensionRange.getExistingQueue());
                            tier.setState("Ready");
                            tier.setLevel(Integer.valueOf(1));
                            tier.setPosition(Integer.valueOf(1));
                            this.tiersRepository.save((Object)tier);
                        }
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("agent created successfully ");
                    returnValue.setMessageDetail("agents created with selected queue");
                    logger.info(returnValue.getMessageDetail());
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Extension already exist");
                    returnValue.setMessageDetail("select different extension");
                    logger.error("Already exist: {}", (Object)returnValue.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid data");
                returnValue.setMessageDetail("Unable to complete process" + e.getMessage());
                logger.error("Unknown Error : {}", (Object)e.getMessage());
            }
            return returnValue;
        }
        RequestResponse response = new RequestResponse();
        try {
            response = this.createExtensionAgentByGivenRange(extensionRange, principal);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Invalid Data");
            response.setMessageDetail(e.getMessage());
            logger.error(e.getMessage());
        }
        return response;
    }

    public boolean checkExtensionWithTypeAgent(QueueServicesModel range) {
        for (int i = Integer.parseInt(range.getFrom()); i <= Integer.parseInt(range.getTo()); ++i) {
            Optional extensions = this.extensionsRepository.findByExtension(String.valueOf(i));
            if (extensions.isPresent()) {
                if (((Extension)extensions.get()).getExtensionType().equals("agent")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean checkTiersExist(String agent, String queue) {
        Optional tiersData = this.tiersRepository.findByAgentAndQueue(agent, queue);
        return tiersData.isPresent();
    }

    public void createAgentQueueData(String agent, String queue) {
        AgentQueue record = new AgentQueue();
        record.setAgent(agent);
        record.setAgentQueue(queue);
        this.agentQueueRepository2.save((Object)record);
    }

    public RequestResponse updateDialingStatus(AgentCreateModel data, Principal principal) {
        logger.debug("Update DialingStatus {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional agent = this.agentRepository.findByName(principal.getName());
        if (!agent.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Agent not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getDialingStatus() != null && data.getDialingStatus().equalsIgnoreCase("talk")) {
            ((Agent)agent.get()).setDialingStatus("talk");
        } else if (data.getDialingStatus() != null && data.getDialingStatus().equalsIgnoreCase("ring")) {
            ((Agent)agent.get()).setDialingStatus("ring");
        } else {
            ((Agent)agent.get()).setDialingStatus("");
        }
        this.agentRepository.save(agent.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("DialingStatus Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAgentCallData(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<RunningCallModel> addValue = new ArrayList<RunningCallModel>();
        try {
            List tierList = this.tiersRepository.findByAgent(principal.getName());
            if (tierList.isEmpty()) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Agent not associated with queue");
                logger.error(returnValue.getMessage());
            } else {
                boolean membersFound = false;
                for (Tiers row : tierList) {
                    List memberList = this.memberRepository.findByQueueAndStateOrderByJoinedEpochDesc(row.getQueue(), "Waiting");
                    if (memberList.isEmpty()) continue;
                    membersFound = true;
                    for (Member memberData : memberList) {
                        RunningCallModel data = new RunningCallModel();
                        data.setCidName(memberData.getCidName());
                        data.setCidNumber(memberData.getCidNumber());
                        data.setUuid(memberData.getUuid());
                        data.setQueue(memberData.getQueue());
                        data.setState(memberData.getState());
                        data.setJoinedEpoch(memberData.getJoinedEpoch());
                        addValue.add(data);
                    }
                }
                if (!membersFound) {
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("No members found in any queue");
                    logger.error(returnValue.getMessage());
                } else {
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("list of records");
                    returnValue.setData(addValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Something went wrong");
            returnValue.setMessageDetail("Contact the administrator");
        }
        return returnValue;
    }

    public RequestResponse getAgentWithTeamLeader(String teamLeader) {
        List agents = this.agentRepository.findAll();
        ArrayList<AgentTiersModel> addValue = new ArrayList<AgentTiersModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Agent agent : agents) {
            if (agent.getReportingHead() == null || !agent.getReportingHead().equals(teamLeader)) continue;
            AgentTiersModel agentQueue = new AgentTiersModel();
            agentQueue.setId(agent.getName());
            agentQueue.setAgentFullName(agent.getAgentFullName());
            addValue.add(agentQueue);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of List: " + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAgentWithoutTeamLeader() {
        List agents = this.agentRepository.findAll();
        ArrayList<AgentTiersModel> addValue = new ArrayList<AgentTiersModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Agent agent : agents) {
            if (agent.getReportingHead() != null && !agent.getReportingHead().equals("")) continue;
            AgentTiersModel agentQueue = new AgentTiersModel();
            agentQueue.setId(agent.getName());
            agentQueue.setAgentFullName(agent.getAgentFullName());
            addValue.add(agentQueue);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of List: " + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateReportingHeadBlank(AgentTiersMultipleUpdateModel data) {
        RequestResponse returnValue = new RequestResponse();
        List names = data.getName();
        try {
            for (String name : names) {
                Optional agent = this.agentRepository.findByName(name);
                Optional user = this.userRepository.findByUsername(name);
                ((Agent)agent.get()).setReportingHead("");
                ((User)user.get()).setReportingHead("");
                this.agentRepository.save(agent.get());
                this.userRepository.save(user.get());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Records Updated Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error");
            returnValue.setMessageDetail("Failed to update records: " + e.getMessage());
            logger.error(returnValue.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateReportingHead(AgentTiersMultipleUpdateModel data) {
        RequestResponse returnValue = new RequestResponse();
        List names = data.getName();
        try {
            for (String name : names) {
                Optional agent = this.agentRepository.findByName(name);
                Optional user = this.userRepository.findByUsername(name);
                ((Agent)agent.get()).setReportingHead(data.getReportingHead());
                ((User)user.get()).setReportingHead(data.getReportingHead());
                this.agentRepository.save(agent.get());
                this.userRepository.save(user.get());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Records Updated Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error");
            returnValue.setMessageDetail("Failed to update records: " + e.getMessage());
            logger.error(returnValue.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public static boolean getSbcPhoneEnable() {
        String coralFilePath = "/etc/default/coral";
        try {
            Profile.Section cluster;
            Ini ini;
            File file = new File(coralFilePath);
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CLUSTER") && (cluster = (Profile.Section)ini.get((Object)"CLUSTER")).containsKey((Object)"SBC-PHONE-ENABLE")) {
                String value = ((String)cluster.get((Object)"SBC-PHONE-ENABLE")).trim();
                return value.equalsIgnoreCase("true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public RequestResponse getAgentUsersDetailsWithoutQueue1(String queueToExclude, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<AgentTiersModel> addValue = new ArrayList<AgentTiersModel>();
        List extensions = this.extensionsRepository.findAll().stream().filter(ext -> "phone".equalsIgnoreCase(ext.getExtensionType())).collect(Collectors.toList());
        Set excludedExtensions = this.tiersRepository.findAll().stream().filter(tier -> queueToExclude.equals(tier.getQueue())).map(Tiers::getAgent).collect(Collectors.toSet());
        for (Extension ext2 : extensions) {
            if (excludedExtensions.contains(ext2.getExtension())) continue;
            AgentTiersModel model = new AgentTiersModel();
            model.setId(ext2.getExtension());
            model.setQueue(ext2.getData());
            List optionalUser = this.userRepository.findByContactNo(ext2.getExtension());
            if (!optionalUser.isEmpty()) {
                model.setName(((User)optionalUser.get(0)).getUsername());
            }
            addValue.add(model);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of list: " + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public static void createKamailioExt(String ext, String sippwd) {
        String str = "kamctl add ";
        try {
            str = str + ext + " " + sippwd;
            String[] cmd = new String[]{"/bin/bash", "-c", str};
            logger.debug("sbc command Executed: " + str);
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
        }
        catch (Exception e) {
            logger.error("Exception at createKamailioExt Error: " + e.getMessage());
        }
    }

    public static void removeKamailioExt(String ext) {
        String str = "kamctl rm ";
        try {
            str = str + ext;
            String[] cmd = new String[]{"/bin/bash", "-c", str};
            logger.debug("sbc command Executed: " + str);
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
        }
        catch (Exception e) {
            logger.error("Exception at removeKamailioExt Error: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getExtensionCreationAndDeletionTag() {
        Properties prop = new Properties();
        String fileName = "/etc/coraltele/conf/app.config";
        try (FileInputStream input = new FileInputStream(fileName);){
            prop.load(input);
            String serverCode = prop.getProperty("voipgateway", "").trim();
            if (!serverCode.isEmpty() && serverCode.equals("true")) {
                logger.info("Current ServerCode: {}", (Object)serverCode);
                boolean bl2 = true;
                return bl2;
            }
            logger.warn("voipgateway not found in config");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("Unable to load voipgateway from config", (Throwable)e);
            return false;
        }
    }

    public void reloadXml() {
        String command = "fs_cli -x reloadxml";
        try {
            String line;
            String[] cmd = new String[]{"/bin/bash", "-c", command};
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logger.info("fs_cli output: {}", (Object)line);
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.info("reloadxml executed successfully.");
            } else {
                logger.warn("reloadxml exited with code: {}", (Object)exitCode);
            }
        }
        catch (Exception e) {
            logger.error("Exception while executing reloadxml: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean isValidAgent(String extension) {
        Optional extensionOptional = this.extensionsRepository.findByExtensionAndExtensionType(extension, "agent");
        return extensionOptional.isPresent();
    }

    public String getDefaultDomain() {
        return ((ControlRluServer)this.controlRluServerRepository.findAll().get(0)).getVirtualIp();
    }
}

