/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private String secret;
    private String refreshSecret;

    @Value(value="${jwt.secret}")
    public void setSecret(String secret) {
        this.secret = secret + "-3be8dd5f-c66b-4b3c-88f5-b2d36c9238dd";
        this.refreshSecret = secret + "-ff53fbdd-c6ca-4bb4-a3fb-a4c279d18831";
        this.secret = Base64.getEncoder().encodeToString(this.secret.getBytes());
        this.refreshSecret = Base64.getEncoder().encodeToString(this.refreshSecret.getBytes());
    }

    private Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
    }

    private Claims getAllClaimsFromRefreshToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.refreshSecret).parseClaimsJws(token).getBody();
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

    public <T> T getClaimFromRefreshToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromRefreshToken(token);
        return claimsResolver.apply(claims);
    }

    public String getUsernameFromToken(String token) {
        return (String)this.getClaimFromToken(token, Claims::getSubject);
    }

    public String getUsernameFromRefreshToken(String token) {
        return (String)this.getClaimFromRefreshToken(token, Claims::getSubject);
    }

    private String doGenerateToken(Map<String, Object> claims, String subject) {
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 120000L)).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public String doGenerateRefreshToken(Map<String, Object> claims, String subject) {
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 480000L)).signWith(SignatureAlgorithm.HS512, this.refreshSecret).compact();
    }

    public String generateToken(UserDetails userDetails, String uuid) {
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("username", userDetails.getUsername());
        claims.put("email", userDetails.getUsername());
        claims.put("authMethod", "local");
        claims.put("uuidSecurity", uuid);
        return this.doGenerateToken(claims, userDetails.getUsername());
    }

    public String generateRefreshToken(UserDetails userDetails, String uuid) {
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("username", userDetails.getUsername());
        claims.put("email", userDetails.getUsername());
        claims.put("authMethod", "local");
        claims.put("uuidSecurity", uuid);
        return this.doGenerateRefreshToken(claims, userDetails.getUsername());
    }

    public boolean validateToken(String authToken) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.secret).parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException ex) {
            throw new BadCredentialsException("INVALID_CREDENTIALS", ex);
        }
        catch (ExpiredJwtException ex) {
            throw ex;
        }
    }

    public boolean validateRefreshToken(String authToken) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.refreshSecret).parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException ex) {
            throw new BadCredentialsException("INVALID_CREDENTIALS", ex);
        }
        catch (ExpiredJwtException ex) {
            throw ex;
        }
    }

    public Date getExpirationDateFromToken(String token) {
        return (Date)this.getClaimFromToken(token, Claims::getExpiration);
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    private Claims extractAllClaims(String token, boolean isRefresh) {
        String key = isRefresh ? this.refreshSecret : this.secret;
        return (Claims)Jwts.parser().setSigningKey(key).parseClaimsJws(token).getBody();
    }

    public String getClaimFromToken(String token, String claimKey, boolean isRefresh) {
        try {
            Claims claims = this.extractAllClaims(token, isRefresh);
            Object value = claims.get((Object)claimKey);
            return value != null ? value.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getClaimFromToken(String token, String claimKey) {
        return this.getClaimFromToken(token, claimKey, false);
    }

    public Long getTokenExpirationEpoch(String token) {
        try {
            Date d = this.extractAllClaims(token, false).getExpiration();
            return d != null ? Long.valueOf(d.getTime()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getRefreshTokenExpirationEpoch(String refreshToken) {
        try {
            Date d = this.extractAllClaims(refreshToken, true).getExpiration();
            return d != null ? Long.valueOf(d.getTime()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String generateTokenByDB(UserDetails userDetails, String uuid) {
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("username", userDetails.getUsername());
        claims.put("email", userDetails.getUsername());
        claims.put("authMethod", "local");
        claims.put("uuidSecurity", uuid);
        return this.doGenerateToken(claims, userDetails.getUsername());
    }

    public String generateRefreshTokenByDB(UserDetails userDetails, String uuid) {
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("username", userDetails.getUsername());
        claims.put("email", userDetails.getUsername());
        claims.put("authMethod", "local");
        claims.put("uuidSecurity", uuid);
        return this.doGenerateRefreshToken(claims, userDetails.getUsername());
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public String getRefreshSecret() {
        return this.refreshSecret;
    }

    @Generated
    public void setRefreshSecret(String refreshSecret) {
        this.refreshSecret = refreshSecret;
    }

    @Generated
    public JwtUtil() {
    }
}

