/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telephony.main.repository;

import com.coraltele.db.telephony.main.entity.SyncLog;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface SyncLogRepository
extends JpaRepository<SyncLog, Integer> {
    public List<SyncLog> findTop5ByBackUpFileNameContainingIgnoreCaseOrderByBackUpTimeDesc(String var1);

    @Query(value="SELECT DISTINCT backuptime FROM db_sync_log ORDER BY backuptime DESC LIMIT 5", nativeQuery=true)
    public List<Long> findTop5DistinctBackUpTimeDesc();

    public List<SyncLog> findAllByBackUpTime(Long var1);

    public List<SyncLog> findAllByBackUpTimeAndFromServer(Long var1, String var2);

    public Optional<SyncLog> findTopByOrderByIdDesc();

    public Optional<SyncLog> findByVersionAndDbName(Long var1, String var2);

    @Modifying
    @Transactional
    @Query(value="UPDATE SyncLog s SET s.fromServer = :fromServer, s.toServer = :toServer, s.status = :status WHERE s.id = :id")
    public void updateSyncLogFields(@Param(value="id") Integer var1, @Param(value="fromServer") String var2, @Param(value="toServer") String var3, @Param(value="status") String var4);

    @Modifying
    @Transactional
    @Query(value="UPDATE SyncLog s SET s.status = :status WHERE s.id = :id")
    public void updateSyncLogStatus(@Param(value="id") Integer var1, @Param(value="status") String var2);
}

