/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele;

import com.coraltele.helper.Bootstrap;
import com.coraltele.helper.Constants;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class AppApplication {
    private static final Logger logger = LogManager.getLogger(AppApplication.class);
    private static String ppdrConferenceSection = "PPDR-CONFERENCE";

    public static void main(String[] args) {
        Bootstrap.checkTelemetryDatabase();
        Bootstrap.createPostgresExtension();
        Bootstrap.updateBillingSchema(null, (String)"tables");
        Bootstrap.updateUsersSchema(null, (String)"tables");
        AppApplication.readProperties();
        SpringApplication app = new SpringApplication(new Class[]{AppApplication.class});
        try {
            ConfigurableApplicationContext ctx = app.run(args);
            ctx.registerShutdownHook();
        }
        catch (Throwable ex) {
            logger.error("Application failed to start {}" + ex.getMessage(), ex);
            ex.printStackTrace();
            System.exit(1);
        }
        AppApplication.logAllConfigurations();
        Bootstrap.deployFiles();
        Bootstrap.testVersion();
    }

    private static void logAllConfigurations() {
        logger.info("============================ Configuration Values : Start ============================");
        logger.info("CLUSTER => SERVER-RLU-CODE: {}", (Object)Constants.SERVER_RLU_CODE);
        logger.info("CLUSTER => CLUSTER-KEY : {}", (Object)Constants.CLUSTER_KEY);
        logger.info("CLUSTER => WEBSOCKET-KEY : {}", (Object)Constants.WEBSOCKET_KEY);
        logger.info("CLUSTER => CLICK-TO-CALL-IP : {}", (Object)Constants.CLICK_TO_CALL_IP);
        logger.info("CLUSTER => API-TEMPLATE-PATH : {}", (Object)Constants.API_TEMPLATE_PATH);
        logger.info("CLUSTER => ENABLE_BOOTSTRAP: {}", (Object)Constants.ENABLE_BOOTSTRAP);
        logger.info("CLUSTER => RECORDING-FILENAME-FORMAT : {}", (Object)Constants.RECORDING_FILENAME_FORMAT);
        logger.info("CLUSTER => RECORDING-FOLDERNAME-FORMAT : {}", (Object)Constants.RECORDING_FOLDERNAME_FORMAT);
        logger.info("MOBILITY => MCC : {}", (Object)Constants.MobilityDefaults.mcc);
        logger.info("MOBILITY => MNC : {}", (Object)Constants.MobilityDefaults.mnc);
        logger.info("MOBILITY => PASS-TYPE : {}", (Object)Constants.MobilityDefaults.opcAsPassType);
        logger.info("MOBILITY => SNMP-EVENT-SEND-URL : {}", (Object)Constants.MobilityDefaults.amf);
        logger.info("SURAKSHA => DISPATCHER-SIP-SERVER : {}", (Object)Constants.DISPATCHER_SIP_SERVER);
        logger.info("SURAKSHA => DISPATCHER-PROFILE-NAME : {}", (Object)Constants.DISPATCHER_PROFILE_NAME);
        logger.info("SURAKSHA => DISPATCHER-NUMBER : {}", (Object)Constants.DISPATCHER_NUMBER);
        logger.info("NMS ==> WEB-SOCKET-URL : {}", (Object)Constants.WEB_SOCKET_URL);
        logger.info("NMS ==> PPDR-SOCKET-URL : {}", (Object)Constants.PPDR_SOCKET_URL);
        logger.info("CALL ==> DISPATCHER_CALL_IP : {}", (Object)Constants.DISPATCHER_CALL_IP);
        logger.info("TOKEN ==> TOKEN_EXPIRATION_TIME : {}", (Object)Constants.TOKEN_EXPIRATION_TIME);
        logger.info("CLUSTER ==> TIME-ZONE-FOR-SUMMARY : {}", (Object)Constants.TIME_ZONE_FOR_SUMMARY);
        logger.info("CLUSTER ==> CLICK_TO_CALL_REMOTE_SERVER : {}", (Object)Constants.CLICK_TO_CALL_REMOTE_SERVER);
        logger.info("CLUSTER ==> CLICK-TO-CALL-REMOTE-IP : {}", (Object)Constants.CLICK_TO_CALL_REMOTE_IP);
        logger.info("CLUSTER ==> CLICK-TO-CALL-REMOTE-PORT : {}", (Object)Constants.CLICK_TO_CALL_REMOTE_PORT);
        logger.info("CLUSTER ==> BACKWARD-COMPATIBILITY : {}", (Object)Constants.BACKWARD_COMPATIBILITY);
        logger.info("CLUSTER ==> IP-FEATURE-SERVER : {}", (Object)Constants.IP_FEATURE_SERVER);
        logger.info("CLUSTER ==> SBC_USERS_PORT : {}", (Object)Constants.SBC_USERS_PORT);
        logger.info("CLUSTER ==> FEATURE_USERS_PORT : {}", (Object)Constants.FEATURE_USERS_PORT);
        logger.info("PPDR-CONFERENCE ==> CONFERENCE-PROVIDER : {}", (Object)Constants.CONFERENCE_PROVIDER);
        logger.info("============================ Configuration Values : End   ============================");
    }

    private static void readProperties() {
        String clusterConfiguration = "/etc/default/coral";
        try {
            Ini ini = new Ini(new File(clusterConfiguration));
            IniPreferences configuration = new IniPreferences(ini);
            Constants.SERVER_RLU_CODE = configuration.node("CLUSTER").get("SERVER-RLU-CODE", "");
            Constants.CLUSTER_KEY = configuration.node("CLUSTER").get("CLUSTER-KEY", "");
            Constants.WEBSOCKET_KEY = configuration.node("CLUSTER").get("WEBSOCKET-KEY", "");
            Constants.CLICK_TO_CALL_IP = configuration.node("CLUSTER").get("CLICK-TO-CALL-IP", "");
            Constants.ENABLE_MONGO_DB = configuration.node("CLUSTER").getBoolean("ENABLE-MONGO-DB", false);
            Constants.MULTIPLE_LOGGED_IN = configuration.node("CLUSTER").getBoolean("MULTIPLE-LOGGED-IN", true);
            Constants.API_TEMPLATE_PATH = configuration.node("CLUSTER").get("API-TEMPLATE-PATH", "/usr/share/coralswitch") + "/";
            Constants.ENABLE_BOOTSTRAP = configuration.node("CLUSTER").getBoolean("ENABLE-BOOTSTRAP", false);
            Constants.WSS_DOMAIN = configuration.node("CLUSTER").get("WSS-DOMAIN", "");
            Constants.RECORDING_FILENAME_FORMAT = configuration.node("CLUSTER").get("RECORDING-FILENAME-FORMAT", "");
            Constants.RECORDING_FOLDERNAME_FORMAT = configuration.node("CLUSTER").get("RECORDING-FOLDERNAME-FORMAT", "");
            Constants.MobilityDefaults.mcc = configuration.node("MOBILITY").get("MCC", "");
            Constants.MobilityDefaults.mnc = configuration.node("MOBILITY").get("MNC", "");
            Constants.MobilityDefaults.opcAsPassType = configuration.node("MOBILITY").get("PASS-TYPE", "OPC").equals("OPC");
            Constants.MobilityDefaults.amf = configuration.node("MOBILITY").get("AMF", "");
            Constants.DISPATCHER_SIP_SERVER = configuration.node("PPDR-CONFERENCE").get("DISPATCHER-SIP-SERVER", "");
            Constants.DISPATCHER_PROFILE_NAME = configuration.node("PPDR-CONFERENCE").get("DISPATCHER-PROFILE-NAME", "internal");
            Constants.DISPATCHER_NUMBER = configuration.node("PPDR-CONFERENCE").get("DISPATCHER-NUMBER", "505");
            Constants.WEB_SOCKET_URL = configuration.node("NMS").get("WEB-SOCKET-URL", "http://127.0.0.1:8989");
            Constants.PPDR_SOCKET_URL = configuration.node("CLUSTER").get("PPDR-SOCKET-URL", "http://127.0.0.1/ppdr/api/v2/messaging/send-event");
            Constants.DISPATCHER_CALL_IP = configuration.node("CLUSTER").get("DISPATCHER-CALL-IP", "");
            Constants.TOKEN_EXPIRATION_TIME = configuration.node("CLUSTER").getLong("TOKEN-EXPIRATION-TIME", 24L);
            Constants.CLICK_TO_CALL_REMOTE_SERVER = configuration.node("CLUSTER").getBoolean("CLICK_TO_CALL_REMOTE_SERVER", false);
            Constants.CLICK_TO_CALL_REMOTE_IP = configuration.node("CLUSTER").get("CLICK-TO-CALL-REMOTE-IP", "");
            Constants.CLICK_TO_CALL_REMOTE_PORT = configuration.node("CLUSTER").get("CLICK-TO-CALL-REMOTE-PORT", "");
            Constants.BACKWARD_COMPATIBILITY = configuration.node("CLUSTER").getBoolean("BACKWARD-COMPATIBILITY", false);
            Constants.SBC_USERS_PORT = configuration.node("CLUSTER").get("SBC_USERS_PORT", "");
            Constants.FEATURE_USERS_PORT = configuration.node("CLUSTER").get("FEATURE_USERS_PORT", "");
            Constants.IP_FEATURE_SERVER = configuration.node("CSCF-1").get("IP-FEATURE-SERVER", "");
            Constants.CONFERENCE_PROVIDER = configuration.node(ppdrConferenceSection).getInt("CONFERENCE-PROVIDER", 1);
            if (Constants.TOKEN_EXPIRATION_TIME == 0L) {
                Constants.TOKEN_EXPIRATION_TIME = 24L;
            }
            Constants.TOKEN_EXPIRATION_TIME = Constants.TOKEN_EXPIRATION_TIME * 60L * 60L * 1000L;
            Constants.REFRESH_TOKEN_EXPIRATION_TIME = Constants.TOKEN_EXPIRATION_TIME + 300000L;
            if (Constants.DISPATCHER_PROFILE_NAME == null || Constants.DISPATCHER_PROFILE_NAME.trim().isEmpty()) {
                Constants.DISPATCHER_PROFILE_NAME = "internal";
                logger.info("DISPATCHER_PROFILE_NAME was blank or null. Defaulting to internal");
            }
            if (Constants.DISPATCHER_NUMBER == null || Constants.DISPATCHER_NUMBER.trim().isEmpty()) {
                Constants.DISPATCHER_NUMBER = "199";
                logger.info("DISPATCHER_NUMBER was blank or null. Defaulting to 199");
            }
            Constants.TIME_ZONE_FOR_SUMMARY = configuration.node("CLUSTER").get("TIME-ZONE-FOR-SUMMARY", "Asia/Kolkata");
            AppApplication.getIPAddress();
        }
        catch (IOException e) {
            logger.error("Unable to read property file");
        }
    }

    private static void getIPAddress() {
        try {
            InetAddress id = InetAddress.getLocalHost();
            Constants.hostName = id.getHostName();
            logger.info("Current Machine hostname : {}", (Object)Constants.hostName);
        }
        catch (UnknownHostException e) {
            logger.error("Unable to get hostname", (Throwable)e);
        }
    }
}

