/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.sip;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.service.ConferenceService;
import com.coraltele.ppdrconference.sip.PPDRAccount;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pjsip.pjsua2.Account;
import org.pjsip.pjsua2.Call;
import org.pjsip.pjsua2.CallInfo;
import org.pjsip.pjsua2.CallMediaInfo;
import org.pjsip.pjsua2.CallMediaInfoVector;
import org.pjsip.pjsua2.CallOpParam;
import org.pjsip.pjsua2.OnCallMediaStateParam;
import org.pjsip.pjsua2.OnCallRxReinviteParam;
import org.pjsip.pjsua2.OnCallStateParam;
import org.pjsip.pjsua2.OnDtmfDigitParam;

public class SIPCall
extends Call {
    private static final Logger logger = LogManager.getLogger(SIPCall.class);
    private String callType = "Group";
    private Boolean isDispatcher = false;
    private String caller = "";
    private String callee = "";
    private int callId = 0;
    private volatile boolean callActive = true;

    SIPCall(PPDRAccount var1, int var2, Boolean isDispatcher) {
        super((Account)var1, var2);
        this.isDispatcher = isDispatcher;
    }

    public void updateDispatcherFlag(Boolean isDispatcher) {
        this.isDispatcher = isDispatcher;
    }

    public void onCallState(OnCallStateParam callParam) {
        try {
            CallInfo ci = this.getInfo();
            int currentState = ci.getState();
            this.caller = this.getUser(ci.getRemoteUri());
            this.callee = this.getUser(ci.getLocalUri());
            this.callId = ci.getId();
            String name = this.caller;
            if (currentState == 1) {
                ((ConferenceService)Constants.conferenceService.get()).startCall(this, this.callee, Integer.valueOf(ci.getId()), ci.getCallIdString(), this.callType, "OUT", this.caller, name, Boolean.valueOf(false), Integer.valueOf(1), this.isDispatcher);
            } else if (currentState == 2) {
                ((ConferenceService)Constants.conferenceService.get()).startCall(this, this.callee, Integer.valueOf(ci.getId()), ci.getCallIdString(), this.callType, "IN", this.caller, name, Boolean.valueOf(false), Integer.valueOf(1), this.isDispatcher);
            } else if (currentState == 3) {
                ((ConferenceService)Constants.conferenceService.get()).updateCallState(Integer.valueOf(ci.getId()), Integer.valueOf(3));
            } else if (currentState == 4) {
                ((ConferenceService)Constants.conferenceService.get()).updateCallState(Integer.valueOf(ci.getId()), Integer.valueOf(3));
            } else if (currentState == 5) {
                ((ConferenceService)Constants.conferenceService.get()).answerCall(Integer.valueOf(ci.getId()), Integer.valueOf(5));
            } else if (currentState == 6) {
                ((ConferenceService)Constants.conferenceService.get()).disconnectChannel(ci.getId());
                this.callActive = false;
            }
        }
        catch (Exception e) {
            logger.error("Error in onCallState", (Throwable)e);
        }
    }

    private String getUser(String localUriString) {
        String user = "";
        try {
            Pattern userPattern = Pattern.compile("sip:(.*?)@");
            Matcher userMatcher = userPattern.matcher(localUriString);
            if (userMatcher.find()) {
                user = userMatcher.group(1);
            }
        }
        catch (Exception e) {
            logger.error("Error in finding the user from uri: {}", (Object)localUriString, (Object)e);
        }
        return user;
    }

    public void onCallMediaState(OnCallMediaStateParam mediaStateParam) {
        CallInfo callInfo;
        try {
            callInfo = this.getInfo();
        }
        catch (Exception e) {
            return;
        }
        CallMediaInfoVector availableMedia = callInfo.getMedia();
        for (int i = 0; i < availableMedia.size(); ++i) {
            CallMediaInfo mediaInfo = availableMedia.get(i);
            if (mediaInfo.getType() != 1) continue;
            if (mediaInfo.getStatus() == 1 || mediaInfo.getStatus() == 3) {
                try {
                    ((ConferenceService)Constants.conferenceService.get()).updateAudioMedia(Integer.valueOf(callInfo.getId()), this.getAudioMedia(i), Boolean.valueOf(true));
                }
                catch (Exception e) {
                    logger.error("Failed connecting media ports:", (Throwable)e);
                }
                continue;
            }
            ((ConferenceService)Constants.conferenceService.get()).updateAudioMedia(Integer.valueOf(callInfo.getId()), null, Boolean.valueOf(true));
        }
    }

    public void onCallRxReinvite(OnCallRxReinviteParam prm) {
        CallInfo callInfo;
        super.onCallRxReinvite(prm);
        try {
            callInfo = this.getInfo();
        }
        catch (Exception e) {
            return;
        }
        CallMediaInfoVector availableMedia = callInfo.getMedia();
        for (int i = 0; i < availableMedia.size(); ++i) {
            CallMediaInfo mediaInfo = availableMedia.get(i);
            if (mediaInfo.getType() != 1) continue;
            if (mediaInfo.getStatus() == 1 || mediaInfo.getStatus() == 3) {
                try {
                    ((ConferenceService)Constants.conferenceService.get()).updateAudioMedia(Integer.valueOf(callInfo.getId()), this.getAudioMedia(i), Boolean.valueOf(true));
                }
                catch (Exception e) {
                    logger.error("Failed connecting media ports:", (Throwable)e);
                }
                continue;
            }
            ((ConferenceService)Constants.conferenceService.get()).updateAudioMedia(Integer.valueOf(callInfo.getId()), null, Boolean.valueOf(true));
        }
    }

    public void endCall() {
        try {
            if (this.callActive) {
                CallOpParam prm = new CallOpParam();
                logger.debug("End Call initiated for id: {} user : {}  call group: {}", (Object)this.callId, (Object)this.caller, (Object)this.callee);
                ((ConferenceService)Constants.conferenceService.get()).disconnectChannel(this.callId);
                this.hangup(prm);
            }
        }
        catch (Exception e) {
            logger.error("Error in endCall", (Throwable)e);
        }
    }

    public void onDtmfDigit(OnDtmfDigitParam prm) {
        try {
            super.onDtmfDigit(prm);
            String number = this.getUser(this.getInfo().getRemoteUri());
            String callGroup = this.getUser(this.getInfo().getLocalUri());
            logger.debug("Received dtmf {} from remote party: {} and conference Group: {}", (Object)prm.getDigit(), (Object)number, (Object)callGroup);
            if (prm.getDigit().equals("0")) {
                ((ConferenceService)Constants.conferenceService.get()).releasePTT(number, callGroup);
            } else if (prm.getDigit().equals("1")) {
                ((ConferenceService)Constants.conferenceService.get()).requestPTT(number, callGroup);
            }
        }
        catch (Exception e) {
            logger.error("Exception in onDtmfDigit Error :", (Throwable)e);
        }
    }
}

