/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.entity.Conference;
import com.coraltele.ppdrconference.entity.Extension;
import com.coraltele.ppdrconference.entity.FloorControlHistory;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.RecordingRequest;
import com.coraltele.ppdrconference.repository.ExtensionRepository;
import com.coraltele.ppdrconference.repository.FloorControlHistoryRepository;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class FloorControlHistoryService {
    private static final Logger logger = LogManager.getLogger(FloorControlHistoryService.class);
    @Autowired
    private FloorControlHistoryRepository floorControlHistoryRepository;
    @Autowired
    private ExtensionRepository extensionRepository;
    private final RestTemplate restTemplate = new RestTemplate();

    public void generatePTTCallHistory(String conferenceNo, String sessionId, String sessionStartedBy, long sessionStartEpoch, long sessionEndEpoch) {
        if (sessionStartedBy != null && !sessionStartedBy.isEmpty()) {
            Optional existingRecord;
            logger.info("Generating floor control history for conference: {}, participant: {}, floor taken epoch: {}, floor release epoch: {}, sessionId: {}", (Object)conferenceNo, (Object)sessionStartedBy, (Object)sessionStartEpoch, (Object)sessionEndEpoch, (Object)sessionId);
            if (sessionId != null && !sessionId.isEmpty() && (existingRecord = this.floorControlHistoryRepository.findBySessionId(sessionId)).isPresent()) {
                logger.warn("Floor control history already exists for sessionId: {}, skipping creation", (Object)sessionId);
                return;
            }
            List extension = this.extensionRepository.findByExtensionNumber(sessionStartedBy);
            FloorControlHistory floorControlHistory = new FloorControlHistory();
            floorControlHistory.setRecordType("PTT-SESSION");
            floorControlHistory.setConferenceNo(conferenceNo);
            floorControlHistory.setParticipantNo(sessionStartedBy);
            floorControlHistory.setStreamType("audio");
            if (!extension.isEmpty()) {
                floorControlHistory.setDesignation(((Extension)extension.get(0)).getDesignation());
            } else {
                floorControlHistory.setDesignation(sessionStartedBy);
            }
            floorControlHistory.setFloorTakenEpoch(Long.valueOf(sessionStartEpoch));
            floorControlHistory.setFloorReleaseEpoch(Long.valueOf(sessionEndEpoch));
            floorControlHistory.setSessionId(sessionId);
            this.floorControlHistoryRepository.save((Object)floorControlHistory);
            this.stopRecordingAudioAsync(conferenceNo, sessionId);
        } else {
            logger.warn("Cannot generate floor control history for conference: {} as controlWith is null or empty", (Object)conferenceNo);
        }
    }

    public void generateFloorControlHistory(Conference conference, Long floorReleaseEpoch) {
        if (conference.getControlWith() != null && !conference.getControlWith().isEmpty()) {
            Optional existingRecord;
            logger.info("Generating floor control history for conference: {}, participant: {}, floor taken epoch: {}, floor release epoch: {}, sessionId: {}", (Object)conference.getConferenceNo(), (Object)conference.getControlWith(), (Object)conference.getFloorTakenEpoch(), (Object)floorReleaseEpoch, (Object)conference.getSessionId());
            String sessionId = conference.getSessionId();
            String conferenceNo = conference.getConferenceNo();
            if (sessionId != null && !sessionId.isEmpty() && (existingRecord = this.floorControlHistoryRepository.findBySessionId(sessionId)).isPresent()) {
                logger.warn("Floor control history already exists for sessionId: {}, skipping creation", (Object)sessionId);
                return;
            }
            List extension = this.extensionRepository.findByExtensionNumber(conference.getControlWith());
            FloorControlHistory floorControlHistory = new FloorControlHistory();
            floorControlHistory.setRecordType("PTT-USER");
            floorControlHistory.setConferenceNo(conference.getConferenceNo());
            floorControlHistory.setParticipantNo(conference.getControlWith());
            floorControlHistory.setStreamType("audio");
            if (!extension.isEmpty()) {
                floorControlHistory.setDesignation(((Extension)extension.get(0)).getDesignation());
            } else {
                floorControlHistory.setDesignation(conference.getControlWith());
            }
            floorControlHistory.setFloorTakenEpoch(conference.getFloorTakenEpoch());
            floorControlHistory.setFloorReleaseEpoch(floorReleaseEpoch);
            floorControlHistory.setSessionId(conference.getSessionId());
            this.floorControlHistoryRepository.save((Object)floorControlHistory);
            this.stopRecordingAudioAsync(conferenceNo, sessionId);
        } else {
            logger.warn("Cannot generate floor control history for conference: {} as controlWith is null or empty", (Object)conference.getConferenceNo());
        }
    }

    public void generateFloorControlHistoryVideo(Conference conference, Long floorReleaseEpoch) {
        if (conference.getVideoStreamBy() != null && !conference.getVideoStreamBy().isEmpty()) {
            Optional existingRecord;
            logger.info("Generating Video stream history for conference: {}, participant: {}, floor taken epoch: {}, floor release epoch: {}, sessionId: {}", (Object)conference.getConferenceNo(), (Object)conference.getVideoStreamBy(), (Object)conference.getFloorTakenEpoch(), (Object)floorReleaseEpoch, (Object)conference.getVideoStreamSessionId());
            String sessionId = conference.getVideoStreamSessionId();
            String conferenceNo = conference.getConferenceNo();
            if (sessionId != null && !sessionId.isEmpty() && (existingRecord = this.floorControlHistoryRepository.findBySessionId(sessionId)).isPresent()) {
                logger.warn("Video Stream history already exists for sessionId: {}, skipping creation", (Object)sessionId);
                return;
            }
            List extension = this.extensionRepository.findByExtensionNumber(conference.getVideoStreamBy());
            FloorControlHistory floorControlHistory = new FloorControlHistory();
            floorControlHistory.setRecordType("VIDEO-STREAM");
            floorControlHistory.setConferenceNo(conference.getConferenceNo());
            floorControlHistory.setParticipantNo(conference.getVideoStreamBy());
            floorControlHistory.setStreamType("video");
            if (!extension.isEmpty()) {
                floorControlHistory.setDesignation(((Extension)extension.get(0)).getDesignation());
            } else {
                floorControlHistory.setDesignation(conference.getVideoStreamBy());
            }
            floorControlHistory.setFloorTakenEpoch(conference.getVideoStreamEpoch());
            floorControlHistory.setFloorReleaseEpoch(floorReleaseEpoch);
            floorControlHistory.setSessionId(sessionId);
            this.floorControlHistoryRepository.save((Object)floorControlHistory);
            this.stopRecordingVideoAsync(conferenceNo, sessionId);
        } else {
            logger.warn("Cannot generate floor control history for conference: {} as controlWith is null or empty", (Object)conference.getConferenceNo());
        }
    }

    private void startRecordingAudio(String conferenceNo, String sessionId) {
        if (!StringUtils.hasText((String)Constants.RECORDING_SERVER_URL_STRING)) {
            logger.warn("Recording server URL is not configured");
            return;
        }
        if (sessionId == null || sessionId.trim().isEmpty()) {
            logger.warn("Cannot start recording for conference: {} as sessionId is null or empty", (Object)conferenceNo);
            return;
        }
        try {
            RecordingRequest recordingRequest = new RecordingRequest();
            recordingRequest.setUrl("http://localhost:5080/LiveApp/multitrack-play.html?id=" + conferenceNo + "&muted=false");
            recordingRequest.setWidth(1280);
            recordingRequest.setHeight(720);
            recordingRequest.setRecordType("mp4");
            recordingRequest.setExtraChromeSwitches("--autoplay-policy=no-user-gesture-required,--start-maximized");
            String url = Constants.RECORDING_SERVER_URL_STRING + "/start?streamId=" + sessionId;
            logger.info("Starting recording for conference: {}, sessionId: {}, url:{} Payload: {}", (Object)conferenceNo, (Object)sessionId, (Object)url, (Object)recordingRequest);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)recordingRequest, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                logger.info("Recording started successfully for conference: {}, sessionId: {}, response: {}", (Object)conferenceNo, (Object)sessionId, response.getBody());
            } else {
                logger.error("Failed to start recording for conference: {}, sessionId: {}, status: {}, response: {}", (Object)conferenceNo, (Object)sessionId, (Object)response.getStatusCode(), response.getBody());
            }
        }
        catch (RestClientException e) {
            logger.error("Error occurred while starting recording for conference: {}, sessionId: {}, error: {}", (Object)conferenceNo, (Object)sessionId, (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while starting recording for conference: {}, sessionId: {}, error: {}", (Object)conferenceNo, (Object)sessionId, (Object)e.getMessage(), (Object)e);
        }
    }

    private void startRecordingAudio(Conference conference, String sessionId) {
        if (!StringUtils.hasText((String)Constants.RECORDING_SERVER_URL_STRING)) {
            logger.warn("Recording server URL is not configured");
            return;
        }
        if (sessionId == null || sessionId.trim().isEmpty()) {
            logger.warn("Cannot start recording for conference: {} as sessionId is null or empty", (Object)conference.getConferenceNo());
            return;
        }
        try {
            RecordingRequest recordingRequest = new RecordingRequest();
            recordingRequest.setUrl("http://localhost:5080/LiveApp/multitrack-play.html?id=" + conference.getConferenceNo() + "&muted=false");
            recordingRequest.setWidth(1280);
            recordingRequest.setHeight(720);
            recordingRequest.setRecordType("mp4");
            recordingRequest.setExtraChromeSwitches("--autoplay-policy=no-user-gesture-required,--start-maximized");
            String url = Constants.RECORDING_SERVER_URL_STRING + "/start?streamId=" + sessionId;
            logger.info("Starting recording for conference: {}, sessionId: {}, url:{} Payload: {}", (Object)conference.getConferenceNo(), (Object)sessionId, (Object)url, (Object)recordingRequest);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)recordingRequest, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                logger.info("Recording started successfully for conference: {}, sessionId: {}, response: {}", (Object)conference.getConferenceNo(), (Object)sessionId, response.getBody());
            } else {
                logger.error("Failed to start recording for conference: {}, sessionId: {}, status: {}, response: {}", (Object)conference.getConferenceNo(), (Object)sessionId, (Object)response.getStatusCode(), response.getBody());
            }
        }
        catch (RestClientException e) {
            logger.error("Error occurred while starting recording for conference: {}, sessionId: {}, error: {}", (Object)conference.getConferenceNo(), (Object)sessionId, (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while starting recording for conference: {}, sessionId: {}, error: {}", (Object)conference.getConferenceNo(), (Object)sessionId, (Object)e.getMessage(), (Object)e);
        }
    }

    private void startRecordingVideo(Conference conference, String sessionId) {
        if (!StringUtils.hasText((String)Constants.RECORDING_SERVER_URL_STRING)) {
            logger.warn("Recording server URL is not configured");
            return;
        }
        if (sessionId == null || sessionId.trim().isEmpty()) {
            logger.warn("Cannot start recording for conference: {} as sessionId is null or empty", (Object)conference.getConferenceNo());
            return;
        }
        try {
            RecordingRequest recordingRequest = new RecordingRequest();
            recordingRequest.setUrl("http://localhost:5080/LiveApp/multitrack-play.html?id=" + conference.getVideoStreamId() + "&muted=false");
            recordingRequest.setWidth(1280);
            recordingRequest.setHeight(720);
            recordingRequest.setRecordType("mp4");
            recordingRequest.setExtraChromeSwitches("--autoplay-policy=no-user-gesture-required,--start-maximized");
            String url = Constants.RECORDING_SERVER_URL_STRING + "/start?streamId=" + sessionId;
            logger.info("Video Recording URL: {}", (Object)url);
            logger.info("Starting recording for conference: {}, sessionId: {}, url: {},payload: {}", (Object)conference.getConferenceNo(), (Object)sessionId, (Object)url, (Object)recordingRequest);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)recordingRequest, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                logger.info("Recording started successfully for conference: {}, sessionId: {}, response: {}", (Object)conference.getConferenceNo(), (Object)sessionId, response.getBody());
            } else {
                logger.error("Failed to start recording for conference: {}, sessionId: {}, status: {}, response: {}", (Object)conference.getConferenceNo(), (Object)sessionId, (Object)response.getStatusCode(), response.getBody());
            }
        }
        catch (RestClientException e) {
            logger.error("Error occurred while starting recording for conference: {}, sessionId: {}, error: {}", (Object)conference.getConferenceNo(), (Object)sessionId, (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while starting recording for conference: {}, sessionId: {}, error: {}", (Object)conference.getConferenceNo(), (Object)sessionId, (Object)e.getMessage(), (Object)e);
        }
    }

    private void stopRecording(String conferenceNo, String sessionId, String streamType) {
        if (!StringUtils.hasText((String)Constants.RECORDING_SERVER_URL_STRING)) {
            logger.warn("Recording server URL is not configured");
            return;
        }
        if (sessionId == null || sessionId.trim().isEmpty()) {
            logger.warn("Cannot stop recording for conference: {} as sessionId is null or empty streamType: {}", (Object)conferenceNo, (Object)streamType);
            return;
        }
        try {
            String stopUrl = Constants.RECORDING_SERVER_URL_STRING + "/stop/" + sessionId;
            logger.info("Stopping recording for conference: {}, sessionId: {}, url:{}, stream type:{}", (Object)conferenceNo, (Object)sessionId, (Object)stopUrl, (Object)streamType);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(stopUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                logger.info("Recording stopped successfully for conference: {}, sessionId: {}, response: {}, stream type: {}", (Object)conferenceNo, (Object)sessionId, response.getBody(), (Object)streamType);
            } else {
                logger.error("Failed to stop recording for conference: {}, sessionId: {}, status: {}, response: {}, stream type: {}", (Object)conferenceNo, (Object)sessionId, (Object)response.getStatusCode(), response.getBody(), (Object)streamType);
            }
        }
        catch (RestClientException e) {
            logger.error("Error occurred while stopping recording for conference: {}, sessionId: {}, error: {}", (Object)conferenceNo, (Object)sessionId, (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while stopping recording for conference: {}, sessionId: {}, error: {}", (Object)conferenceNo, (Object)sessionId, (Object)e.getMessage(), (Object)e);
        }
    }

    public List<FloorControlHistory> getFloorControlHistory() {
        return this.floorControlHistoryRepository.findAllByOrderByFloorTakenEpochAsc();
    }

    @Async
    public CompletableFuture<Void> startRecordingAudioAsync(String conferenceNo, String sessionId) {
        return CompletableFuture.runAsync(() -> this.startRecordingAudio(conferenceNo, sessionId));
    }

    @Async
    public CompletableFuture<Void> startRecordingAudioAsync(Conference conference, String sessionId) {
        return CompletableFuture.runAsync(() -> this.startRecordingAudio(conference, sessionId));
    }

    @Async
    public CompletableFuture<Void> startRecordingVideoAsync(Conference conference, String sessionId) {
        return CompletableFuture.runAsync(() -> this.startRecordingVideo(conference, sessionId));
    }

    @Async
    public CompletableFuture<Void> stopRecordingAudioAsync(String conferenceNo, String sessionId) {
        return CompletableFuture.runAsync(() -> this.stopRecording(conferenceNo, sessionId, "audio"));
    }

    @Async
    public CompletableFuture<Void> stopRecordingVideoAsync(String conferenceNo, String sessionId) {
        return CompletableFuture.runAsync(() -> this.stopRecording(conferenceNo, sessionId, "video"));
    }
}

