/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.entity.Conference;
import com.coraltele.ppdrconference.entity.Participant;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.DynamicConferenceRequest;
import com.coraltele.ppdrconference.model.DynamicConferenceResponse;
import com.coraltele.ppdrconference.repository.ConferenceRepository;
import com.coraltele.ppdrconference.repository.ParticipantsRepository;
import com.coraltele.ppdrconference.service.RTCPServerService;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DynamicConferenceService {
    private static final Logger logger = LogManager.getLogger(DynamicConferenceService.class);
    @Autowired
    private ConferenceRepository conferenceRepository;
    @Autowired
    private ParticipantsRepository participantsRepository;

    public DynamicConferenceResponse connectParticipantToConference(DynamicConferenceRequest request) {
        logger.info("EventId={} Initiating dynamic conference connection for ConferenceNo={}, ParticipantNo={}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)request.getConferenceNo(), (Object)request.getParticipantNo());
        DynamicConferenceResponse response = new DynamicConferenceResponse();
        response.setConnectionEpoch(Long.valueOf(Instant.now().getEpochSecond()));
        response.setConferenceNo(request.getConferenceNo());
        response.setParticipantNo(request.getParticipantNo());
        response.setConferenceColor(request.getConferenceColor());
        response.setDepartment(request.getDepartment());
        try {
            if (!this.validateRequest(request)) {
                response.setConnectionStatus("FAILED");
                response.setMessage("Invalid request parameters");
                logger.error("EventId={} Invalid request parameters for dynamic conference connection", (Object)Constants.EVENT.CONFERENCE_START_CALL);
                return response;
            }
            Optional conferenceOptional = this.conferenceRepository.findById((Object)request.getConferenceNo());
            if (!conferenceOptional.isPresent()) {
                response.setConnectionStatus("FAILED");
                response.setMessage("Conference not found: " + request.getConferenceNo());
                logger.error("EventId={} Conference not found: {}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)request.getConferenceNo());
                return response;
            }
            Conference conference = (Conference)conferenceOptional.get();
            Optional participantOptional = this.participantsRepository.findById((Object)request.getParticipantNo());
            if (!participantOptional.isPresent()) {
                response.setConnectionStatus("FAILED");
                response.setMessage("Participant not found: " + request.getParticipantNo());
                logger.error("EventId={} Participant not found: {}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)request.getParticipantNo());
                return response;
            }
            Participant participant = (Participant)participantOptional.get();
            participant.setJoinConference(request.getConferenceNo());
            participant.setIsInCall(Boolean.valueOf(true));
            participant.setLastCallJoinEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            this.participantsRepository.save((Object)participant);
            logger.info("EventId={} Participant {} updated with conference {}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)request.getParticipantNo(), (Object)request.getConferenceNo());
            this.sendConferenceConnectPacket(conference, participant, request.getConferenceColor(), request.getDepartment());
            response.setConnectionStatus("CONNECTING");
            response.setMessage("Conference connection initiated successfully");
            logger.info("EventId={} Conference connect packet sent to participant {}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)request.getParticipantNo());
        }
        catch (Exception e) {
            response.setConnectionStatus("FAILED");
            response.setMessage("Error: " + e.getMessage());
            logger.error("EventId={} Error in dynamic conference connection", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)e);
        }
        return response;
    }

    private void sendConferenceConnectPacket(Conference conference, Participant participant, String color, String department) {
        try {
            String participantNo = participant.getParticipantNo();
            String ipAddress = participant.getConnectedIpAddress();
            Integer port = participant.getPort();
            if (!StringUtils.hasText((String)ipAddress) || port == null) {
                logger.warn("EventId={} Participant {} has no IP/port configuration", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)participantNo);
                return;
            }
            logger.debug("EventId={} Sending conference connect packet to {}:{}", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)ipAddress, (Object)port);
            Integer connectionInterface = participant.getConnectionInterface() != null ? participant.getConnectionInterface() : 0;
            String correlationId = UUID.randomUUID().toString();
            String sessionId = UUID.randomUUID().toString();
            ((RTCPServerService)Constants.rtcpServerService.get()).sendNotificationToUserToJoinConference(correlationId, sessionId, participantNo);
        }
        catch (Exception e) {
            logger.error("EventId={} Error sending conference connect packet", (Object)Constants.EVENT.CONFERENCE_START_CALL, (Object)e);
        }
    }

    private boolean validateRequest(DynamicConferenceRequest request) {
        if (request == null) {
            return false;
        }
        if (!StringUtils.hasText((String)request.getConferenceNo())) {
            logger.warn("Conference number is empty");
            return false;
        }
        if (!StringUtils.hasText((String)request.getParticipantNo())) {
            logger.warn("Participant number is empty");
            return false;
        }
        return true;
    }

    public boolean disconnectParticipantFromConference(String participantNo, String conferenceNo) {
        try {
            logger.info("EventId={} Disconnecting participant {} from conference {}", (Object)Constants.EVENT.CONFERENCE_UPDATE_CALL, (Object)participantNo, (Object)conferenceNo);
            Optional participantOptional = this.participantsRepository.findById((Object)participantNo);
            if (!participantOptional.isPresent()) {
                logger.warn("Participant not found: {}", (Object)participantNo);
                return false;
            }
            Participant participant = (Participant)participantOptional.get();
            participant.setJoinConference(null);
            participant.setIsInCall(Boolean.valueOf(false));
            participant.setLastCallDisconnectEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            this.participantsRepository.save((Object)participant);
            logger.info("EventId={} Participant {} disconnected from conference {}", (Object)Constants.EVENT.CONFERENCE_UPDATE_CALL, (Object)participantNo, (Object)conferenceNo);
            return true;
        }
        catch (Exception e) {
            logger.error("EventId={} Error disconnecting participant from conference", (Object)Constants.EVENT.CONFERENCE_UPDATE_CALL, (Object)e);
            return false;
        }
    }
}

