/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.service;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.service.ConferenceService;
import com.coraltele.ppdrconference.sip.SIPCall;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pjsip.pjsua2.AudioMedia;

public class ChannelInfo {
    private static final Logger logger = LogManager.getLogger(ChannelInfo.class);
    private final Object lock = new Object();
    private volatile String callGroup = "";
    private volatile String callId = "";
    private volatile String callType = "";
    private volatile String callDirection = "";
    private volatile String remotePartyNumber = "";
    private volatile String remotePartyName = "";
    private volatile Integer callState = 0;
    private volatile Long answerEpoch = 0L;
    private volatile Long callEpoch = 0L;
    private volatile Boolean hasVideo = false;
    private volatile Boolean isConnected = false;
    private volatile Boolean isAnswered = false;
    private volatile Boolean isDispatcher = false;
    private volatile String extensionSubType = "";
    private volatile Boolean isTransmitting = false;
    private AtomicReference<AudioMedia> mediaStream = new AtomicReference<Object>(null);
    private AtomicReference<SIPCall> activeCall = new AtomicReference<Object>(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.callGroup = "";
            this.callId = "";
            this.callType = "";
            this.callDirection = "";
            this.remotePartyNumber = "";
            this.remotePartyName = "";
            this.callState = 0;
            this.answerEpoch = 0L;
            this.callEpoch = 0L;
            this.hasVideo = false;
            this.isConnected = false;
            this.isAnswered = false;
            this.mediaStream.set(null);
            this.activeCall.set(null);
            this.isDispatcher = false;
            this.isTransmitting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCall() {
        Object object = this.lock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} CallId={} CallState={}", (Object)Constants.EVENT.CALL_ENDED, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)this.callState);
            if (this.getSIPCall() != null) {
                this.mediaStream.set(null);
                this.isAnswered = false;
                this.isConnected = false;
                this.isDispatcher = false;
                ((ConferenceService)Constants.conferenceService.get()).enqueueTask("SIP Call ID " + this.callId, () -> {
                    try {
                        this.getSIPCall().endCall();
                    }
                    catch (Exception e) {
                        logger.error("Error in ending call for id {} remoteParty {} call group {}", (Object)this.callId, (Object)this.remotePartyNumber, (Object)this.callGroup, (Object)e);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCall(SIPCall sipCall, String callGroup, String callId, String callType, String callDirection, String remotePartyNumber, String remotePartyName, Boolean hasVideo, Integer callState, Boolean isDispatcher) {
        Object object = this.lock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} CallId={} CallState={}", (Object)Constants.EVENT.CALL_STARTED, (Object)callGroup, (Object)remotePartyNumber, (Object)callId, (Object)callState);
            this.callGroup = callGroup;
            this.callId = callId;
            this.callType = callType;
            this.callDirection = callDirection;
            this.remotePartyNumber = remotePartyNumber;
            this.remotePartyName = remotePartyName;
            this.hasVideo = hasVideo;
            this.callState = callState;
            this.callEpoch = System.currentTimeMillis();
            this.isDispatcher = isDispatcher;
            this.activeCall.set(sipCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void answerCall() {
        Object object = this.lock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} CallId={} CallState={}", (Object)Constants.EVENT.CALL_ANSWERED, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)this.callState);
            this.answerEpoch = System.currentTimeMillis() / 1000L;
            this.isAnswered = true;
            this.isConnected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAudioMedia(AudioMedia audioMedia) {
        Object object = this.lock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} CallId={} CallState={}", (Object)Constants.EVENT.CALL_MEDIA_UPDATE, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)this.callState);
            this.mediaStream.set(audioMedia);
        }
    }

    public AudioMedia getAudioMedia() {
        return Boolean.TRUE.equals(this.isAnswered) ? (AudioMedia)this.mediaStream.get() : null;
    }

    public SIPCall getSIPCall() {
        return (SIPCall)this.activeCall.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMediaTransmission(String correlationId, Collection<ChannelInfo> channelInfoList) {
        logger.info("EventId={} GroupId={} ParticipantId={} CallId={} CallState={}", (Object)Constants.EVENT.CALL_WAITING_FOR_LOCK_ON_MEDIA_TRANSMISSION_START, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)this.callState);
        Object object = this.lock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} CallId={} CallState={}", (Object)Constants.EVENT.CALL_LOCK_ACQUIRED_ON_MEDIA_TRANSMISSION_START, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)this.callState);
            if (Boolean.TRUE.equals(this.isTransmitting)) {
                logger.warn("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.CALL_START_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)"Already transmitting, ignoring request.");
                return;
            }
            ((ConferenceService)Constants.conferenceService.get()).enqueueTask(correlationId, () -> {
                try {
                    this.isTransmitting = true;
                    for (ChannelInfo channelInfo : channelInfoList) {
                        if (channelInfo == this) continue;
                        this.startTransmit(channelInfo);
                    }
                }
                catch (Exception e) {
                    logger.error("Error in startMediaTransmission", (Throwable)e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMediaTransmission(String correlationId, Collection<ChannelInfo> channelInfoList) {
        logger.info("EventId={} GroupId={} ParticipantId={} CallId={} CallState={}", (Object)Constants.EVENT.CALL_WAITING_FOR_LOCK_ON_MEDIA_TRANSMISSION_STOP, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)this.callState);
        Object object = this.lock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={} CallId={} CallState={}", (Object)Constants.EVENT.CALL_LOCK_ACQUIRED_ON_MEDIA_TRANSMISSION_STOP, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)this.callState);
            if (Boolean.TRUE.equals(this.isDispatcher)) {
                logger.warn("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.CALL_STOP_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)"Participant is a dispatcher, not stopping media transmission.");
                return;
            }
            if (Boolean.FALSE.equals(this.isTransmitting)) {
                logger.warn("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.CALL_STOP_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)"Not transmitting, ignoring request.");
                return;
            }
            ((ConferenceService)Constants.conferenceService.get()).enqueueTask(correlationId, () -> {
                try {
                    this.isTransmitting = false;
                    for (ChannelInfo channelInfo : channelInfoList) {
                        if (channelInfo == this) continue;
                        this.stopTransmit(channelInfo);
                    }
                }
                catch (Exception e) {
                    logger.error("Error in stopMediaTransmission", (Throwable)e);
                }
            });
        }
    }

    public void startTransmit(ChannelInfo channelInfo) {
        try {
            if (this.getAudioMedia() != null && channelInfo.getAudioMedia() != null) {
                this.getAudioMedia().startTransmit(channelInfo.getAudioMedia());
                logger.info("EventId={} GroupId={} ParticipantId={} CallId={} GroupMember={}", (Object)Constants.EVENT.CALL_START_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)channelInfo.getRemotePartyNumber());
            } else {
                logger.warn("EventId={} GroupId={} ParticipantId={} CallId={} GroupMember={} Cause={}", (Object)Constants.EVENT.CALL_START_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)channelInfo.getRemotePartyNumber(), (Object)Constants.CAUSE.MEDIA_NOT_AVAILABLE);
            }
        }
        catch (Exception e) {
            logger.error("EventId={} GroupId={} ParticipantId={} CallId={} GroupMember={} Cause={}", (Object)Constants.EVENT.CALL_START_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)channelInfo.getRemotePartyNumber(), (Object)Constants.CAUSE.MEDIA_NOT_AVAILABLE, (Object)e);
        }
    }

    public void stopTransmit(ChannelInfo channelInfo) {
        try {
            if (this.getAudioMedia() != null && channelInfo.getAudioMedia() != null) {
                this.getAudioMedia().stopTransmit(channelInfo.getAudioMedia());
                logger.info("EventId={} GroupId={} ParticipantId={} CallId={} GroupMember={}", (Object)Constants.EVENT.CALL_STOP_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)channelInfo.getRemotePartyNumber());
            } else {
                logger.warn("EventId={} GroupId={} ParticipantId={} CallId={} GroupMember={} Cause={}", (Object)Constants.EVENT.CALL_STOP_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)channelInfo.getRemotePartyNumber(), (Object)Constants.CAUSE.MEDIA_NOT_AVAILABLE);
            }
        }
        catch (Exception e) {
            logger.error("EventId={} GroupId={} ParticipantId={} CallId={} GroupMember={} Cause={}", (Object)Constants.EVENT.CALL_STOP_TRANSMIT_MEDIA, (Object)this.callGroup, (Object)this.remotePartyNumber, (Object)this.callId, (Object)channelInfo.getRemotePartyNumber(), (Object)Constants.CAUSE.MEDIA_NOT_AVAILABLE, (Object)e);
        }
    }

    @Generated
    public Object getLock() {
        return this.lock;
    }

    @Generated
    public String getCallGroup() {
        return this.callGroup;
    }

    @Generated
    public String getCallId() {
        return this.callId;
    }

    @Generated
    public String getCallType() {
        return this.callType;
    }

    @Generated
    public String getCallDirection() {
        return this.callDirection;
    }

    @Generated
    public String getRemotePartyNumber() {
        return this.remotePartyNumber;
    }

    @Generated
    public String getRemotePartyName() {
        return this.remotePartyName;
    }

    @Generated
    public Integer getCallState() {
        return this.callState;
    }

    @Generated
    public Long getAnswerEpoch() {
        return this.answerEpoch;
    }

    @Generated
    public Long getCallEpoch() {
        return this.callEpoch;
    }

    @Generated
    public Boolean getHasVideo() {
        return this.hasVideo;
    }

    @Generated
    public Boolean getIsConnected() {
        return this.isConnected;
    }

    @Generated
    public Boolean getIsAnswered() {
        return this.isAnswered;
    }

    @Generated
    public Boolean getIsDispatcher() {
        return this.isDispatcher;
    }

    @Generated
    public String getExtensionSubType() {
        return this.extensionSubType;
    }

    @Generated
    public Boolean getIsTransmitting() {
        return this.isTransmitting;
    }

    @Generated
    public AtomicReference<AudioMedia> getMediaStream() {
        return this.mediaStream;
    }

    @Generated
    public AtomicReference<SIPCall> getActiveCall() {
        return this.activeCall;
    }

    @Generated
    public void setCallGroup(String callGroup) {
        this.callGroup = callGroup;
    }

    @Generated
    public void setCallId(String callId) {
        this.callId = callId;
    }

    @Generated
    public void setCallType(String callType) {
        this.callType = callType;
    }

    @Generated
    public void setCallDirection(String callDirection) {
        this.callDirection = callDirection;
    }

    @Generated
    public void setRemotePartyNumber(String remotePartyNumber) {
        this.remotePartyNumber = remotePartyNumber;
    }

    @Generated
    public void setRemotePartyName(String remotePartyName) {
        this.remotePartyName = remotePartyName;
    }

    @Generated
    public void setCallState(Integer callState) {
        this.callState = callState;
    }

    @Generated
    public void setAnswerEpoch(Long answerEpoch) {
        this.answerEpoch = answerEpoch;
    }

    @Generated
    public void setCallEpoch(Long callEpoch) {
        this.callEpoch = callEpoch;
    }

    @Generated
    public void setHasVideo(Boolean hasVideo) {
        this.hasVideo = hasVideo;
    }

    @Generated
    public void setIsConnected(Boolean isConnected) {
        this.isConnected = isConnected;
    }

    @Generated
    public void setIsAnswered(Boolean isAnswered) {
        this.isAnswered = isAnswered;
    }

    @Generated
    public void setIsDispatcher(Boolean isDispatcher) {
        this.isDispatcher = isDispatcher;
    }

    @Generated
    public void setExtensionSubType(String extensionSubType) {
        this.extensionSubType = extensionSubType;
    }

    @Generated
    public void setIsTransmitting(Boolean isTransmitting) {
        this.isTransmitting = isTransmitting;
    }

    @Generated
    public void setMediaStream(AtomicReference<AudioMedia> mediaStream) {
        this.mediaStream = mediaStream;
    }

    @Generated
    public void setActiveCall(AtomicReference<SIPCall> activeCall) {
        this.activeCall = activeCall;
    }
}

