/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.ptt;

import com.coraltele.ppdrconference.entity.Conference;
import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.AssignFloorStatus;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.service.CallStatusService;
import com.coraltele.ppdrconference.service.ChannelInfo;
import com.coraltele.ppdrconference.service.FloorControlHistoryService;
import com.coraltele.ppdrconference.service.SIPServer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PTTGroup {
    private static final Logger logger = LogManager.getLogger(PTTGroup.class);
    protected final Object updateControlLock = new Object();
    public final Object floorAssignLock = new Object();
    protected String groupId = "";
    protected long timeoutPeriod = 0L;
    protected ScheduledExecutorService scheduler = null;
    protected AtomicBoolean eventReceived = new AtomicBoolean(false);
    protected AtomicBoolean pauseTimer = new AtomicBoolean(false);
    protected volatile long lastEventTimestamp = 0L;
    protected ConcurrentHashMap<String, ChannelInfo> participants = new ConcurrentHashMap();
    protected volatile String activeParticipantId = "";
    protected volatile String activeSessionId = "";
    protected volatile long callStartedOn = 0L;
    protected volatile long haveFloorUpdate = 0L;
    protected String instanceId = UUID.randomUUID().toString();
    protected volatile boolean isDispatcherInCall = false;
    protected volatile Integer errorCount = 0;
    protected volatile String dispatcherParticipantId = "";
    protected long dispatcherCallJoinEpoch = 0L;
    protected volatile int registrationCheck = 0;
    protected String videoStreamWith = "";
    protected AtomicBoolean videoStreamActive = new AtomicBoolean(false);
    protected SIPServer sipServer;
    protected FloorControlHistoryService floorControlHistoryService;

    protected PTTGroup(FloorControlHistoryService floorControlHistoryService, SIPServer sipServer, String groupId, long timeoutPeriod, Boolean timerPaused) {
        this.groupId = groupId;
        this.timeoutPeriod = timeoutPeriod;
        this.pauseTimer.set(timerPaused);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.sipServer = sipServer;
        this.floorControlHistoryService = floorControlHistoryService;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void recover(Conference conference) {
        this.isDispatcherInCall = conference.getIsDispatcherInCall() == null ? false : conference.getIsDispatcherInCall();
        this.dispatcherParticipantId = conference.getDispatcherParticipantId() == null ? "" : conference.getDispatcherParticipantId();
        this.dispatcherCallJoinEpoch = conference.getDispatcherJoinEpoch() == null ? 0L : conference.getDispatcherJoinEpoch();
    }

    public synchronized AssignFloorStatus assignFloor(String correlationId, String userId, String conferenceId, String accessType) {
        AssignFloorStatus returnValue = new AssignFloorStatus(false, "", "");
        if (Constants.callStatusService.get() != null) {
            returnValue = ((CallStatusService)Constants.callStatusService.get()).assignFloor(correlationId, userId, conferenceId, accessType);
        }
        return returnValue;
    }

    public synchronized RequestResponse updateVideoStreamStatus(String correlationId, String userId, String conferenceId, Boolean controlStatus) {
        RequestResponse returnValue = new RequestResponse();
        if (Constants.callStatusService.get() != null && (returnValue = ((CallStatusService)Constants.callStatusService.get()).updateVideoStreamControlStatus(correlationId, userId, conferenceId, controlStatus)).getStatus() == 0) {
            logger.info("EventId={} GroupId={} ParticipantId={} VideoStreamStatus={}", (Object)Constants.EVENT.UPDATE_VIDEO_STREAM_STATUS_REQUEST_RECEIVED, (Object)conferenceId, (Object)userId, (Object)controlStatus);
            if (controlStatus.booleanValue()) {
                this.videoStreamWith = userId;
                this.videoStreamActive.set(true);
            } else {
                this.videoStreamWith = "";
                this.videoStreamActive.set(false);
            }
        }
        return returnValue;
    }

    public abstract void checkFloor(String var1);

    public abstract void onEventTriggered(Boolean var1);

    public abstract void addParticipant(String var1, String var2, ChannelInfo var3);

    public abstract void participantShifted(String var1);

    public abstract void removeParticipant(String var1);

    public abstract void checkSessions(String var1, String var2);

    public abstract void checkSessionsDispatcher(String var1, String var2);

    public abstract void startMediaTransmission(String var1, String var2);

    public abstract void stopMediaTransmission(String var1, String var2);

    public abstract void updateMediaTransmission(String var1);
}

