/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.ptt;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.ptt.PTTGroup;
import com.coraltele.ppdrconference.service.ChannelInfo;
import com.coraltele.ppdrconference.service.ConferenceService;
import com.coraltele.ppdrconference.service.FloorControlHistoryService;
import com.coraltele.ppdrconference.service.RTCPServerService;
import com.coraltele.ppdrconference.service.SIPServer;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class PTTExternalServerMuxType2
extends PTTGroup {
    private static final Logger logger = LogManager.getLogger(PTTExternalServerMuxType2.class);

    public PTTExternalServerMuxType2(FloorControlHistoryService floorControlHistoryService, SIPServer sipServer, String groupId, long timeoutPeriod, Boolean timerPaused) {
        super(floorControlHistoryService, sipServer, groupId, timeoutPeriod, timerPaused);
        this.startMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFloor(String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            if (StringUtils.hasText((String)this.activeParticipantId) && this.activeParticipantId.equals(participantId)) {
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.I_HAVE_FLOOR_UPDATE, (Object)this.groupId, (Object)participantId);
                this.haveFloorUpdate = System.currentTimeMillis();
            }
        }
    }

    public void onEventTriggered(Boolean timerPaused) {
        logger.info("EventId={} GroupId={} TimerPaused={}", (Object)Constants.EVENT.GROUP_TIMER_EVENT, (Object)this.groupId, (Object)timerPaused);
        this.eventReceived.set(true);
        this.pauseTimer.set(timerPaused);
        this.lastEventTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipant(String correlationId, String participantId, ChannelInfo channelInfo) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_ADDING_PARTICIPANT, (Object)this.groupId, (Object)participantId);
            this.eventReceived.set(true);
            this.lastEventTimestamp = System.currentTimeMillis();
            if (Boolean.TRUE.equals(channelInfo.getIsDispatcher())) {
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_DISPATCHER_IN_CALL, (Object)this.groupId, (Object)participantId);
                this.checkSessionsDispatcher(correlationId, participantId);
            }
            if (this.participants.size() == 0) {
                this.activeSessionId = UUID.randomUUID().toString();
                this.callStartedOn = System.currentTimeMillis();
                logger.info("EventId={} GroupId={} ActiveSession={}", (Object)Constants.EVENT.GROUP_START_NEW_SESSION, (Object)this.groupId, (Object)this.activeSessionId);
            }
            if (this.participants.containsKey(participantId)) {
                logger.info("EventId={} GroupId={} ParticipantId={} Action=RemovingExistingParticipant", (Object)Constants.EVENT.GROUP_REMOVE_EXISTING_PARTICIPANT, (Object)this.groupId, (Object)participantId);
                this.participants.remove(participantId);
            }
            this.participants.put(participantId, channelInfo);
            if (!this.activeParticipantId.isEmpty()) {
                try {
                    ArrayList channelInfoList = new ArrayList(this.participants.values());
                    ChannelInfo activeChannel = (ChannelInfo)this.participants.get(this.activeParticipantId);
                    if (activeChannel != null) {
                        logger.info("EventId={} GroupId={} ParticipantId={} ParticipantCount={}", (Object)Constants.EVENT.GROUP_START_MEDIA_TRANSMISSION_SINGLE_PARTICIPANT, (Object)this.groupId, (Object)participantId, (Object)channelInfoList.size());
                        activeChannel.startMediaTransmission(correlationId, channelInfoList);
                        logger.info("EventId={} GroupId={} ParticipantId={} ParticipantCount={}", (Object)Constants.EVENT.GROUP_MEDIA_TRANSMISSION_SINGLE_PARTICIPANT_STARTED, (Object)this.groupId, (Object)participantId, (Object)channelInfoList.size());
                    } else {
                        logger.error("EventId={} GroupId={} ParticipantId={} ParticipantCount={} Cause=ActiveParticipantNotFound", (Object)Constants.EVENT.GROUP_START_MEDIA_TRANSMISSION_SINGLE_PARTICIPANT, (Object)this.groupId, (Object)participantId, (Object)channelInfoList.size());
                    }
                }
                catch (Exception e) {
                    logger.error("{} Error in PTT Assign while adding participant and active media transmission", (Object)this.instanceId, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void participantShifted(String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_PARTICIPANT_SHIFTED, (Object)this.groupId, (Object)participantId);
            if (!this.participants.containsKey(participantId)) {
                logger.info("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.GROUP_PARTICIPANT_SHIFTED, (Object)this.groupId, (Object)participantId, (Object)Constants.CAUSE.PARTICIPANT_NOT_PRESENT);
                return;
            }
            ChannelInfo channelInfo = (ChannelInfo)this.participants.get(participantId);
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_PARTICIPANT_SHIFT_CALL_END, (Object)this.groupId, (Object)participantId);
            ((ConferenceService)Constants.conferenceService.get()).enqueueTask("Group Id : " + this.groupId, () -> channelInfo.endCall());
            this.participants.remove(participantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipant(String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_REMOVE_PARTICIPANT, (Object)this.groupId, (Object)participantId);
            if (!this.participants.containsKey(participantId)) {
                logger.error("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.GROUP_REMOVE_PARTICIPANT, (Object)this.groupId, (Object)participantId, (Object)Constants.CAUSE.PARTICIPANT_NOT_PRESENT);
                return;
            }
            this.participants.remove(participantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSessions(String correlationId, String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_EVENT_CHECK_PARTICIPANT_SESSION, (Object)this.groupId, (Object)participantId);
            logger.info("EventId={} GroupId={} ParticipantId={}, Ignoring the call", (Object)Constants.EVENT.GROUP_JOIN_CONFERENCE, (Object)this.groupId, (Object)participantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSessionsDispatcher(String correlationId, String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_EVENT_CHECK_PARTICIPANT_SESSION_DISPATCHER, (Object)this.groupId, (Object)participantId);
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_JOIN_CONFERENCE, (Object)this.groupId, (Object)"");
            if (Constants.rtcpServerService.get() != null) {
                ArrayList channelInfoList = new ArrayList(this.participants.values());
                ((RTCPServerService)Constants.rtcpServerService.get()).joinConference(correlationId, this.groupId, channelInfoList, this.activeSessionId, participantId, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMediaTransmission(String correlationId, String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            if (!this.sipServer.isHavingActiveCall(this.groupId, participantId)) {
                logger.error("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.GROUP_START_MEDIA_TRANSMISSION, (Object)this.groupId, (Object)participantId, (Object)Constants.CAUSE.PARTICIPANT_NOT_PRESENT);
                if (Constants.rtcpServerService.get() != null) {
                    ((RTCPServerService)Constants.rtcpServerService.get()).releaseFloor(participantId, this.groupId);
                    ((RTCPServerService)Constants.rtcpServerService.get()).sendNotificationToUserToJoinConference(correlationId, this.activeSessionId, participantId);
                }
                return;
            }
            this.callStartedOn = System.currentTimeMillis();
            this.activeParticipantId = participantId;
            this.haveFloorUpdate = this.callStartedOn;
            this.sendRequestToParticipantToJoinConference(correlationId, "");
            logger.info("EventId={} GroupId={} ParticipantId={} Cause={}", (Object)Constants.EVENT.GROUP_START_MEDIA_TRANSMISSION, (Object)this.groupId, (Object)participantId, (Object)Constants.CAUSE.FLOOR_ASSIGNED);
            try {
                this.sipServer.sfuUnMute(this.groupId, participantId);
            }
            catch (Exception e) {
                logger.error("{} Error in PTT Assign", (Object)this.instanceId, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMediaTransmission(String correlationId, String participantId) {
        Object object = this.updateControlLock;
        synchronized (object) {
            this.activeParticipantId = "";
            this.haveFloorUpdate = 0L;
            logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_STOP_MEDIA_TRANSMISSION, (Object)this.groupId, (Object)participantId);
            try {
                this.sipServer.sfuMute(this.groupId, participantId);
            }
            catch (Exception e) {
                logger.error("{} Error in PTT Release", (Object)this.instanceId, (Object)e);
            }
        }
    }

    private void startMonitoring() {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_INITIATED, (Object)this.groupId);
        this.lastEventTimestamp = System.currentTimeMillis();
        this.scheduler.scheduleAtFixedRate(() -> {
            long currentTime = System.currentTimeMillis();
            ArrayList channelInfoList = new ArrayList(this.participants.values());
            for (ChannelInfo channelInfo : channelInfoList) {
                if (!Boolean.TRUE.equals(channelInfo.getIsDispatcher())) continue;
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_TIMER_PAUSED_DISPATCHER_IN_CALL, (Object)this.groupId);
                ((RTCPServerService)Constants.rtcpServerService.get()).sendFloorTaken(this.groupId, StringUtils.hasText((String)this.activeParticipantId) ? this.activeParticipantId : channelInfo.getRemotePartyNumber());
                return;
            }
            if (Boolean.TRUE.equals(Constants.ENFORCE_HEALTH_PACKET_TIMER != false && StringUtils.hasText((String)this.activeParticipantId)) && currentTime - this.haveFloorUpdate > Constants.MAX_WAIT_HEALTH_PACKET) {
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.I_HAVE_FLOOR_TIMEOUT, (Object)this.groupId, (Object)this.activeParticipantId);
                this.disconnectCall();
            }
            if (this.pauseTimer.get()) {
                logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_TIMER_PAUSED, (Object)this.groupId, (Object)this.activeParticipantId);
                if (this.callStartedOn > 0L && currentTime - this.callStartedOn >= TimeUnit.SECONDS.toMillis(Constants.MAX_PTT_DURATION)) {
                    this.disconnectCall();
                } else if (StringUtils.hasText((String)this.activeParticipantId)) {
                    ((RTCPServerService)Constants.rtcpServerService.get()).sendFloorTaken(this.groupId, this.activeParticipantId);
                } else {
                    ((RTCPServerService)Constants.rtcpServerService.get()).sendFloorIdle(this.groupId);
                }
                return;
            }
            if (!this.eventReceived.get() && currentTime - this.lastEventTimestamp >= TimeUnit.SECONDS.toMillis(this.timeoutPeriod)) {
                this.onTimeout();
            } else {
                this.eventReceived.set(false);
            }
        }, 0L, 2L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectCall() {
        Object object = this.updateControlLock;
        synchronized (object) {
            logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.CALL_TIMEOUT, (Object)this.groupId);
            this.onEventTriggered(Boolean.valueOf(false));
            this.callStartedOn = 0L;
            this.onTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimeout() {
        logger.info("EventId={} GroupId={} Starting call disconnect", (Object)Constants.EVENT.GROUP_EVENT_TIMEOUT, (Object)this.groupId);
        Object object = this.updateControlLock;
        synchronized (object) {
            if (this.participants.isEmpty()) {
                logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_NO_PARTICIPANT_SKIP_CALL_DISCONNECTION, (Object)this.groupId);
            } else {
                ArrayList channelInfoList = new ArrayList(this.participants.values());
                for (ChannelInfo channelInfo : channelInfoList) {
                    logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_TIMEOUT_DISCONNECT_CALL, (Object)this.groupId, (Object)channelInfo.getRemotePartyNumber());
                    this.participants.remove(channelInfo.getRemotePartyNumber());
                    ((ConferenceService)Constants.conferenceService.get()).enqueueTask("Group Id : " + this.groupId, () -> channelInfo.endCall());
                }
                this.sendRequestToParticipantToLeaveConference("Group ID : " + this.groupId);
                this.activeParticipantId = "";
            }
        }
    }

    private void sendRequestToParticipantToJoinConference(String correlationId, String specificParticipant) {
        logger.info("EventId={} GroupId={} ParticipantId={}", (Object)Constants.EVENT.GROUP_JOIN_CONFERENCE, (Object)this.groupId, (Object)specificParticipant);
        if (Constants.rtcpServerService.get() != null) {
            ArrayList channelInfoList = new ArrayList(this.participants.values());
            ((RTCPServerService)Constants.rtcpServerService.get()).joinConference(correlationId, this.groupId, channelInfoList, this.activeSessionId, this.activeParticipantId, specificParticipant);
        }
    }

    private void sendRequestToParticipantToLeaveConference(String correlationId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_LEAVE_CONFERENCE, (Object)this.groupId);
        if (Constants.rtcpServerService.get() != null) {
            ((RTCPServerService)Constants.rtcpServerService.get()).leaveConference(correlationId, this.groupId, this.activeSessionId);
        }
    }

    public void updateMediaTransmission(String correlationId) {
        logger.info("EventId={} GroupId={}", (Object)Constants.EVENT.GROUP_MEDIA_UPDATE, (Object)this.groupId);
    }
}

