/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx.mcvideo;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransmissionControlAck {
    private static final Logger logger = LogManager.getLogger(TransmissionControlAck.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCV2";

    private byte setHeader() {
        int mcvType = 4;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)mcvType;
        return (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        return new byte[]{rtcpLengthByte1, rtcpLengthByte2};
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        return new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
    }

    private byte[] setSourceField(int sourceValue) {
        int sourceId = 10;
        int sourceLength = 2;
        byte sourceIDByte = (byte)(sourceId & 0xFF);
        byte sourceLengthByte = (byte)(sourceLength & 0xFF);
        byte sourceValueByte1 = (byte)(sourceValue >> 8 & 0xFF);
        byte sourceValueByte2 = (byte)(sourceValue & 0xFF);
        return new byte[]{sourceIDByte, sourceLengthByte, sourceValueByte1, sourceValueByte2};
    }

    private byte[] setMessageTypeField(int messageTypeValue) {
        int messageTypeId = 12;
        int messageTypeLength = 2;
        int messageSpare = 0;
        byte messageIDByte = (byte)(messageTypeId & 0xFF);
        byte messageLengthByte = (byte)(messageTypeLength & 0xFF);
        byte messageTypeByte = (byte)(messageTypeValue & 0xFF);
        byte messageSpareByte = (byte)(messageSpare & 0xFF);
        return new byte[]{messageIDByte, messageLengthByte, messageTypeByte, messageSpareByte};
    }

    public byte[] setMessageNameField() {
        int messageNameId = 16;
        int messageNameLength = 6;
        String messageNameValue = "MCV0";
        int messageNameSpare = 0;
        byte[] messageNameData = messageNameValue.getBytes();
        byte[] messageNameField = new byte[8];
        messageNameField[0] = (byte)(messageNameId & 0xFF);
        messageNameField[1] = (byte)(messageNameLength & 0xFF);
        System.arraycopy(messageNameData, 0, messageNameField, 2, messageNameData.length);
        messageNameField[6] = (byte)(messageNameSpare >> 8 & 0xFF);
        messageNameField[7] = (byte)(messageNameSpare & 0xFF);
        return messageNameField;
    }

    public byte[] send(int ssrcValue, int sourceValue, int messageTypeValue) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] sourceField = this.setSourceField(sourceValue);
        byte[] messageTypeField = this.setMessageTypeField(messageTypeValue);
        byte[] messageNameField = this.setMessageNameField();
        int totalRtcpLength = (8 + sourceField.length + messageTypeField.length + messageNameField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + sourceField.length + messageTypeField.length + messageNameField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(sourceField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, sourceField.length);
        System.arraycopy(messageTypeField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + sourceField.length, messageTypeField.length);
        System.arraycopy(messageNameField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + sourceField.length + messageTypeField.length, messageNameField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

