/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class McptFloorTaken {
    private static final Logger logger = LogManager.getLogger(McptFloorTaken.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCPT";

    private byte setHeader() {
        int mcptType = 2;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private byte[] setGrantedPartyIdentity(String grantedPartyIdentityStr) {
        int requestPartyIdentityID = 4;
        int origLen = grantedPartyIdentityStr.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                grantedPartyIdentityStr = grantedPartyIdentityStr + "\u0000";
            }
        }
        byte[] grantedPartyIdeStrData = grantedPartyIdentityStr.getBytes();
        byte[] grantedPartyField = new byte[2 + origLen];
        grantedPartyField[0] = (byte)requestPartyIdentityID;
        grantedPartyField[1] = (byte)origLen;
        System.arraycopy(grantedPartyIdeStrData, 0, grantedPartyField, 2, grantedPartyIdeStrData.length);
        return grantedPartyField;
    }

    private byte[] setPermissionToReqField(int permissionRequestFloorValue) {
        int permissionRequestFloorID = 5;
        int permissionRequestFloorLength = 2;
        byte[] permissionRequestFloorField = new byte[]{(byte)permissionRequestFloorID, (byte)permissionRequestFloorLength, (byte)(permissionRequestFloorValue >> 8 & 0xFF), (byte)(permissionRequestFloorValue & 0xFF)};
        return permissionRequestFloorField;
    }

    private byte[] setMessageSeqField(int messageSequenceValue) {
        int messageSequenceFieldID = 8;
        int messageSequenceLength = 2;
        byte messageIDByte = (byte)(messageSequenceFieldID & 0xFF);
        byte messageLengthByte = (byte)(messageSequenceLength & 0xFF);
        byte messageTypeByte1 = (byte)(messageSequenceValue >> 8 & 0xFF);
        byte messageSpareByte2 = (byte)(messageSequenceValue & 0xFF);
        return new byte[]{messageIDByte, messageLengthByte, messageTypeByte1, messageSpareByte2};
    }

    private byte[] setFloorIndicatorIDField(char floorIndicatorValueChar) {
        int floorIndicatorValue;
        int floorIndicatorFieldId = 13;
        int floorIndicatorLength = 2;
        if (floorIndicatorValueChar == 'A') {
            floorIndicatorValue = 32768;
        } else if (floorIndicatorValueChar == 'B') {
            floorIndicatorValue = 16384;
        } else if (floorIndicatorValueChar == 'C') {
            floorIndicatorValue = 8192;
        } else if (floorIndicatorValueChar == 'D') {
            floorIndicatorValue = 4096;
        } else if (floorIndicatorValueChar == 'E') {
            floorIndicatorValue = 2048;
        } else if (floorIndicatorValueChar == 'F') {
            floorIndicatorValue = 1024;
        } else if (floorIndicatorValueChar == 'G') {
            floorIndicatorValue = 512;
        } else if (floorIndicatorValueChar == 'H') {
            floorIndicatorValue = 256;
        } else if (floorIndicatorValueChar == 'I') {
            floorIndicatorValue = 128;
        } else {
            throw new IllegalArgumentException("Invalid floor indicator value");
        }
        byte[] floorIndicatorValueData = new byte[]{(byte)(floorIndicatorValue >> 8 & 0xFF), (byte)floorIndicatorValue};
        byte[] floorIndicator = new byte[2 + floorIndicatorValueData.length];
        floorIndicator[0] = (byte)(floorIndicatorFieldId & 0xFF);
        floorIndicator[1] = (byte)(floorIndicatorLength & 0xFF);
        System.arraycopy(floorIndicatorValueData, 0, floorIndicator, 2, floorIndicatorValueData.length);
        return floorIndicator;
    }

    public byte[] setSSRCGrantedField(int ssrcValueGrantedID) {
        int ssrcFieldId = 14;
        int ssrcLength = 6;
        int ssrcSpare = 0;
        byte[] ssrcOfGrantedParticipant = new byte[]{(byte)(ssrcFieldId & 0xFF), (byte)(ssrcLength & 0xFF), (byte)(ssrcValueGrantedID >> 24 & 0xFF), (byte)(ssrcValueGrantedID >> 16 & 0xFF), (byte)(ssrcValueGrantedID >> 8 & 0xFF), (byte)(ssrcValueGrantedID & 0xFF), (byte)(ssrcSpare & 0xFF), (byte)(ssrcSpare & 0xFF)};
        return ssrcOfGrantedParticipant;
    }

    private byte[] setFunctionAliasField(String funAliasValue) {
        int funAliasFieldId = 17;
        int origLen = funAliasValue.length();
        if (origLen % 4 != 2) {
            int remainder = origLen % 4;
            int paddingLength = remainder == 0 ? 2 : remainder;
            origLen += paddingLength;
            for (int i = 0; i < paddingLength; ++i) {
                funAliasValue = funAliasValue + "\u0000";
            }
        }
        byte[] functionaAliasData = funAliasValue.getBytes();
        byte[] FunctionalAlias = new byte[2 + origLen];
        FunctionalAlias[0] = (byte)funAliasFieldId;
        FunctionalAlias[1] = (byte)origLen;
        System.arraycopy(functionaAliasData, 0, FunctionalAlias, 2, functionaAliasData.length);
        return FunctionalAlias;
    }

    private byte[] setLocationField(int locationType) {
        int locationID = 19;
        int locationLength = 2;
        int locationValue = 234;
        byte[] locationField = new byte[]{(byte)locationID, (byte)locationLength, (byte)locationType, (byte)locationValue};
        return locationField;
    }

    public byte[] send(int ssrcValue, String grantedPartyIdentityStr, int permissionRequestFloorValue, int messageSequenceValue, char floorIndicatorBit, int SSRCValueOfGrantedID, String functionalAliasValue, int locationType) {
        byte[] appData = name.getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] grantedPartyField = this.setGrantedPartyIdentity(grantedPartyIdentityStr);
        byte[] permissionField = this.setPermissionToReqField(permissionRequestFloorValue);
        byte[] messageSequenceField = this.setMessageSeqField(messageSequenceValue);
        byte[] floorIndicatorField = this.setFloorIndicatorIDField(floorIndicatorBit);
        byte[] ssrcOfParticipant = this.setSSRCGrantedField(SSRCValueOfGrantedID);
        byte[] functionAliasField = this.setFunctionAliasField(functionalAliasValue);
        byte[] locationField = this.setLocationField(locationType);
        int totalRtcpLength = (8 + grantedPartyField.length + permissionField.length + messageSequenceField.length + floorIndicatorField.length + ssrcOfParticipant.length + functionAliasField.length + locationField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + grantedPartyField.length + permissionField.length + messageSequenceField.length + floorIndicatorField.length + ssrcOfParticipant.length + functionAliasField.length + locationField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(grantedPartyField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, grantedPartyField.length);
        System.arraycopy(permissionField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length, permissionField.length);
        System.arraycopy(messageSequenceField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length + permissionField.length, messageSequenceField.length);
        System.arraycopy(floorIndicatorField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length + permissionField.length + messageSequenceField.length, floorIndicatorField.length);
        System.arraycopy(ssrcOfParticipant, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length + permissionField.length + messageSequenceField.length + floorIndicatorField.length, ssrcOfParticipant.length);
        System.arraycopy(functionAliasField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length + permissionField.length + messageSequenceField.length + floorIndicatorField.length + ssrcOfParticipant.length, functionAliasField.length);
        System.arraycopy(locationField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length + grantedPartyField.length + permissionField.length + messageSequenceField.length + floorIndicatorField.length + ssrcOfParticipant.length + functionAliasField.length, locationField.length);
        logger.debug("Floor Taken packet called");
        return packet;
    }
}

