/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import com.coraltele.ppdrconference.model.CommonHeader;
import com.coraltele.ppdrconference.model.MCPTTData;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCXRTCP {
    private static final Logger logger = LogManager.getLogger(MCXRTCP.class);
    byte[] rawDataReceived;
    Boolean rawData;
    String receivedAPPName;
    public MCPTTData mcpttData = new MCPTTData();

    public MCXRTCP(byte[] dataReceived) {
        this.rawDataReceived = dataReceived;
        this.rawData = true;
    }

    public MCXRTCP() {
    }

    public Boolean isValidMCPTT(byte[] packetData) {
        Boolean returnValue = false;
        int payloadType = packetData[1] & 0xFF;
        returnValue = payloadType == 204;
        return returnValue;
    }

    private void updateHeaderValue() {
        byte headerByte = this.rawDataReceived[0];
        CommonHeader commonHeaderData = this.mcpttData.getCommonHeader();
        commonHeaderData.setRtcpVersionByte(headerByte >> 6 & 3);
        commonHeaderData.setPaddingByte(headerByte >> 5 & 1);
        commonHeaderData.setPacketType(headerByte & 0x1F);
        this.receivedAPPName = this.updateAPPName();
        if ("MCPT".equals(this.receivedAPPName)) {
            switch (commonHeaderData.getPacketType()) {
                case 0: {
                    this.mcpttData.setRequestType("Floor request");
                    break;
                }
                case 1: {
                    this.mcpttData.setRequestType("Floor granted");
                    break;
                }
                case 2: {
                    this.mcpttData.setRequestType("Floor taken");
                    break;
                }
                case 3: {
                    this.mcpttData.setRequestType("Floor deny");
                    break;
                }
                case 4: {
                    this.mcpttData.setRequestType("Floor release");
                    break;
                }
                case 5: {
                    this.mcpttData.setRequestType("Floor Idle");
                    break;
                }
                case 6: {
                    this.mcpttData.setRequestType("Floor revoke");
                    break;
                }
                case 8: {
                    this.mcpttData.setRequestType("Floor queue Position Request");
                    break;
                }
                case 9: {
                    this.mcpttData.setRequestType("Floor queue Position Info");
                    break;
                }
                case 10: {
                    this.mcpttData.setRequestType("Floor Ack");
                    break;
                }
                case 11: {
                    this.mcpttData.setRequestType("unicast Media Flow control");
                    break;
                }
                case 14: {
                    this.mcpttData.setRequestType("Queue Floor Request");
                    break;
                }
                case 15: {
                    this.mcpttData.setRequestType("Floor Release MultiTalker");
                    break;
                }
                default: {
                    logger.debug("Unknown packet type");
                    break;
                }
            }
        } else if ("MCPC".equals(this.receivedAPPName)) {
            switch (commonHeaderData.getPacketType()) {
                case 0: {
                    this.mcpttData.setRequestType("MCPC Connect");
                    break;
                }
                case 1: {
                    this.mcpttData.setRequestType("MCPC Disconnect");
                    break;
                }
                case 2: {
                    this.mcpttData.setRequestType("MCPC Ack");
                    break;
                }
                case 3: {
                    this.mcpttData.setRequestType("Broadcast Invite");
                    break;
                }
                default: {
                    logger.debug("Unknown Sub type");
                    break;
                }
            }
        } else if ("MCV0".equals(this.receivedAPPName)) {
            switch (commonHeaderData.getPacketType()) {
                case 0: {
                    this.mcpttData.setRequestType("Transmission Request");
                    break;
                }
                case 1: {
                    this.mcpttData.setRequestType("Unknown Transmission Packet");
                    break;
                }
                case 2: {
                    this.mcpttData.setRequestType("Transmission Release ");
                    break;
                }
                default: {
                    logger.debug("Unknown Sub type");
                    break;
                }
            }
        } else if ("MCV1".equals(this.receivedAPPName)) {
            switch (commonHeaderData.getPacketType()) {
                case 0: {
                    this.mcpttData.setRequestType("Transmission Granted");
                    break;
                }
                case 1: {
                    this.mcpttData.setRequestType("Transmission Rejected");
                    break;
                }
                case 2: {
                    this.mcpttData.setRequestType("Transmission Arbitration Taken");
                    break;
                }
                default: {
                    logger.debug("Unknown Sub type");
                    break;
                }
            }
        } else if ("MCV2".equals(this.receivedAPPName)) {
            switch (commonHeaderData.getPacketType()) {
                case 0: {
                    this.mcpttData.setRequestType("Transmission End Request");
                    break;
                }
                case 1: {
                    this.mcpttData.setRequestType("Transmission End Response");
                    break;
                }
                case 2: {
                    this.mcpttData.setRequestType("Media Receive End Request");
                    break;
                }
                case 3: {
                    this.mcpttData.setRequestType("Media Receive End Response");
                    break;
                }
                case 4: {
                    this.mcpttData.setRequestType("Transmission Control Ack");
                    break;
                }
                default: {
                    logger.debug("Unknown Sub type");
                    break;
                }
            }
        } else if ("ALIV".equals(this.receivedAPPName)) {
            switch (commonHeaderData.getPacketType()) {
                case 0: {
                    this.mcpttData.setRequestType("HeartBeat Packet");
                    break;
                }
                case 1: {
                    this.mcpttData.setRequestType("Ok Packet");
                    break;
                }
                default: {
                    logger.debug("Unknown Sub type");
                }
            }
        }
        logger.debug("*****Request Type name***** :{}", (Object)this.mcpttData.getRequestType());
    }

    private int updateTotalLength() {
        byte[] lengthBytes = new byte[]{this.rawDataReceived[2], this.rawDataReceived[3]};
        int rtcpLengthByte1 = lengthBytes[0] << 8 & 0xFF;
        int rtcpLengthByte2 = lengthBytes[1] & 0xFF;
        int totalRtcpLength = rtcpLengthByte1 + rtcpLengthByte2;
        this.mcpttData.setPacketLength(totalRtcpLength);
        return totalRtcpLength;
    }

    private void updateSSRC() {
        byte[] ssrcBytes = new byte[]{this.rawDataReceived[4], this.rawDataReceived[5], this.rawDataReceived[6], this.rawDataReceived[7]};
        int ssrc = (ssrcBytes[0] & 0xFF) << 24 | (ssrcBytes[1] & 0xFF) << 16 | (ssrcBytes[2] & 0xFF) << 8 | ssrcBytes[3] & 0xFF;
        logger.debug("SSRC Value:{}", (Object)ssrc);
        this.mcpttData.setSsrc(ssrc);
    }

    private String updateAPPName() {
        byte[] appNameBytes = new byte[]{this.rawDataReceived[8], this.rawDataReceived[9], this.rawDataReceived[10], this.rawDataReceived[11]};
        this.mcpttData.setAppName(new String(appNameBytes, StandardCharsets.UTF_8));
        logger.debug("app Value:{}", (Object)this.mcpttData.getAppName());
        return this.mcpttData.getAppName();
    }

    public MCPTTData getData() {
        this.updateHeaderValue();
        int updatedLength = this.updateTotalLength();
        int updatedLengthValue = 4 * updatedLength + 4;
        logger.debug("updated Length:{}", (Object)updatedLengthValue);
        this.updateSSRC();
        this.receivedAPPName = this.updateAPPName();
        if ("MCPT".equals(this.receivedAPPName)) {
            for (int i = 12; i < updatedLengthValue; ++i) {
                byte attributeType = this.rawDataReceived[i];
                int attributeLength = this.rawDataReceived[++i];
                ByteArrayOutputStream attributeDataBuffer = new ByteArrayOutputStream();
                for (int j = 0; j < attributeLength; ++j) {
                    attributeDataBuffer.write(this.rawDataReceived[++i]);
                }
                byte[] attributeData = attributeDataBuffer.toByteArray();
                if (attributeType == 0) {
                    this.mcpttData.setFloorPriority((int)attributeData[0]);
                    logger.debug("*****Floor Priority:{}", (Object)this.mcpttData.getFloorPriority());
                } else if (attributeType == 1) {
                    int durationValue = attributeData[0] << 8 | attributeData[1];
                    this.mcpttData.setDuration(durationValue);
                    logger.debug("*****Duration Field value:{}", (Object)this.mcpttData.getDuration());
                } else if (attributeType == 2) {
                    this.mcpttData.getRejectCause().setCause((attributeData[0] | attributeData[1]) & 0xFF);
                    logger.debug("*****Reject Cause:{}", (Object)this.mcpttData.getRejectCause().getCause());
                    StringBuilder additionalData = new StringBuilder(0);
                    if (attributeLength > 2) {
                        for (int k = 2; k < attributeLength; ++k) {
                            if (attributeData[k] == 0) continue;
                            additionalData.append((char)attributeData[k]);
                        }
                    }
                    this.mcpttData.getRejectCause().setMessage(additionalData.toString());
                } else if (attributeType == 3) {
                    this.mcpttData.getQueueInfo().setQueuePositionInfo(attributeData[0] & 0xFF);
                    this.mcpttData.getQueueInfo().setQueuePositionLevel(attributeData[1] & 0xFF);
                    logger.debug("*****Queue Info Filed:{},{}", (Object)this.mcpttData.getQueueInfo().getQueuePositionInfo(), (Object)this.mcpttData.getQueueInfo().getQueuePositionLevel());
                } else if (attributeType == 4) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setGrantedPartyIdentity(additionalData.toString());
                    logger.debug("*****GrantedParty : {}", (Object)this.mcpttData.getGrantedPartyIdentity());
                } else if (attributeType == 5) {
                    int permissionValue = attributeData[0] << 8 | attributeData[1];
                    this.mcpttData.setPermissionFloorRequest(permissionValue);
                    logger.debug("*****Permission Value:{}", (Object)this.mcpttData.getPermissionFloorRequest());
                } else if (attributeType == 6) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setUserID(additionalData.toString());
                    logger.debug("*****User ID : {}", (Object)this.mcpttData.getUserID());
                } else if (attributeType == 7) {
                    this.mcpttData.setQueueSize(attributeData[0] | attributeData[1]);
                    logger.debug("******QueueSize :{}", (Object)this.mcpttData.getQueueSize());
                } else if (attributeType == 8) {
                    this.mcpttData.setMessageSequence(attributeData[0] | attributeData[1]);
                    logger.debug("******Message Sequence :{}", (Object)this.mcpttData.getMessageSequence());
                } else if (attributeType == 9) {
                    StringBuilder additionalData = new StringBuilder();
                    if (attributeLength > 2) {
                        for (int j = 0; j < attributeData.length; ++j) {
                            if (attributeData[j] == 0) continue;
                            additionalData.append((char)attributeData[j]);
                        }
                    }
                    this.mcpttData.setQueueUserIDValue(additionalData.toString());
                    logger.debug("******Queue UserID value:{}", (Object)this.mcpttData.getQueueUserIDValue());
                } else if (attributeType == 10) {
                    this.mcpttData.setSourceIdValue(attributeData[0] | attributeData[1]);
                    logger.debug("******SourceId Value :{}", (Object)this.mcpttData.getSourceIdValue());
                } else if (attributeType == 11) {
                    this.mcpttData.getTrackInfo().setQueueingCapability((int)attributeData[0]);
                    int participantTypeLen = attributeData[1];
                    StringBuilder additionalData = new StringBuilder();
                    if (attributeLength > 2) {
                        int k = 2;
                        for (int l = 0; k < attributeLength && l < participantTypeLen; ++k, ++l) {
                            if (attributeData[k] == 0) continue;
                            additionalData.append((char)attributeData[k]);
                        }
                    }
                    this.mcpttData.getTrackInfo().setParticipantValue(additionalData.toString());
                    logger.debug("*****TrackInfo value {}", (Object)this.mcpttData.getTrackInfo().getParticipantValue());
                } else if (attributeType == 12) {
                    this.mcpttData.setMessageType(attributeData[0] | attributeData[1]);
                    logger.debug("******Message Type :{}", (Object)this.mcpttData.getMessageType());
                } else if (attributeType == 13) {
                    char floorIndicatorValue = (char)(attributeData[0] << 8 | attributeData[1]);
                    this.mcpttData.setFloorIndicatorValue((int)floorIndicatorValue);
                    logger.debug("*****Floor Indicator value:{}", (Object)this.mcpttData.getFloorIndicatorValue());
                } else if (attributeType == 14) {
                    byte[] ssrcGrantedBytes = new byte[]{attributeData[0], attributeData[1], attributeData[2], attributeData[3]};
                    int ssrcGrantedValue = (ssrcGrantedBytes[0] & 0xFF) << 24 | (ssrcGrantedBytes[1] & 0xFF) << 16 | (ssrcGrantedBytes[2] & 0xFF) << 8 | ssrcGrantedBytes[3] & 0xFF;
                    logger.debug("ssrc granted Value:{}", (Object)ssrcGrantedValue);
                    this.mcpttData.setSsrcOfGrantedParticipant(ssrcGrantedValue);
                    this.mcpttData.setSpareByte(attributeData[4] | attributeData[5]);
                    logger.debug("*****SSRC of participant :{}", (Object)this.mcpttData.getSsrcOfGrantedParticipant());
                } else if (attributeType == 15) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setGrantedUserValue(additionalData.toString());
                    logger.debug("Value of granted users:{}", (Object)this.mcpttData.getGrantedUserValue());
                } else if (attributeType == 16) {
                    this.mcpttData.getListOfSSRCValue().setNumberOfSsrcs((int)attributeData[0]);
                    this.mcpttData.getListOfSSRCValue().setListSpareByte((int)attributeData[1]);
                    byte[] ssrcGrantedBytes = new byte[]{attributeData[2], attributeData[3], attributeData[4], attributeData[5]};
                    int ssrcGrantedValue = (ssrcGrantedBytes[0] & 0xFF) << 24 | (ssrcGrantedBytes[1] & 0xFF) << 16 | (ssrcGrantedBytes[2] & 0xFF) << 8 | ssrcGrantedBytes[3] & 0xFF;
                    logger.debug("ssrc granted Value:{}", (Object)ssrcGrantedValue);
                    this.mcpttData.getListOfSSRCValue().setSsrcValue(ssrcGrantedValue);
                    logger.debug("List of ssrc granted Value:{}", (Object)this.mcpttData.getListOfSSRCValue().getSsrcValue());
                } else if (attributeType == 17) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setFunctionalAlias(additionalData.toString());
                    logger.debug(" *****Functional Alias : {}", (Object)this.mcpttData.getFunctionalAlias());
                } else if (attributeType == 18) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setListOfFAsValue(additionalData.toString());
                    logger.debug("Value of List of FAs:{}", (Object)this.mcpttData.getListOfFAsValue());
                } else if (attributeType == 19) {
                    this.mcpttData.getLocation().setLocationType((int)attributeData[0]);
                    this.mcpttData.getLocation().setLocationValue((int)attributeData[1]);
                    logger.debug(" *****Location : {},{}", (Object)this.mcpttData.getLocation().getLocationType(), (Object)this.mcpttData.getLocation().getLocationValue());
                } else if (attributeType == 20) {
                    this.mcpttData.getListOfLocation().setNumberOfLocations((int)attributeData[0]);
                    this.mcpttData.getListOfLocation().setLocation((int)attributeData[1]);
                    logger.debug("******List of Location :{}", (Object)this.mcpttData.getListOfLocation().getLocation());
                    logger.debug("************Number of Locations :{}", (Object)this.mcpttData.getListOfLocation().getNumberOfLocations());
                } else if (attributeType == 21) {
                    this.mcpttData.setQueuedFloorRequestPurpose((int)attributeData[0]);
                    logger.debug("******Queued Floor Request Purpose :{}", (Object)this.mcpttData.getQueuedFloorRequestPurpose());
                } else if (attributeType == 22) {
                    this.mcpttData.getListOfQueuedUsers().setNumberOfQueuedUsers((int)attributeData[0]);
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.getListOfQueuedUsers().setQueueduserID(additionalData.toString());
                    logger.debug(" List of Queued Users ID : {}", (Object)this.mcpttData);
                } else if (attributeType == 23) {
                    this.mcpttData.setQueuedFloorRequestResult(attributeData[0] | attributeData[1]);
                    logger.debug("******Queued Floor Request Result:{}", (Object)this.mcpttData.getQueuedFloorRequestResult());
                } else if (attributeType == 24) {
                    this.mcpttData.setMediaFlowControlIndicator(attributeData[0] | attributeData[1]);
                    logger.debug("Media Flow Control Indicator:{}", (Object)this.mcpttData.getMediaFlowControlIndicator());
                } else {
                    logger.debug("Not Received MCPT RTCP Packet");
                }
                logger.debug("MCPTT Packet Received {}", (Object)this.mcpttData);
            }
        } else if ("MCPC".equals(this.receivedAPPName)) {
            for (int i = 12; i < updatedLengthValue; ++i) {
                int k;
                StringBuilder additionalData;
                byte attributeType = this.rawDataReceived[i];
                int attributeLength = this.rawDataReceived[++i];
                ByteArrayOutputStream attributeDataBuffer = new ByteArrayOutputStream();
                for (int j = 0; j < attributeLength; ++j) {
                    attributeDataBuffer.write(this.rawDataReceived[++i]);
                }
                byte[] attributeData = attributeDataBuffer.toByteArray();
                if (attributeType == 0) {
                    this.mcpttData.setControlChannelValue((int)attributeData[1]);
                    logger.debug("*****Media ControlChannelValue:{}", (Object)this.mcpttData.getControlChannelValue());
                } else if (attributeType == 1) {
                    additionalData = new StringBuilder();
                    if (attributeData.length > 0) {
                        byte sessionType = attributeData[0];
                        this.mcpttData.setMcpcSessionType((int)sessionType);
                        for (int k2 = 1; k2 < attributeData.length; ++k2) {
                            if (attributeData[k2] == 0) continue;
                            additionalData.append((char)attributeData[k2]);
                        }
                        this.mcpttData.setMcpttSessionURIStr(additionalData.toString());
                    }
                    logger.debug("*****MCPTT session URI ID : {}", (Object)this.mcpttData.getMcpttSessionURIStr());
                } else if (attributeType == 2) {
                    additionalData = new StringBuilder();
                    for (k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setWarningTextStr(additionalData.toString());
                    logger.debug("*****MCPTT Warning Text : {}", (Object)this.mcpttData.getWarningTextStr());
                } else if (attributeType == 3) {
                    additionalData = new StringBuilder();
                    for (k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setMcpttGroupURIStr(additionalData.toString());
                    logger.debug("*****MCPTT Group URI Name : {}", (Object)this.mcpttData.getMcpttGroupURIStr());
                } else if (attributeType == 4) {
                    this.mcpttData.setAnswerState(attributeData[0] << 8 | attributeData[1]);
                    logger.debug("*****Answer State Value : {}", (Object)this.mcpttData.getAnswerState());
                } else if (attributeType == 5) {
                    additionalData = new StringBuilder();
                    for (k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setMcpttInvitingStr(additionalData.toString());
                    logger.debug("*****MCPTT inviting URI : {}", (Object)this.mcpttData.getMcpttInvitingStr());
                } else if (attributeType == 6) {
                    this.mcpttData.setReasonCodeValue(attributeData[0] << 8 | attributeData[1]);
                    logger.debug("*****Reason Code : {}", (Object)this.mcpttData.getReasonCodeValue());
                } else if (attributeType == 192) {
                    additionalData = new StringBuilder();
                    for (k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setPckMessageStr(additionalData.toString());
                    logger.debug("*****The PCK I_MESSAGE: {}", (Object)this.mcpttData.getPckMessageStr());
                } else {
                    logger.debug("Not Received MCPC RTCP Packet");
                }
                logger.debug("MCPTT Packet Received {}", (Object)this.mcpttData);
            }
        } else if ("MCMC".equals(this.receivedAPPName)) {
            for (int i = 12; i < updatedLengthValue; ++i) {
                int k;
                StringBuilder additionalData;
                byte attributeType = this.rawDataReceived[i];
                int attributeLength = this.rawDataReceived[++i];
                ByteArrayOutputStream attributeDataBuffer = new ByteArrayOutputStream();
                for (int j = 0; j < attributeLength; ++j) {
                    attributeDataBuffer.write(this.rawDataReceived[++i]);
                }
                byte[] attributeData = attributeDataBuffer.toByteArray();
                if (attributeType == 0) {
                    this.mcpttData.setIpVersion(attributeData[1] >> 4);
                    logger.debug("*****IP Version: {}", (Object)this.mcpttData.getIpVersion());
                } else if (attributeType == 1) {
                    additionalData = new StringBuilder();
                    for (k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setTmgiStr(additionalData.toString());
                    logger.debug("*****Temporary Mobile Group Identity: {}", (Object)this.mcpttData.getTmgiStr());
                } else if (attributeType == 2) {
                    additionalData = new StringBuilder();
                    for (k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setMcpttGroupSipURIStr(additionalData.toString());
                    logger.debug("*****MCPTT Group Identity : {}", (Object)this.mcpttData.getMcpttGroupSipURIStr());
                } else if (attributeType == 3) {
                    this.mcpttData.setMonitoringState((int)attributeData[0]);
                    logger.debug("*****Monitoring State : {}", (Object)this.mcpttData.getMonitoringState());
                } else {
                    logger.debug("Not Received MCMC RTCP Packet");
                }
                logger.debug("MCPTT Packet Received {}", (Object)this.mcpttData);
            }
        } else if ("ALIV".equals(this.receivedAPPName)) {
            for (int i = 12; i < updatedLengthValue; ++i) {
                byte attributeType = this.rawDataReceived[i];
                int attributeLength = this.rawDataReceived[++i];
                ByteArrayOutputStream attributeDataBuffer = new ByteArrayOutputStream();
                for (int j = 0; j < attributeLength; ++j) {
                    attributeDataBuffer.write(this.rawDataReceived[++i]);
                }
                byte[] attributeData = attributeDataBuffer.toByteArray();
                if (attributeType != 0) continue;
                StringBuilder additionalData = new StringBuilder();
                for (int k = 0; k < attributeData.length; ++k) {
                    if (attributeData[k] == 0) continue;
                    additionalData.append((char)attributeData[k]);
                }
                this.mcpttData.setCustomData(additionalData.toString());
                logger.debug("*****Custom Data : {}", (Object)this.mcpttData.getCustomData());
            }
        } else {
            for (int i = 12; i < updatedLengthValue; ++i) {
                byte attributeType = this.rawDataReceived[i];
                int attributeLength = this.rawDataReceived[++i];
                ByteArrayOutputStream attributeDataBuffer = new ByteArrayOutputStream();
                for (int j = 0; j < attributeLength; ++j) {
                    attributeDataBuffer.write(this.rawDataReceived[++i]);
                }
                byte[] attributeData = attributeDataBuffer.toByteArray();
                if (attributeType == 0) {
                    this.mcpttData.setTransmissionPriority((int)attributeData[0]);
                    logger.debug("*****TransmissionPriority:{}", (Object)this.mcpttData.getTransmissionPriority());
                } else if (attributeType == 1) {
                    int durationValue = attributeData[0] << 8 | attributeData[1];
                    this.mcpttData.setDuration(durationValue);
                    logger.debug("*****Duration Field value:{}", (Object)this.mcpttData.getDuration());
                } else if (attributeType == 2) {
                    this.mcpttData.getRejectCause().setCause((attributeData[0] | attributeData[1]) & 0xFF);
                    logger.debug("*****Reject Cause:{}", (Object)this.mcpttData.getRejectCause().getCause());
                    StringBuilder additionalData = new StringBuilder(0);
                    if (attributeLength > 2) {
                        for (int k = 2; k < attributeLength; ++k) {
                            if (attributeData[k] == 0) continue;
                            additionalData.append((char)attributeData[k]);
                        }
                    }
                    this.mcpttData.getRejectCause().setMessage(additionalData.toString());
                } else if (attributeType == 3) {
                    this.mcpttData.getQueueInfo().setQueuePositionInfo(attributeData[0] & 0xFF);
                    this.mcpttData.getQueueInfo().setQueuePositionLevel(attributeData[1] & 0xFF);
                    logger.debug("*****Queue Info Filed:{},{}", (Object)this.mcpttData.getQueueInfo().getQueuePositionInfo(), (Object)this.mcpttData.getQueueInfo().getQueuePositionLevel());
                } else if (attributeType == 4) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setGrantedPartyIdentity(additionalData.toString());
                    logger.debug("*****GrantedParty : {}", (Object)this.mcpttData.getGrantedPartyIdentity());
                } else if (attributeType == 5) {
                    int permissionValue = attributeData[0] << 8 | attributeData[1];
                    this.mcpttData.setTransmissionPermissionRequest(permissionValue);
                    logger.debug("*****Transmission Permission Request Value:{}", (Object)this.mcpttData.getTransmissionPermissionRequest());
                } else if (attributeType == 6) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setUserID(additionalData.toString());
                    logger.debug("*****User ID : {}", (Object)this.mcpttData.getUserID());
                } else if (attributeType == 7) {
                    this.mcpttData.setQueueSize(attributeData[0] | attributeData[1]);
                    logger.debug("******QueueSize :{}", (Object)this.mcpttData.getQueueSize());
                } else if (attributeType == 8) {
                    this.mcpttData.setMessageSequence(attributeData[0] | attributeData[1]);
                    logger.debug("******Message Sequence :{}", (Object)this.mcpttData.getMessageSequence());
                } else if (attributeType == 9) {
                    StringBuilder additionalData = new StringBuilder();
                    if (attributeLength > 2) {
                        for (int j = 0; j < attributeData.length; ++j) {
                            if (attributeData[j] == 0) continue;
                            additionalData.append((char)attributeData[j]);
                        }
                    }
                    this.mcpttData.setQueueUserIDValue(additionalData.toString());
                    logger.debug("******Queue UserID value:{}", (Object)this.mcpttData.getQueueUserIDValue());
                } else if (attributeType == 10) {
                    this.mcpttData.setSourceIdValue(attributeData[0] | attributeData[1]);
                    logger.debug("******SourceId Value :{}", (Object)this.mcpttData.getSourceIdValue());
                } else if (attributeType == 11) {
                    this.mcpttData.getTrackInfo().setQueueingCapability((int)attributeData[0]);
                    int participantTypeLen = attributeData[1];
                    StringBuilder additionalData = new StringBuilder();
                    if (attributeLength > 2) {
                        int k = 2;
                        for (int l = 0; k < attributeLength && l < participantTypeLen; ++k, ++l) {
                            if (attributeData[k] == 0) continue;
                            additionalData.append((char)attributeData[k]);
                        }
                    }
                    this.mcpttData.getTrackInfo().setParticipantValue(additionalData.toString());
                    logger.debug("*****TrackInfo value {}", (Object)this.mcpttData.getTrackInfo().getParticipantValue());
                } else if (attributeType == 12) {
                    this.mcpttData.setMessageType(attributeData[0] | attributeData[1]);
                    logger.debug("******Message Type :{}", (Object)this.mcpttData.getMessageType());
                } else if (attributeType == 13) {
                    char TransmissionValue = (char)(attributeData[0] << 8 | attributeData[1]);
                    this.mcpttData.setTransmissionIndicatorValue((int)TransmissionValue);
                    logger.debug("*****Transmission Indicator value:{}", (Object)this.mcpttData.getTransmissionIndicatorValue());
                } else if (attributeType == 14) {
                    byte[] ssrcGrantedBytes = new byte[]{attributeData[0], attributeData[1], attributeData[2], attributeData[3]};
                    int ssrcGrantedValue = (ssrcGrantedBytes[0] & 0xFF) << 24 | (ssrcGrantedBytes[1] & 0xFF) << 16 | (ssrcGrantedBytes[2] & 0xFF) << 8 | ssrcGrantedBytes[3] & 0xFF;
                    logger.debug("ssrc granted Value:{}", (Object)ssrcGrantedValue);
                    this.mcpttData.setSsrcOfGrantedParticipant(ssrcGrantedValue);
                    this.mcpttData.setSpareByte(attributeData[4] | attributeData[5]);
                    logger.debug("*****SSRC of participant :{}", (Object)this.mcpttData.getSsrcOfGrantedParticipant());
                } else if (attributeType == 15) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setGrantedUserValue(additionalData.toString());
                    logger.debug("Value of granted users:{}", (Object)this.mcpttData.getGrantedUserValue());
                } else if (attributeType == 16) {
                    StringBuilder additionalData = new StringBuilder();
                    for (int k = 0; k < attributeData.length; ++k) {
                        if (attributeData[k] == 0) continue;
                        additionalData.append((char)attributeData[k]);
                    }
                    this.mcpttData.setMessageNameValue(additionalData.toString());
                    logger.debug("Message Name Value:{}", (Object)this.mcpttData.getMessageNameValue());
                } else if (attributeType != 17 && attributeType != 18 && attributeType != 19 && attributeType != 20) {
                    logger.debug("Not Received MCPT RTCP Packet");
                }
                logger.debug("MCPTT Packet Received {}", (Object)this.mcpttData);
            }
        }
        return this.mcpttData;
    }
}

