/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.mcx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MCPCDisConnect {
    private static final Logger logger = LogManager.getLogger(MCPCDisConnect.class);
    private static final int rtcpHeaderSize = 8;
    private static final int rtcpPayloadType = 204;
    private static final String name = "MCPC";

    private byte setHeader() {
        int mcptType = 1;
        int rtcpVersion = 2;
        int padding = 0;
        byte rtcpVersionByte = (byte)(rtcpVersion << 6 & 0xC0);
        byte paddingByte = (byte)(padding << 5 & 0x20);
        byte mcptTypeByte = (byte)(mcptType & 0x1F);
        byte returnValue = (byte)(rtcpVersionByte | paddingByte | mcptTypeByte);
        return returnValue;
    }

    private byte[] setByteTotalLength(int value) {
        byte rtcpLengthByte1 = (byte)(value >> 8 & 0xFF);
        byte rtcpLengthByte2 = (byte)(value & 0xFF);
        byte[] returnValue = new byte[]{rtcpLengthByte1, rtcpLengthByte2};
        return returnValue;
    }

    private byte[] setByteSSRCName(int ssrc) {
        byte ssrcByte1 = (byte)(ssrc >> 24 & 0xFF);
        byte ssrcByte2 = (byte)(ssrc >> 16 & 0xFF);
        byte ssrcByte3 = (byte)(ssrc >> 8 & 0xFF);
        byte ssrcByte4 = (byte)(ssrc & 0xFF);
        byte[] returnValue = new byte[]{ssrcByte1, ssrcByte2, ssrcByte3, ssrcByte4};
        return returnValue;
    }

    private static byte[] setMCPTTSessionField(String mcpttSessionIDStr) {
        boolean McpttSessionID = true;
        boolean sessionType = true;
        int origLen = mcpttSessionIDStr.length();
        if (origLen % 4 == 0) {
            mcpttSessionIDStr = mcpttSessionIDStr + "\u0000";
            origLen = mcpttSessionIDStr.length();
        } else if (origLen % 4 != 1) {
            int remainder = origLen % 4;
            int paddingLength = remainder + 1;
            for (int i = 0; i < paddingLength; ++i) {
                mcpttSessionIDStr = mcpttSessionIDStr + "\u0000";
            }
            origLen = mcpttSessionIDStr.length();
        }
        int mcpttSessionIDLength = origLen + 1;
        byte[] mcpttSessionIdStrData = mcpttSessionIDStr.getBytes();
        byte[] mcpttSessionFieldID = new byte[2 + mcpttSessionIDLength];
        mcpttSessionFieldID[0] = (byte)(McpttSessionID ? 1 : 0);
        mcpttSessionFieldID[1] = (byte)mcpttSessionIDLength;
        mcpttSessionFieldID[2] = (byte)(sessionType ? 1 : 0);
        System.arraycopy(mcpttSessionIdStrData, 0, mcpttSessionFieldID, 3, mcpttSessionIdStrData.length);
        return mcpttSessionFieldID;
    }

    public byte[] send(int ssrcValue, String mcpttSessionIDStr) {
        byte[] appData = "MCPC".getBytes();
        byte[] sSRCField = this.setByteSSRCName(ssrcValue);
        byte[] mcpttSessionField = MCPCDisConnect.setMCPTTSessionField((String)mcpttSessionIDStr);
        int totalRtcpLength = (8 + mcpttSessionField.length) / 4;
        byte[] rtcpLength = this.setByteTotalLength(totalRtcpLength);
        byte[] packet = new byte[8 + appData.length + mcpttSessionField.length];
        packet[0] = this.setHeader();
        packet[1] = -52;
        System.arraycopy(rtcpLength, 0, packet, 2, rtcpLength.length);
        System.arraycopy(sSRCField, 0, packet, 2 + rtcpLength.length, sSRCField.length);
        System.arraycopy(appData, 0, packet, 2 + rtcpLength.length + sSRCField.length, appData.length);
        System.arraycopy(mcpttSessionField, 0, packet, 2 + rtcpLength.length + sSRCField.length + appData.length, mcpttSessionField.length);
        logger.debug("RTCP packet sent");
        return packet;
    }
}

