/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.helper;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.mcx.Heartbeat;
import com.coraltele.ppdrconference.mcx.HeartbeatOk;
import com.coraltele.ppdrconference.mcx.MBMSMapBearer;
import com.coraltele.ppdrconference.mcx.MBMSUnMapBearer;
import com.coraltele.ppdrconference.mcx.MCMCAppPagingMessage;
import com.coraltele.ppdrconference.mcx.MCPCAck;
import com.coraltele.ppdrconference.mcx.MCPCBroadcastConnect;
import com.coraltele.ppdrconference.mcx.MCPCBroadcastTextMessage;
import com.coraltele.ppdrconference.mcx.MCPCConnect;
import com.coraltele.ppdrconference.mcx.MCPCDisConnect;
import com.coraltele.ppdrconference.mcx.McptFloorAck;
import com.coraltele.ppdrconference.mcx.McptFloorDeny;
import com.coraltele.ppdrconference.mcx.McptFloorGranted;
import com.coraltele.ppdrconference.mcx.McptFloorIdle;
import com.coraltele.ppdrconference.mcx.McptFloorQueuePositionInfo;
import com.coraltele.ppdrconference.mcx.McptFloorQueuePositionRequest;
import com.coraltele.ppdrconference.mcx.McptFloorRelease;
import com.coraltele.ppdrconference.mcx.McptFloorReleaseMultiTalker;
import com.coraltele.ppdrconference.mcx.McptFloorRequest;
import com.coraltele.ppdrconference.mcx.McptFloorRevoke;
import com.coraltele.ppdrconference.mcx.McptFloorTaken;
import com.coraltele.ppdrconference.mcx.mcvideo.TransmissionArbitrationTaken;
import com.coraltele.ppdrconference.mcx.mcvideo.TransmissionControlAck;
import com.coraltele.ppdrconference.mcx.mcvideo.TransmissionGranted;
import com.coraltele.ppdrconference.mcx.mcvideo.TransmissionRejected;
import com.coraltele.ppdrconference.mcx.mcvideo.TransmissionRelease;
import com.coraltele.ppdrconference.mcx.mcvideo.TransmissionRequest;
import com.coraltele.ppdrconference.model.PTTData;
import com.coraltele.ppdrconference.model.RTCPPacket;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.service.RTCPCommunicationService;
import com.coraltele.ppdrconference.ws.MessagingHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCXHelper {
    private static final Logger logger = LogManager.getLogger(MCXHelper.class);

    public static RequestResponse sendRTCPPacket(RTCPPacket packetReceived, String ipAddress, Integer portNumber, String participantNo, String mode, Integer connectionInterface) throws IOException {
        RequestResponse returnValue = new RequestResponse(Integer.valueOf(0), null, null, null, null, null);
        logger.debug("Packet Received in RTCP Server Service for trans mission : {} {} {}", (Object)packetReceived, (Object)ipAddress, (Object)portNumber);
        logger.debug("userName:{}", (Object)packetReceived.getUserIdStrData());
        int ssrc = packetReceived.getSsrcValue();
        int floorVal = packetReceived.getFloorValue();
        String userString = packetReceived.getUserIdStrData();
        String participantVal = packetReceived.getParticipantTypeValue();
        String functionalAliStr = packetReceived.getFunctionalAliasValue();
        char floorIndBit = packetReceived.getFloorIndicatorBit();
        int locationType = packetReceived.getLocationType();
        int durationVal = packetReceived.getDurationValue();
        int rejectCauseVal = packetReceived.getRejectCauseValue();
        int ssrcIDVal = packetReceived.getSsrcIdValue();
        int queueSizeVal = packetReceived.getQueueSizeValue();
        int queuedSsrcVal = packetReceived.getQueuedSsrcValue();
        String queuedUsersVal = packetReceived.getQueuedUsersValue();
        int queuePositionInfo = packetReceived.getQueuePositionInfo();
        int queuePositionLevel = packetReceived.getQueuePositionLevel();
        int messageSequenceVal = packetReceived.getMessageSequenceValue();
        int ssrcGrantedVal = packetReceived.getSsrcGrantedValue();
        int locationVal = packetReceived.getLocationValue();
        String grantedPartyIdentityStr = packetReceived.getGrantedPartyIdentityStr();
        int permissionRequestFloorValue = packetReceived.getPermissionRequestFloorValue();
        int messageTypeVal = packetReceived.getMessageType();
        int sourceIdVal = packetReceived.getSourceIdValue();
        String mcpttSessionIDStr = packetReceived.getMcpttSessionIDStr();
        String mcpttGroupIDStr = packetReceived.getMcpttGroupIDStr();
        int mediaControlChannelValue = packetReceived.getMediaControlChannelValue();
        String warningText = packetReceived.getWarningText();
        int answerState = packetReceived.getAnswerState();
        String invitingMcpttUserName = packetReceived.getUserIdStrData();
        String pckIMessageKey = packetReceived.getInvitingMcpttUserID();
        int reasonCodeValue = packetReceived.getReasonCodeValue();
        String tmgiStrValue = packetReceived.getTmgiStrValue();
        String mcpttGroupSipURIStrValue = packetReceived.getMcpttGroupSipURIStrValue();
        byte[] dataToSend = null;
        int subType = packetReceived.getSubType();
        try {
            if (mode == null) {
                mode = "";
            }
            if (mode.equals("tel")) {
                logger.debug("TEL mode is not supported");
            } else if (mode.equals("http")) {
                ObjectMapper mapper = new ObjectMapper();
                String currentUser = participantNo;
                String notificationToSend = mapper.writeValueAsString((Object)packetReceived);
                logger.debug("Send Response Websocket to  {} : {}", (Object)currentUser, (Object)notificationToSend);
                MessagingHelper.getMessagingTemplate().convertAndSend((Object)String.format("/app/v1/messaging/topic/user-%s", currentUser), (Object)notificationToSend);
            } else {
                if ("MCPT".equals(packetReceived.getAppName())) {
                    switch (subType) {
                        case 0: {
                            McptFloorRequest mcptFloorRequest = new McptFloorRequest();
                            dataToSend = mcptFloorRequest.send(ssrc, floorVal, userString, participantVal, floorIndBit, functionalAliStr, locationVal);
                            break;
                        }
                        case 1: {
                            McptFloorGranted mcptFloorGranted = new McptFloorGranted();
                            dataToSend = mcptFloorGranted.send(ssrc, durationVal, ssrcIDVal, floorVal, userString, queueSizeVal, queuedSsrcVal, queuedUsersVal, queuePositionInfo, queuePositionLevel, participantVal, floorIndBit);
                            break;
                        }
                        case 2: {
                            McptFloorTaken mcptFloorTaken = new McptFloorTaken();
                            dataToSend = mcptFloorTaken.send(ssrc, grantedPartyIdentityStr, permissionRequestFloorValue, messageSequenceVal, floorIndBit, ssrcGrantedVal, functionalAliStr, locationType);
                            break;
                        }
                        case 3: {
                            McptFloorDeny mcptFloorDeny = new McptFloorDeny();
                            dataToSend = mcptFloorDeny.send(ssrc, rejectCauseVal, userString, participantVal, floorIndBit);
                            break;
                        }
                        case 4: {
                            McptFloorRelease mcptFloorRelease = new McptFloorRelease();
                            dataToSend = mcptFloorRelease.send(ssrc, userString, participantVal, floorIndBit);
                            break;
                        }
                        case 5: {
                            McptFloorIdle mcptFloorIdle = new McptFloorIdle();
                            dataToSend = mcptFloorIdle.send(ssrc, messageTypeVal, participantVal, floorIndBit);
                            break;
                        }
                        case 6: {
                            McptFloorRevoke mcptFloorRevoke = new McptFloorRevoke();
                            dataToSend = mcptFloorRevoke.send(ssrc, rejectCauseVal, participantVal, floorIndBit);
                            break;
                        }
                        case 8: {
                            McptFloorQueuePositionRequest mcptFloorQueuePositionRequest = new McptFloorQueuePositionRequest();
                            dataToSend = mcptFloorQueuePositionRequest.send(ssrc, userString, participantVal);
                            break;
                        }
                        case 9: {
                            McptFloorQueuePositionInfo mcptFloorQueuePositionInfo = new McptFloorQueuePositionInfo();
                            dataToSend = mcptFloorQueuePositionInfo.send(ssrc, userString, floorVal, queuedUsersVal, queuePositionInfo, queuePositionLevel, participantVal, floorIndBit);
                            break;
                        }
                        case 10: {
                            McptFloorAck mcptFloorAck = new McptFloorAck();
                            dataToSend = mcptFloorAck.send(ssrc, messageTypeVal, sourceIdVal, participantVal, locationVal);
                            break;
                        }
                        case 15: {
                            McptFloorReleaseMultiTalker mcptFloorReleaseMultiTalker = new McptFloorReleaseMultiTalker();
                            dataToSend = mcptFloorReleaseMultiTalker.send(ssrc, userString, participantVal, floorIndBit);
                            break;
                        }
                        default: {
                            logger.debug("Received SubType is invalid: {}", (Object)subType);
                            break;
                        }
                    }
                } else if ("MCPC".equals(packetReceived.getAppName())) {
                    switch (subType) {
                        case 0: {
                            MCPCConnect mcpcConnect = new MCPCConnect();
                            dataToSend = mcpcConnect.send(ssrc, mcpttSessionIDStr, mcpttGroupIDStr, mediaControlChannelValue, warningText, answerState, invitingMcpttUserName, pckIMessageKey);
                            logger.debug("MCPC connect packet value:{}", (Object)dataToSend);
                            break;
                        }
                        case 1: {
                            MCPCDisConnect mcpcDisConnect = new MCPCDisConnect();
                            dataToSend = mcpcDisConnect.send(ssrc, mcpttSessionIDStr);
                            break;
                        }
                        case 2: {
                            MCPCAck mcpcAck = new MCPCAck();
                            dataToSend = mcpcAck.send(ssrc, reasonCodeValue);
                            break;
                        }
                        case 3: {
                            MCPCBroadcastConnect mcpcBroadcastConnect = new MCPCBroadcastConnect();
                            dataToSend = mcpcBroadcastConnect.send(ssrc, mcpttSessionIDStr, mcpttGroupIDStr, mediaControlChannelValue, warningText, answerState, invitingMcpttUserName, pckIMessageKey);
                            logger.debug("MCPC broadcast connect packet value:{}", (Object)dataToSend);
                            break;
                        }
                        case 4: {
                            MCPCBroadcastTextMessage mcpcBroadcastTextMessage = new MCPCBroadcastTextMessage();
                            dataToSend = mcpcBroadcastTextMessage.send(ssrc, mcpttSessionIDStr, mcpttGroupIDStr, mediaControlChannelValue, warningText, answerState, invitingMcpttUserName, pckIMessageKey);
                            logger.debug("MCPC broadcast connect packet value:{}", (Object)dataToSend);
                            break;
                        }
                        default: {
                            logger.debug("Received SubType is invalid: {}", (Object)subType);
                            break;
                        }
                    }
                } else if ("MCMC".equals(packetReceived.getAppName())) {
                    switch (subType) {
                        case 0: {
                            MBMSMapBearer mapBearer = new MBMSMapBearer();
                            dataToSend = mapBearer.send(ssrc, mcpttGroupIDStr, tmgiStrValue, 1);
                            break;
                        }
                        case 1: {
                            MBMSUnMapBearer mbmsUnMapBearer = new MBMSUnMapBearer();
                            dataToSend = mbmsUnMapBearer.send(ssrc, mcpttGroupSipURIStrValue);
                            break;
                        }
                        case 2: {
                            MCMCAppPagingMessage mcmcAppPagingMessage = new MCMCAppPagingMessage();
                            dataToSend = mcmcAppPagingMessage.send(ssrc, mcpttGroupSipURIStrValue);
                            break;
                        }
                        default: {
                            logger.debug("Received SubType is invalid: {}", (Object)subType);
                            break;
                        }
                    }
                } else if ("MCV0".equals(packetReceived.getAppName())) {
                    switch (subType) {
                        case 0: {
                            TransmissionRequest transmissionRequest = new TransmissionRequest();
                            dataToSend = transmissionRequest.send(ssrc, floorVal, userString, floorIndBit);
                            break;
                        }
                        case 2: {
                            TransmissionRelease transmissionRelease = new TransmissionRelease();
                            dataToSend = transmissionRelease.send(ssrc, userString, floorIndBit);
                            break;
                        }
                        default: {
                            logger.debug("Received SubType is invalid: {}", (Object)subType);
                            break;
                        }
                    }
                } else if ("MCV1".equals(packetReceived.getAppName())) {
                    switch (subType) {
                        case 0: {
                            TransmissionGranted transmissionGranted = new TransmissionGranted();
                            dataToSend = transmissionGranted.send(ssrc, durationVal, ssrcIDVal, floorVal, userString, queueSizeVal, queuedSsrcVal, queuedUsersVal, queuePositionInfo, queuePositionLevel, floorIndBit);
                            break;
                        }
                        case 1: {
                            TransmissionRejected transmissionRejected = new TransmissionRejected();
                            dataToSend = transmissionRejected.send(ssrc, rejectCauseVal, userString, floorIndBit);
                            break;
                        }
                        case 2: {
                            TransmissionArbitrationTaken transmissionArbitrationTaken = new TransmissionArbitrationTaken();
                            dataToSend = transmissionArbitrationTaken.send(ssrc, grantedPartyIdentityStr, permissionRequestFloorValue, messageSequenceVal, floorIndBit, ssrcGrantedVal);
                            break;
                        }
                        default: {
                            logger.debug("Received SubType is invalid: {}", (Object)subType);
                            break;
                        }
                    }
                } else if ("MCV2".equals(packetReceived.getAppName())) {
                    switch (subType) {
                        case 4: {
                            TransmissionControlAck transmissionControlAck = new TransmissionControlAck();
                            dataToSend = transmissionControlAck.send(ssrc, sourceIdVal, messageTypeVal);
                            break;
                        }
                        default: {
                            logger.debug("Received SubType is invalid: {}", (Object)subType);
                            break;
                        }
                    }
                } else if ("ALIV".equals(packetReceived.getAppName())) {
                    switch (subType) {
                        case 0: {
                            Heartbeat heartbeat = new Heartbeat();
                            dataToSend = heartbeat.send(userString);
                            break;
                        }
                        case 1: {
                            HeartbeatOk heartbeatOk = new HeartbeatOk();
                            dataToSend = heartbeatOk.send(userString);
                            break;
                        }
                        default: {
                            logger.debug("Received SubType is invalid: {}", (Object)subType);
                            break;
                        }
                    }
                } else {
                    logger.debug("Received appName is invalid: {}", (Object)subType);
                }
                if (dataToSend != null) {
                    logger.debug("Data to Send: {}", (Object)dataToSend);
                    try {
                        DatagramPacket sendPacket = new DatagramPacket(dataToSend, dataToSend.length, InetAddress.getByName(ipAddress), portNumber);
                        ((RTCPCommunicationService)Constants.rtcpCommunicationService.get()).sendPacket(sendPacket, connectionInterface);
                    }
                    catch (IOException e) {
                        logger.error("Unable to send packet", (Throwable)e);
                    }
                }
            }
            return returnValue;
        }
        catch (Exception e) {
            logger.error("Error in sending packet", (Throwable)e);
            return returnValue;
        }
    }

    public static void sendJSONPacket(PTTData pttData, String ipAddress, Integer portNumber, String participantNo, String mode, Integer connectionInterface) {
        try {
            pttData.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
            pttData.setUserName(participantNo);
            pttData.setDestinationIP(ipAddress);
            pttData.setDestinationPort(portNumber);
            ObjectMapper mapper = new ObjectMapper();
            byte[] dataToSend = mapper.writeValueAsBytes((Object)pttData);
            if (dataToSend != null) {
                logger.debug("Data to Send: {}", (Object)dataToSend);
                DatagramPacket sendPacket = new DatagramPacket(dataToSend, dataToSend.length, InetAddress.getByName(ipAddress), portNumber);
                ((RTCPCommunicationService)Constants.rtcpCommunicationService.get()).sendPacket(sendPacket, connectionInterface);
            }
        }
        catch (Exception e) {
            logger.error("Error in sending packet", (Throwable)e);
        }
    }

    public static void sendJSONPacketOverWebSocket(PTTData pttData, String ipAddress, Integer portNumber, String participantNo, String mode, Integer connectionInterface) {
        try {
            pttData.setTimestamp(Long.valueOf(Instant.now().toEpochMilli()));
            pttData.setUserName(participantNo);
            pttData.setDestinationIP(ipAddress);
            pttData.setDestinationPort(portNumber);
            ObjectMapper mapper = new ObjectMapper();
            String notificationToSend = mapper.writeValueAsString((Object)pttData);
            if (notificationToSend != null) {
                String destinationTopic = String.format("/app/v2/messaging/topic/mcx%s", participantNo);
                if (MessagingHelper.getMessagingTemplate() == null) {
                    logger.debug("SimpMessagingTemplate is null in sendJSONPacketOverWebSocket");
                } else {
                    logger.debug("Send Response Websocket of JSON Packet to  {} : at Topic : {}, JSON : {}", (Object)participantNo, (Object)destinationTopic, (Object)notificationToSend);
                    MessagingHelper.getMessagingTemplate().convertAndSend((Object)destinationTopic, (Object)notificationToSend);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in sending packet", (Throwable)e);
        }
    }
}

