/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;

@Entity
@Immutable
@Subselect(value="SELECT\n    e.extension,\n    COALESCE(e.h264,true) as h264,\n    COALESCE(\n        CASE\n            WHEN p.extension_number IS NOT NULL THEN 99999\n            WHEN o.phone ~ '^\\d+$' THEN o.phone::int\n            ELSE 0\n        END,\n        0\n    ) AS effective_rank,\n    CASE\n        WHEN p.extension_number IS NOT NULL THEN TRUE\n        ELSE FALSE\n    END AS is_priority\nFROM\n    pbx.extensions e\nLEFT JOIN\n     pbx.m_vipmaster o\n    ON e.extension = o.officeext\nLEFT JOIN\n    mcx_dispatcher p\n    ON e.extension = p.extension_number\nORDER BY\n    effective_rank DESC,\n    e.extension")
public class ExtensionRule {
    @Id
    @Column(name="extension")
    private String participantNo;
    @Column(name="h264")
    private Boolean h264Support;
    @Column(name="effective_rank")
    private Integer effectiveRank;
    @Column(name="is_priority")
    private Boolean isPriority;

    @Generated
    public String getParticipantNo() {
        return this.participantNo;
    }

    @Generated
    public Boolean getH264Support() {
        return this.h264Support;
    }

    @Generated
    public Integer getEffectiveRank() {
        return this.effectiveRank;
    }

    @Generated
    public Boolean getIsPriority() {
        return this.isPriority;
    }

    @Generated
    public void setParticipantNo(String participantNo) {
        this.participantNo = participantNo;
    }

    @Generated
    public void setH264Support(Boolean h264Support) {
        this.h264Support = h264Support;
    }

    @Generated
    public void setEffectiveRank(Integer effectiveRank) {
        this.effectiveRank = effectiveRank;
    }

    @Generated
    public void setIsPriority(Boolean isPriority) {
        this.isPriority = isPriority;
    }
}

