/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.controller;

import com.coraltele.ppdrconference.helper.Constants;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.model.TextMessageModel;
import com.coraltele.ppdrconference.model.VideoStreamStatus;
import com.coraltele.ppdrconference.model.VoiceMessageModel;
import com.coraltele.ppdrconference.service.RTCPServerService;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/broadcast/"})
@RestController
public class VoiceMessageController {
    private static final Logger logger = LogManager.getLogger(VoiceMessageController.class);
    @Autowired
    RTCPServerService rtcpServerService;

    @PostMapping(value={"send"})
    public ResponseEntity<RequestResponse> saveVoiceMessage(@RequestBody VoiceMessageModel voiceMessageModel) {
        try {
            logger.info("EventId={} Received broadcast Message: {} ", (Object)Constants.EVENT.API_BROADCAST_VOICE_MESSAGE, (Object)voiceMessageModel);
            RequestResponse returnValue = new RequestResponse();
            String correlationId = UUID.randomUUID().toString();
            this.rtcpServerService.broadcastNotification(correlationId, voiceMessageModel.getBroadcastDialNumber(), voiceMessageModel.getRecipients(), voiceMessageModel.getBroadcastUUID(), voiceMessageModel.getBroadcastSourceNumber(), voiceMessageModel.getBroadcastType(), voiceMessageModel.getMessageFile());
            returnValue.setStatus(Integer.valueOf(0));
            returnValue.setMessage("broadcast message received successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("Error while saving voice message: {}", (Object)e.getMessage(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"sendTextMessage"})
    public ResponseEntity<RequestResponse> sendTextMessage(@RequestBody TextMessageModel textMessage) {
        try {
            logger.info("EventId={} Received broadcast Message: {} ", (Object)Constants.EVENT.API_BROADCAST_TEXT_MESSAGE, (Object)textMessage);
            RequestResponse returnValue = new RequestResponse();
            this.rtcpServerService.broadcastTextMessage(textMessage.getRecipients(), textMessage.getMessageSentBy(), textMessage.getMessageType(), textMessage.getMessage());
            returnValue.setStatus(Integer.valueOf(0));
            returnValue.setMessage("broadcast message received successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("Error while saving voice message: {}", (Object)e.getMessage(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"updateGroupStreamStatus"})
    public ResponseEntity<RequestResponse> updateGroupStreamStatus(@RequestBody VideoStreamStatus videoStreamStatus) {
        try {
            logger.info("EventId={} Received updateGroupStreamStatus: {} ", (Object)Constants.EVENT.API_UPDATE_GROUP_STREAM_STATUS, (Object)videoStreamStatus);
            RequestResponse returnValue = new RequestResponse();
            this.rtcpServerService.updateGroupStreamStatus(videoStreamStatus);
            returnValue.setStatus(Integer.valueOf(0));
            returnValue.setMessage("Group stream status updated successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        catch (Exception e) {
            RequestResponse returnValue = new RequestResponse(Integer.valueOf(-1001), e.getMessage(), null, null, null, null);
            logger.error("Error while updating group stream status: {}", (Object)e.getMessage(), (Object)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }
}

