/*
 * Decompiled with CFR 0.152.
 */
package org.pjsip.pjsua2;

import com.coraltele.ppdrconference.sip.PPDRApp;
import org.pjsip.pjsua2.MediaCoordinate;
import org.pjsip.pjsua2.MediaSize;
import org.pjsip.pjsua2.VideoMedia;
import org.pjsip.pjsua2.VideoWindowHandle;
import org.pjsip.pjsua2.VideoWindowInfo;
import org.pjsip.pjsua2.pjsua2JNI;

public class VideoWindow {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VideoWindow(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(VideoWindow obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(VideoWindow obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                PPDRApp.checkThread((String)"Register AudDevErrorEvent Instance");
                pjsua2JNI.delete_VideoWindow((long)this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VideoWindow(int win_id) {
        this(pjsua2JNI.new_VideoWindow((int)win_id), true);
    }

    public VideoWindowInfo getInfo() throws Exception {
        return new VideoWindowInfo(pjsua2JNI.VideoWindow_getInfo((long)this.swigCPtr, (VideoWindow)this), true);
    }

    public VideoMedia getVideoMedia() throws Exception {
        return new VideoMedia(pjsua2JNI.VideoWindow_getVideoMedia((long)this.swigCPtr, (VideoWindow)this), true);
    }

    public void Show(boolean show) throws Exception {
        pjsua2JNI.VideoWindow_Show((long)this.swigCPtr, (VideoWindow)this, (boolean)show);
    }

    public void setPos(MediaCoordinate pos) throws Exception {
        pjsua2JNI.VideoWindow_setPos((long)this.swigCPtr, (VideoWindow)this, (long)MediaCoordinate.getCPtr((MediaCoordinate)pos), (MediaCoordinate)pos);
    }

    public void setSize(MediaSize size) throws Exception {
        pjsua2JNI.VideoWindow_setSize((long)this.swigCPtr, (VideoWindow)this, (long)MediaSize.getCPtr((MediaSize)size), (MediaSize)size);
    }

    public void rotate(int angle) throws Exception {
        pjsua2JNI.VideoWindow_rotate((long)this.swigCPtr, (VideoWindow)this, (int)angle);
    }

    public void setWindow(VideoWindowHandle win) throws Exception {
        pjsua2JNI.VideoWindow_setWindow((long)this.swigCPtr, (VideoWindow)this, (long)VideoWindowHandle.getCPtr((VideoWindowHandle)win), (VideoWindowHandle)win);
    }

    public void setFullScreen(boolean enabled) throws Exception {
        pjsua2JNI.VideoWindow_setFullScreen((long)this.swigCPtr, (VideoWindow)this, (boolean)enabled);
    }

    public void setFullScreen2(int mode) throws Exception {
        pjsua2JNI.VideoWindow_setFullScreen2((long)this.swigCPtr, (VideoWindow)this, (int)mode);
    }
}

