/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.ws;

import com.coraltele.ppdrconference.model.EventNotification;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.ws.MessagingController;
import com.coraltele.ppdrconference.ws.MessagingHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MessagingService {
    private static final Logger logger = LogManager.getLogger(MessagingController.class);
    private final Integer BROADCAST_VERSION_UPDATE_EVENT = 110001;

    public RequestResponse broadcastMessage(EventNotification eventNotification) {
        logger.info("Broadcasting message: " + eventNotification.getEventMessage());
        RequestResponse requestResponse = new RequestResponse();
        eventNotification.setEventId(this.BROADCAST_VERSION_UPDATE_EVENT);
        eventNotification.setEventDestination("broadcast-event");
        eventNotification.setEventEpoch(Long.valueOf(System.currentTimeMillis()));
        MessagingHelper.sendEvent((EventNotification)eventNotification);
        return requestResponse;
    }

    public RequestResponse sendEvent(EventNotification eventNotification) {
        logger.info("Sending message: " + eventNotification.getEventMessage());
        RequestResponse requestResponse = new RequestResponse();
        eventNotification.setEventEpoch(Long.valueOf(System.currentTimeMillis()));
        MessagingHelper.sendEvent((EventNotification)eventNotification);
        return requestResponse;
    }
}

