/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.ppdrconference.ws;

import com.coraltele.ppdrconference.model.EventNotification;
import com.coraltele.ppdrconference.model.RequestResponse;
import com.coraltele.ppdrconference.ws.MessagingHelper;
import com.coraltele.ppdrconference.ws.MessagingService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/messaging"})
@RestController
public class MessagingController {
    private static final Logger logger = LogManager.getLogger(MessagingController.class);
    @Autowired
    MessagingService messagingService;

    public MessagingController(SimpMessagingTemplate simpMessagingTemplate) {
        MessagingHelper.setMessagingTemplate((SimpMessagingTemplate)simpMessagingTemplate);
    }

    @PostMapping(value={"/broadcast"})
    public ResponseEntity<RequestResponse> postMethodName(@RequestBody EventNotification eventData) {
        logger.info("Broadcasting message: " + eventData.getEventMessage());
        RequestResponse returnValue = this.messagingService.broadcastMessage(eventData);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/send-event"})
    public ResponseEntity<RequestResponse> sendEvent(@RequestBody EventNotification eventData) {
        logger.info("Broadcasting message: " + eventData.getEventMessage());
        RequestResponse returnValue = this.messagingService.sendEvent(eventData);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

